/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.IOException;
import java.nio.file.Path;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableReader;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;

public class ConcordanceSummaryRecord {
    private static final String VARIANT_TYPE_COLUMN_NAME = "type";
    private static final String TRUE_POSITIVE_COLUMN_NAME = "TP";
    private static final String FALSE_POSITIVE_COLUMN_NAME = "FP";
    private static final String FALSE_NEGATIVE_COLUMN_NAME = "FN";
    private static final String SENSITIVITY_COLUMN_NAME = "RECALL";
    private static final String PRECISION_COLUMN_NAME = "PRECISION";
    private static final String[] SUMMARY_TABLE_COLUMN_HEADER = new String[]{"type", "TP", "FP", "FN", "RECALL", "PRECISION"};
    final VariantContext.Type type;
    final long truePositives;
    final long falsePositives;
    final long falseNegatives;

    public ConcordanceSummaryRecord(VariantContext.Type type, long truePositives, long falsePositives, long falseNegatives) {
        this.type = type;
        this.truePositives = truePositives;
        this.falsePositives = falsePositives;
        this.falseNegatives = falseNegatives;
    }

    public VariantContext.Type getVariantType() {
        return this.type;
    }

    public long getTruePositives() {
        return this.truePositives;
    }

    public long getFalsePositives() {
        return this.falsePositives;
    }

    public long getFalseNegatives() {
        return this.falseNegatives;
    }

    public double getSensitivity() {
        return (double)this.truePositives / (double)(this.truePositives + this.falseNegatives);
    }

    public double getPrecision() {
        return (double)this.truePositives / (double)(this.truePositives + this.falsePositives);
    }

    public static Writer getWriter(GATKPath outputTable) {
        try {
            Writer writer = new Writer(outputTable.toPath());
            return writer;
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while reading from %s.", outputTable), e);
        }
    }

    public static class Reader
    extends TableReader<ConcordanceSummaryRecord> {
        public Reader(Path summary) throws IOException {
            super(summary);
        }

        @Override
        protected ConcordanceSummaryRecord createRecord(DataLine dataLine) {
            VariantContext.Type type = VariantContext.Type.valueOf((String)dataLine.get(ConcordanceSummaryRecord.VARIANT_TYPE_COLUMN_NAME));
            long truePositives = Long.parseLong(dataLine.get(ConcordanceSummaryRecord.TRUE_POSITIVE_COLUMN_NAME));
            long falsePositives = Long.parseLong(dataLine.get(ConcordanceSummaryRecord.FALSE_POSITIVE_COLUMN_NAME));
            long falseNegatives = Long.parseLong(dataLine.get(ConcordanceSummaryRecord.FALSE_NEGATIVE_COLUMN_NAME));
            return new ConcordanceSummaryRecord(type, truePositives, falsePositives, falseNegatives);
        }
    }

    public static class Writer
    extends TableWriter<ConcordanceSummaryRecord> {
        private Writer(Path output) throws IOException {
            super(output, new TableColumnCollection(SUMMARY_TABLE_COLUMN_HEADER));
        }

        @Override
        protected void composeLine(ConcordanceSummaryRecord record, DataLine dataLine) {
            dataLine.set(ConcordanceSummaryRecord.VARIANT_TYPE_COLUMN_NAME, record.getVariantType().toString()).set(ConcordanceSummaryRecord.TRUE_POSITIVE_COLUMN_NAME, record.getTruePositives()).set(ConcordanceSummaryRecord.FALSE_POSITIVE_COLUMN_NAME, record.getFalsePositives()).set(ConcordanceSummaryRecord.FALSE_NEGATIVE_COLUMN_NAME, record.getFalseNegatives()).set(ConcordanceSummaryRecord.SENSITIVITY_COLUMN_NAME, record.getSensitivity(), 3).set(ConcordanceSummaryRecord.PRECISION_COLUMN_NAME, record.getPrecision(), 3);
        }
    }
}

