/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.validation.FalsePositiveRecord;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="Count PASS (false positive) variants in a vcf file for Mutect2 NA12878 normal-normal evaluation", oneLineSummary="Count PASS variants", programGroup=VariantEvaluationProgramGroup.class)
@DocumentedFeature
@BetaFeature
public class CountFalsePositives
extends VariantWalker {
    static final String USAGE_ONE_LINE_SUMMARY = "Count PASS variants";
    static final String USAGE_SUMMARY = "Count PASS (false positive) variants in a vcf file for Mutect2 NA12878 normal-normal evaluation";
    @Argument(fullName="output", shortName="O", doc="Output file")
    private GATKPath outputFile = null;
    long indelFalsePositiveCount = 0L;
    long snpFalsePositiveCount = 0L;
    String id;

    @Override
    public boolean requiresIntervals() {
        return true;
    }

    @Override
    public void onTraversalStart() {
        this.id = (String)this.drivingVariantFile.getBaseName().get();
    }

    @Override
    public void apply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        if (variant.isFiltered()) {
            return;
        }
        if (variant.isIndel()) {
            ++this.indelFalsePositiveCount;
        } else {
            ++this.snpFalsePositiveCount;
        }
    }

    @Override
    public Object onTraversalSuccess() {
        List<SimpleInterval> intervals = this.intervalArgumentCollection.getIntervals(this.getReferenceDictionary());
        long targetTerritory = intervals.stream().mapToLong(i -> i.size()).sum();
        try (FalsePositiveTableWriter writer = new FalsePositiveTableWriter(this.outputFile.toPath());){
            FalsePositiveRecord falsePositiveRecord = new FalsePositiveRecord(this.id, this.snpFalsePositiveCount, this.indelFalsePositiveCount, targetTerritory);
            writer.writeRecord(falsePositiveRecord);
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while opening %s", this.outputFile));
        }
        return "SUCCESS";
    }

    private class FalsePositiveTableWriter
    extends TableWriter<FalsePositiveRecord> {
        private FalsePositiveTableWriter(Path output) throws IOException {
            super(output, new TableColumnCollection("id", "snp", "indel", "snp_FPR", "indel_FPR", "target_territory"));
        }

        @Override
        protected void composeLine(FalsePositiveRecord falsePositiveRecord, DataLine dataLine) {
            dataLine.set("id", falsePositiveRecord.getId()).set("snp", falsePositiveRecord.getSnpFalsePositives()).set("indel", falsePositiveRecord.getIndelFalsePositives()).set("snp_FPR", falsePositiveRecord.getSnpFalsePositiveRate()).set("indel_FPR", falsePositiveRecord.getIndelFalsePositiveRate()).set("target_territory", falsePositiveRecord.getTargetTerritory());
        }
    }
}

