/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.collections4.Predicate;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.AbstractConcordanceWalker;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.validation.ConcordanceState;
import org.broadinstitute.hellbender.tools.walkers.validation.InfoConcordanceRecord;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="This tool evaluates info fields from an input VCF against a VCF that has been validated and is considered to represent ground truth.\n", oneLineSummary="Evaluate concordance of info fields in an input VCF against a validated truth VCF", programGroup=VariantEvaluationProgramGroup.class)
@DocumentedFeature
@BetaFeature
public class EvaluateInfoFieldConcordance
extends AbstractConcordanceWalker {
    static final String USAGE_ONE_LINE_SUMMARY = "Evaluate concordance of info fields in an input VCF against a validated truth VCF";
    static final String USAGE_SUMMARY = "This tool evaluates info fields from an input VCF against a VCF that has been validated and is considered to represent ground truth.\n";
    public static final String SUMMARY_LONG_NAME = "summary";
    public static final String SUMMARY_SHORT_NAME = "S";
    @Argument(doc="A table of summary statistics (true positives, sensitivity, etc.)", fullName="summary", shortName="S")
    protected String summary;
    @Argument(fullName="eval-info-key", shortName="eval-info-key", doc="Info key from eval vcf")
    protected String evalInfoKey;
    @Argument(fullName="truth-info-key", shortName="truth-info-key", doc="Info key from truth vcf")
    protected String truthInfoKey;
    @Advanced
    @Argument(fullName="warn-big-differences", shortName="warn-big-differences", doc="If set differences in the info key values greater than epsilon will trigger warnings.", optional=true)
    protected boolean warnBigDifferences = false;
    @Advanced
    @Argument(fullName="epsilon", shortName="epsilon", doc="Difference tolerance", optional=true)
    protected double epsilon = 0.1;
    private int snpCount = 0;
    private int indelCount = 0;
    private double snpSumDelta = 0.0;
    private double snpSumDeltaSquared = 0.0;
    private double indelSumDelta = 0.0;
    private double indelSumDeltaSquared = 0.0;

    @Override
    public void onTraversalStart() {
        if (this.getEvalHeader().getInfoHeaderLine(this.evalInfoKey) == null) {
            throw new UserException("Missing key:" + this.evalInfoKey + " in Eval VCF:" + this.evalVariantsFile);
        }
        if (this.getTruthHeader().getInfoHeaderLine(this.truthInfoKey) == null) {
            throw new UserException("Missing key:" + this.truthInfoKey + " in Truth VCF:" + this.truthVariantsFile);
        }
    }

    @Override
    protected void apply(AbstractConcordanceWalker.TruthVersusEval truthVersusEval, ReadsContext readsContext, ReferenceContext refContext) {
        ConcordanceState concordanceState = truthVersusEval.getConcordance();
        switch (concordanceState) {
            case TRUE_POSITIVE: {
                if (truthVersusEval.getEval().isSNP()) {
                    ++this.snpCount;
                } else if (truthVersusEval.getEval().isIndel()) {
                    ++this.indelCount;
                }
                this.infoDifference(truthVersusEval.getEval(), truthVersusEval.getTruth());
                break;
            }
            case FALSE_POSITIVE: 
            case FALSE_NEGATIVE: 
            case FILTERED_TRUE_NEGATIVE: 
            case FILTERED_FALSE_NEGATIVE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected ConcordanceState: " + concordanceState.toString());
            }
        }
    }

    private void infoDifference(VariantContext eval, VariantContext truth) {
        if (eval.hasAttribute(this.evalInfoKey) && truth.hasAttribute(this.truthInfoKey)) {
            double evalVal = Double.valueOf((String)eval.getAttribute(this.evalInfoKey));
            double truthVal = Double.valueOf((String)truth.getAttribute(this.truthInfoKey));
            double delta = evalVal - truthVal;
            double deltaSquared = delta * delta;
            if (eval.isSNP()) {
                this.snpSumDelta += Math.sqrt(deltaSquared);
                this.snpSumDeltaSquared += deltaSquared;
            } else if (eval.isIndel()) {
                this.indelSumDelta += Math.sqrt(deltaSquared);
                this.indelSumDeltaSquared += deltaSquared;
            }
            if (this.warnBigDifferences && Math.abs(delta) > this.epsilon) {
                this.logger.warn(String.format("Difference (%f) greater than epsilon (%f) at %s:%d %s:", delta, this.epsilon, eval.getContig(), eval.getStart(), eval.getAlleles().toString()));
                this.logger.warn(String.format("\t\tTruth info: " + truth.getAttributes().toString(), new Object[0]));
                this.logger.warn(String.format("\t\tEval info: " + eval.getAttributes().toString(), new Object[0]));
            }
        }
    }

    @Override
    public Object onTraversalSuccess() {
        double snpMean = this.snpSumDelta / (double)this.snpCount;
        double snpVariance = (this.snpSumDeltaSquared - this.snpSumDelta * this.snpSumDelta / (double)this.snpCount) / (double)this.snpCount;
        double snpStd = Math.sqrt(snpVariance);
        double indelMean = this.indelSumDelta / (double)this.indelCount;
        double indelVariance = (this.indelSumDeltaSquared - this.indelSumDelta * this.indelSumDelta / (double)this.indelCount) / (double)this.indelCount;
        double indelStd = Math.sqrt(indelVariance);
        this.logger.info(String.format("SNP average delta %f and standard deviation: %f", snpMean, snpStd));
        this.logger.info(String.format("INDEL average delta %f and standard deviation: %f", indelMean, indelStd));
        try (InfoConcordanceRecord.InfoConcordanceWriter concordanceWriter = InfoConcordanceRecord.getWriter(Paths.get(this.summary, new String[0]));){
            concordanceWriter.writeRecord(new InfoConcordanceRecord(VariantContext.Type.SNP, this.evalInfoKey, this.truthInfoKey, snpMean, snpStd));
            concordanceWriter.writeRecord(new InfoConcordanceRecord(VariantContext.Type.INDEL, this.evalInfoKey, this.truthInfoKey, indelMean, indelStd));
        }
        catch (IOException e) {
            throw new UserException("Encountered an IO exception writing the concordance summary table", e);
        }
        return "SUCCESS";
    }

    @Override
    protected boolean areVariantsAtSameLocusConcordant(VariantContext truth, VariantContext eval) {
        boolean sameRefAllele = truth.getReference().equals((Object)eval.getReference());
        boolean containsAltAllele = eval.getAlternateAlleles().contains(truth.getAlternateAllele(0));
        return sameRefAllele && containsAltAllele;
    }

    @Override
    protected Predicate<VariantContext> makeTruthVariantFilter() {
        return vc -> !vc.isFiltered() && !vc.isSymbolicOrSV();
    }

    @Override
    protected Predicate<VariantContext> makeEvalVariantFilter() {
        return vc -> !vc.isFiltered() && !vc.isSymbolicOrSV();
    }
}

