/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation;

public class FalsePositiveRecord {
    public static final String ID_COLUMN_NAME = "id";
    public static final String SNP_COLUMN_NAME = "snp";
    public static final String INDEL_COLUMN_NAME = "indel";
    public static final String SNP_FPR_COLUMN_NAME = "snp_FPR";
    public static final String INDEL_FPR_COLUMN_NAME = "indel_FPR";
    public static final String TARGET_TERRITORY_COLUMN_NAME = "target_territory";
    private String id;
    private long snpFalsePositives;
    private long indelFalsePositives;
    private long targetTerritory;

    public FalsePositiveRecord(String id, long snpFalsePositives, long indelFalsePositives, long targetTerritory) {
        this.id = id;
        this.snpFalsePositives = snpFalsePositives;
        this.indelFalsePositives = indelFalsePositives;
        this.targetTerritory = targetTerritory;
    }

    public String getId() {
        return this.id;
    }

    public long getSnpFalsePositives() {
        return this.snpFalsePositives;
    }

    public long getIndelFalsePositives() {
        return this.indelFalsePositives;
    }

    public long getTargetTerritory() {
        return this.targetTerritory;
    }

    public double getSnpFalsePositiveRate() {
        return (double)this.snpFalsePositives / (double)this.targetTerritory * 1000000.0;
    }

    public double getIndelFalsePositiveRate() {
        return (double)this.indelFalsePositives / (double)this.targetTerritory * 1000000.0;
    }
}

