/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableReader;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;

public class FilterAnalysisRecord {
    private final String filter;
    private int trueNegativeCount;
    private int falseNegativeCount;
    private int uniqueTrueNegativeCount;
    private int uniqueFalseNegativeCount;

    public FilterAnalysisRecord(String filter, int trueNegativeCount, int falseNegativeCount, int uniqueTrueNegativeCount, int uniqueFalseNegativeCount) {
        this.filter = filter;
        this.trueNegativeCount = trueNegativeCount;
        this.falseNegativeCount = falseNegativeCount;
        this.uniqueTrueNegativeCount = uniqueTrueNegativeCount;
        this.uniqueFalseNegativeCount = uniqueFalseNegativeCount;
    }

    public String getFilter() {
        return this.filter;
    }

    public int getTrueNegativeCount() {
        return this.trueNegativeCount;
    }

    public int getFalseNegativeCount() {
        return this.falseNegativeCount;
    }

    public int getUniqueTrueNegativeCount() {
        return this.uniqueTrueNegativeCount;
    }

    public int getUniqueFalseNegativeCount() {
        return this.uniqueFalseNegativeCount;
    }

    public void incrementTrueNegative() {
        ++this.trueNegativeCount;
    }

    public void incrementFalseNegative() {
        ++this.falseNegativeCount;
    }

    public void incrementUniqueTrueNegative() {
        ++this.uniqueTrueNegativeCount;
    }

    public void incrementUniqueFalseNegative() {
        ++this.uniqueFalseNegativeCount;
    }

    public static void writeToFile(Collection<FilterAnalysisRecord> records, GATKPath outputTable) {
        FilterAnalysisRecord.writeToPath(records, outputTable.toPath());
    }

    public static void writeToPath(Collection<FilterAnalysisRecord> records, Path outputTable) {
        try (FilterAnalysisTableWriter writer = new FilterAnalysisTableWriter(outputTable);){
            writer.writeAllRecords(records);
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while writing to %s.", outputTable));
        }
    }

    public static List<FilterAnalysisRecord> readFromFile(File tableFile) {
        return FilterAnalysisRecord.readFromPath(IOUtils.fileToPath(tableFile));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<FilterAnalysisRecord> readFromPath(Path tablePath) {
        try (FilterAnalysisTableReader reader = new FilterAnalysisTableReader(tablePath);){
            List<FilterAnalysisRecord> list = reader.toList();
            return list;
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while reading from %s.", tablePath));
        }
    }

    private static enum FilterAnalysisTableColumn {
        FILTER("filter"),
        TRUE_NEGATIVES("tn"),
        FALSE_NEGATIVES("fn"),
        UNIQUE_TRUE_NEGATIVES("uniq_tn"),
        UNIQUE_FALSE_NEGATIVES("uniq_fn");

        private final String columnName;
        public static final TableColumnCollection COLUMNS;

        private FilterAnalysisTableColumn(String columnName) {
            this.columnName = Utils.nonNull(columnName);
        }

        public String toString() {
            return this.columnName;
        }

        static {
            COLUMNS = new TableColumnCollection(new Object[]{FILTER, TRUE_NEGATIVES, FALSE_NEGATIVES, UNIQUE_TRUE_NEGATIVES, UNIQUE_FALSE_NEGATIVES});
        }
    }

    private static class FilterAnalysisTableReader
    extends TableReader<FilterAnalysisRecord> {
        public FilterAnalysisTableReader(Path path) throws IOException {
            super(path);
        }

        @Override
        protected FilterAnalysisRecord createRecord(DataLine dataLine) {
            String filter = dataLine.get(FilterAnalysisTableColumn.FILTER);
            int trueNegatives = dataLine.getInt(FilterAnalysisTableColumn.TRUE_NEGATIVES);
            int falseNegatives = dataLine.getInt(FilterAnalysisTableColumn.FALSE_NEGATIVES);
            int uniqueTrueNegatives = dataLine.getInt(FilterAnalysisTableColumn.UNIQUE_TRUE_NEGATIVES);
            int uniqueFalseNegatives = dataLine.getInt(FilterAnalysisTableColumn.UNIQUE_FALSE_NEGATIVES);
            return new FilterAnalysisRecord(filter, trueNegatives, falseNegatives, uniqueTrueNegatives, uniqueFalseNegatives);
        }
    }

    private static class FilterAnalysisTableWriter
    extends TableWriter<FilterAnalysisRecord> {
        private FilterAnalysisTableWriter(Path output) throws IOException {
            super(output, FilterAnalysisTableColumn.COLUMNS);
        }

        @Override
        protected void composeLine(FilterAnalysisRecord record, DataLine dataLine) {
            dataLine.set(FilterAnalysisTableColumn.FILTER.toString(), record.getFilter()).set(FilterAnalysisTableColumn.TRUE_NEGATIVES.toString(), record.getTrueNegativeCount()).set(FilterAnalysisTableColumn.FALSE_NEGATIVES.toString(), record.getFalseNegativeCount()).set(FilterAnalysisTableColumn.UNIQUE_TRUE_NEGATIVES.toString(), record.getUniqueTrueNegativeCount()).set(FilterAnalysisTableColumn.UNIQUE_FALSE_NEGATIVES.toString(), record.getUniqueFalseNegativeCount());
        }
    }
}

