/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.IOException;
import java.nio.file.Path;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableReader;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;

public class InfoConcordanceRecord {
    private static final String VARIANT_TYPE_COLUMN_NAME = "type";
    private static final String EVAL_INFO_KEY = "eval_info_key";
    private static final String TRUE_INFO_KEY = "true_info_key";
    private static final String MEAN_DIFFERENCE = "mean_difference";
    private static final String STD_DIFFERENCE = "std_difference";
    private static final String[] INFO_CONCORDANCE_COLUMN_HEADER = new String[]{"type", "eval_info_key", "true_info_key", "mean_difference", "std_difference"};
    final VariantContext.Type type;
    private final String evalKey;
    private final String trueKey;
    private final double mean;
    private final double std;

    public InfoConcordanceRecord(VariantContext.Type type, String evalKey, String trueKey, double mean, double std) {
        this.type = type;
        this.evalKey = evalKey;
        this.trueKey = trueKey;
        this.mean = mean;
        this.std = std;
    }

    public VariantContext.Type getVariantType() {
        return this.type;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStd() {
        return this.std;
    }

    public String getEvalKey() {
        return this.evalKey;
    }

    public String getTrueKey() {
        return this.trueKey;
    }

    public static InfoConcordanceWriter getWriter(Path outputTable) {
        try {
            InfoConcordanceWriter writer = new InfoConcordanceWriter(outputTable);
            return writer;
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while writing from %s.", outputTable), e);
        }
    }

    public static class InfoConcordanceReader
    extends TableReader<InfoConcordanceRecord> {
        public InfoConcordanceReader(Path summary) throws IOException {
            super(summary);
        }

        @Override
        protected InfoConcordanceRecord createRecord(DataLine dataLine) {
            VariantContext.Type type = VariantContext.Type.valueOf((String)dataLine.get(InfoConcordanceRecord.VARIANT_TYPE_COLUMN_NAME));
            String evalKey = dataLine.get(InfoConcordanceRecord.EVAL_INFO_KEY);
            String trueKey = dataLine.get(InfoConcordanceRecord.TRUE_INFO_KEY);
            double mean = Double.parseDouble(dataLine.get(InfoConcordanceRecord.MEAN_DIFFERENCE));
            double std = Double.parseDouble(dataLine.get(InfoConcordanceRecord.STD_DIFFERENCE));
            return new InfoConcordanceRecord(type, evalKey, trueKey, mean, std);
        }
    }

    public static class InfoConcordanceWriter
    extends TableWriter<InfoConcordanceRecord> {
        private InfoConcordanceWriter(Path output) throws IOException {
            super(output, new TableColumnCollection(INFO_CONCORDANCE_COLUMN_HEADER));
        }

        @Override
        protected void composeLine(InfoConcordanceRecord record, DataLine dataLine) {
            dataLine.set(InfoConcordanceRecord.VARIANT_TYPE_COLUMN_NAME, record.getVariantType().toString()).set(InfoConcordanceRecord.EVAL_INFO_KEY, record.getEvalKey()).set(InfoConcordanceRecord.TRUE_INFO_KEY, record.getTrueKey()).set(InfoConcordanceRecord.MEAN_DIFFERENCE, record.getMean()).set(InfoConcordanceRecord.STD_DIFFERENCE, record.getStd());
        }
    }
}

