/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.Predicate;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.hellbender.engine.AbstractConcordanceWalker;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.validation.ConcordanceState;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="UNSUPPORTED.  FOR EVALUATION ONLY. Merge M2 (eval) calls with MC3 (truth)", oneLineSummary="UNSUPPORTED.  FOR EVALUATION ONLY. Merge M2 calls with MC", programGroup=VariantEvaluationProgramGroup.class)
@ExperimentalFeature
public class MergeMutect2CallsWithMC3
extends AbstractConcordanceWalker {
    @Argument(doc="Merged vcf.", fullName="output", shortName="O")
    protected GATKPath outputVcf;
    public static final String CENTERS_KEY = "CENTERS";
    public static final String M2_CENTER_NAME = "M2";
    public static final String MC3_REF_COUNT_KEY = "NREF";
    public static final String MC3_ALT_COUNT_KEY = "NALT";
    public static final String M2_FILTERS_KEY = "M2_FILTERS";
    public static final VCFInfoHeaderLine M2_FILTERS_HEADER_LINE = new VCFInfoHeaderLine("M2_FILTERS", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "M2 filters applied to variant.");
    private VariantContextWriter vcfWriter;
    private String tumorSample;

    @Override
    protected Predicate<VariantContext> makeTruthVariantFilter() {
        return vc -> true;
    }

    @Override
    protected Predicate<VariantContext> makeEvalVariantFilter() {
        return vc -> true;
    }

    @Override
    protected boolean areVariantsAtSameLocusConcordant(VariantContext truth, VariantContext eval) {
        boolean sameRefAllele = truth.getReference().equals((Object)eval.getReference());
        boolean containsAltAllele = eval.getAlternateAlleles().contains(truth.getAlternateAllele(0));
        return sameRefAllele && containsAltAllele;
    }

    @Override
    public void onTraversalStart() {
        HashSet<Object> headerLines = new HashSet<Object>(this.getTruthHeader().getMetaDataInSortedOrder());
        VCFStandardHeaderLines.addStandardFormatLines(headerLines, (boolean)true, (String[])new String[]{"GT", "AD"});
        headerLines.addAll(this.getDefaultToolVCFHeaderLines());
        headerLines.add(M2_FILTERS_HEADER_LINE);
        this.tumorSample = this.getEvalHeader().getMetaDataLine("tumor_sample").getValue();
        VCFHeader mergedHeader = new VCFHeader(headerLines, Collections.singletonList(this.tumorSample));
        this.vcfWriter = this.createVCFWriter(this.outputVcf);
        this.vcfWriter.writeHeader(mergedHeader);
    }

    @Override
    protected void apply(AbstractConcordanceWalker.TruthVersusEval truthVersusEval, ReadsContext readsContext, ReferenceContext refContext) {
        int[] nArray;
        ConcordanceState concordanceState = truthVersusEval.getConcordance();
        if (truthVersusEval.hasEval()) {
            nArray = truthVersusEval.getEval().getGenotype(this.tumorSample).getAD();
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = truthVersusEval.getTruth().getAttributeAsInt(MC3_REF_COUNT_KEY, 0);
            nArray = nArray2;
            nArray2[1] = truthVersusEval.getTruth().getAttributeAsInt(MC3_ALT_COUNT_KEY, 0);
        }
        int[] tumorAlleleCounts = nArray;
        Genotype tumorGenotype = new GenotypeBuilder(this.tumorSample, truthVersusEval.getTruthIfPresentElseEval().getAlleles()).AD(tumorAlleleCounts).make();
        ArrayList<Genotype> genotypes = new ArrayList<Genotype>(Arrays.asList(tumorGenotype));
        switch (concordanceState) {
            case TRUE_POSITIVE: {
                this.vcfWriter.add(this.makeVariantContextBuilderWithM2Center(truthVersusEval.getTruth()).genotypes(genotypes).make());
                break;
            }
            case FALSE_POSITIVE: {
                VariantContext m2 = truthVersusEval.getEval();
                this.vcfWriter.add(new VariantContextBuilder(m2.getSource(), m2.getContig(), (long)m2.getStart(), (long)m2.getEnd(), (Collection)m2.getAlleles()).attribute(CENTERS_KEY, (Object)M2_CENTER_NAME).genotypes(genotypes).make());
                break;
            }
            case FALSE_NEGATIVE: {
                this.vcfWriter.add(new VariantContextBuilder(truthVersusEval.getTruth()).genotypes(genotypes).make());
                break;
            }
            case FILTERED_TRUE_NEGATIVE: {
                break;
            }
            case FILTERED_FALSE_NEGATIVE: {
                VariantContextBuilder vcb = this.makeVariantContextBuilderWithM2Center(truthVersusEval.getTruth()).attribute(M2_FILTERS_KEY, truthVersusEval.getEval().getFilters().stream().collect(Collectors.toList())).genotypes(genotypes);
                this.vcfWriter.add(vcb.make());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected ConcordanceState: " + concordanceState.toString());
            }
        }
    }

    private VariantContextBuilder makeVariantContextBuilderWithM2Center(VariantContext mc3) {
        List<String> centers = mc3.hasAttribute(CENTERS_KEY) ? mc3.getAttributeAsStringList(CENTERS_KEY, "") : new ArrayList();
        centers.add(M2_CENTER_NAME);
        return new VariantContextBuilder(mc3).attribute(CENTERS_KEY, centers);
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }
}

