/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableReader;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;

public class MixingFraction {
    private final String sample;
    private final double mixingFraction;

    public MixingFraction(String sample, double mixingFraction) {
        this.sample = sample;
        this.mixingFraction = mixingFraction;
    }

    public String getSample() {
        return this.sample;
    }

    public double getMixingFraction() {
        return this.mixingFraction;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<MixingFraction> readMixingFractions(File file) {
        IOUtils.canReadFile(file);
        try (MixingFractionReader reader = new MixingFractionReader(IOUtils.fileToPath(file));){
            List<MixingFraction> list = reader.toList();
            return list;
        }
        catch (FileNotFoundException ex) {
            throw new UserException.CouldNotReadInputFile("Mixing fraction table file not found.", (Exception)ex);
        }
        catch (IOException ex) {
            throw new UserException.CouldNotReadInputFile("Could not read input table.", (Exception)ex);
        }
    }

    public static void writeMixingFractions(List<MixingFraction> mixingFractions, File file) {
        try (MixingFractionWriter writer = new MixingFractionWriter(IOUtils.fileToPath(file));){
            writer.writeAllRecords(mixingFractions);
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while trying to create output file %s.", file));
        }
    }

    private static class MixingFractionReader
    extends TableReader<MixingFraction> {
        public MixingFractionReader(Path path) throws IOException {
            super(path);
        }

        @Override
        protected MixingFraction createRecord(DataLine dataLine) {
            String sample = dataLine.get(MixingFractionTableColumn.SAMPLE);
            double mixingFraction = dataLine.getDouble(MixingFractionTableColumn.MIXING_FRACTION);
            return new MixingFraction(sample, mixingFraction);
        }
    }

    private static class MixingFractionWriter
    extends TableWriter<MixingFraction> {
        public MixingFractionWriter(Path output) throws IOException {
            super(output, MixingFractionTableColumn.COLUMNS);
        }

        @Override
        protected void composeLine(MixingFraction record, DataLine dataLine) {
            dataLine.set(MixingFractionTableColumn.SAMPLE.ordinal(), record.getSample()).set(MixingFractionTableColumn.MIXING_FRACTION.ordinal(), record.getMixingFraction());
        }
    }

    private static enum MixingFractionTableColumn {
        SAMPLE("SAMPLE"),
        MIXING_FRACTION("MIXING_FRACTION");

        private final String columnName;
        public static final TableColumnCollection COLUMNS;

        private MixingFractionTableColumn(String columnName) {
            this.columnName = Utils.nonNull(columnName);
        }

        public String toString() {
            return this.columnName;
        }

        static {
            COLUMNS = new TableColumnCollection((Object[])MixingFractionTableColumn.values());
        }
    }
}

