/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation;

import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.collections4.Predicate;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.engine.AbstractConcordanceWalker;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;
import picard.sam.util.Pair;

@CommandLineProgramProperties(summary="This tool evaluates two GVCF files against each other and produces three histograms:\nTruth block histogram: Indicates the number of occurrence of reference blocks with a given confidence score and length in the truth GVCF\nEval block histogram: Indicates the number of occurrence of reference blocks with a given confidence score and length in the eval GVCF\nConfidence concordance histogram: Reflects the confidence scores of bases in reference blocks in the truth and eval VCF, respectively. An entry of 10 at bin \"80,90\" means that 10 bases in the truth GVCF have a confidence score of 80 while those same bases have a score of 90 in the eval GVCF.\nIn contrast to the Concordance tool, this tool considers all variants, regardless of passing or failing filters.", oneLineSummary="Evaluate GVCF reference block concordance of an input GVCF against a truth GVCF", programGroup=VariantEvaluationProgramGroup.class)
public class ReferenceBlockConcordance
extends AbstractConcordanceWalker {
    public static final String TRUTH_BLOCK_HISTOGRAM_LONG_NAME = "truth-block-histogram";
    public static final String TRUTH_BLOCK_HISTOGRAM_SHORT_NAME = "tbh";
    public static final String EVAL_BLOCK_HISTOGRAM_LONG_NAME = "eval-block-histogram";
    public static final String EVAL_BLOCK_HISTOGRAM_SHORT_NAME = "ebh";
    public static final String CONFIDENCE_CONCORDANCE_HISTOGRAM_LONG_NAME = "confidence-concordance-histogram";
    public static final String CONFIDENCE_CONCORDANCE_HISTOGRAM_SHORT_NAME = "cch";
    static final String USAGE_ONE_LINE_SUMMARY = "Evaluate GVCF reference block concordance of an input GVCF against a truth GVCF";
    static final String USAGE_SUMMARY = "This tool evaluates two GVCF files against each other and produces three histograms:\nTruth block histogram: Indicates the number of occurrence of reference blocks with a given confidence score and length in the truth GVCF\nEval block histogram: Indicates the number of occurrence of reference blocks with a given confidence score and length in the eval GVCF\nConfidence concordance histogram: Reflects the confidence scores of bases in reference blocks in the truth and eval VCF, respectively. An entry of 10 at bin \"80,90\" means that 10 bases in the truth GVCF have a confidence score of 80 while those same bases have a score of 90 in the eval GVCF.\nIn contrast to the Concordance tool, this tool considers all variants, regardless of passing or failing filters.";
    @Argument(doc="A histogram of block lengths and their associated confidence scores for the truth sample", fullName="truth-block-histogram", shortName="tbh")
    protected GATKPath truthBlockHistogramFile;
    @Argument(doc="A histogram of block lengths and their associated confidence scores for the eval sample", fullName="eval-block-histogram", shortName="ebh")
    protected GATKPath evalBlockHistogramFile;
    @Argument(doc="Reflects the confidence scores of bases in reference blocks in the truth and eval VCF, respectively. An entry of 10 at bin \"80,90\" means that 10 bases in the truth GVCF have a confidence score of 80 while those same bases have a score of 90 in the eval GVCF.", fullName="confidence-concordance-histogram", shortName="cch")
    protected GATKPath confidenceConcordanceHistogramFile;
    private final Histogram<String> truthBlockHistogram = new Histogram();
    private final Histogram<String> evalBlockHistogram = new Histogram();
    private final Histogram<String> confidenceConcordanceHistogram = new Histogram();
    private VariantContext currentTruthVariantContext = null;
    private VariantContext currentEvalVariantContext = null;

    @Override
    protected Predicate<VariantContext> makeTruthVariantFilter() {
        return this::isHomRef;
    }

    @Override
    protected Predicate<VariantContext> makeEvalVariantFilter() {
        return this::isHomRef;
    }

    private boolean isHomRef(VariantContext variantContext) {
        return variantContext.getGenotypes().get(0).isHomRef();
    }

    private Pair<Integer, Integer> extractLengthAndGQ(VariantContext variant) {
        if (variant.getGenotypes().size() != 1) {
            throw new IllegalStateException(String.format("A multisample GVCF file was provided, however, only single sample GVCFs are currently supported. This occurred when reading \"%s\".", variant.toStringDecodeGenotypes()));
        }
        Genotype genotype = variant.getGenotype(0);
        return new Pair((Comparable)Integer.valueOf(variant.getLengthOnReference()), (Comparable)Integer.valueOf(genotype.getGQ()));
    }

    @Override
    protected void apply(AbstractConcordanceWalker.TruthVersusEval truthVersusEval, ReadsContext readsContext, ReferenceContext refContext) {
        SimpleInterval evalInterval;
        SimpleInterval truthInterval;
        if (truthVersusEval.hasTruth()) {
            this.currentTruthVariantContext = truthVersusEval.getTruth();
            this.truthBlockHistogram.increment((Comparable)((Object)this.extractLengthAndGQ(truthVersusEval.getTruth()).toString()));
        }
        if (truthVersusEval.hasEval()) {
            this.currentEvalVariantContext = truthVersusEval.getEval();
            this.evalBlockHistogram.increment((Comparable)((Object)this.extractLengthAndGQ(truthVersusEval.getEval()).toString()));
        }
        if (this.currentTruthVariantContext != null && !this.currentTruthVariantContext.overlaps((Locatable)truthVersusEval)) {
            this.currentTruthVariantContext = null;
        }
        if (this.currentEvalVariantContext != null && !this.currentEvalVariantContext.overlaps((Locatable)truthVersusEval)) {
            this.currentEvalVariantContext = null;
        }
        if (this.currentTruthVariantContext != null && this.currentEvalVariantContext != null && (truthInterval = new SimpleInterval((Locatable)this.currentTruthVariantContext)).overlaps(evalInterval = new SimpleInterval((Locatable)this.currentEvalVariantContext))) {
            this.confidenceConcordanceHistogram.increment((Comparable)((Object)new Pair((Comparable)Integer.valueOf(this.currentTruthVariantContext.getGenotype(0).getGQ()), (Comparable)Integer.valueOf(this.currentEvalVariantContext.getGenotype(0).getGQ())).toString()), (double)truthInterval.intersect(evalInterval).getLengthOnReference());
        }
    }

    @Override
    protected boolean areVariantsAtSameLocusConcordant(VariantContext truth, VariantContext eval) {
        return true;
    }

    @Override
    public Object onTraversalSuccess() {
        super.onTraversalSuccess();
        MetricsFile truthBlockMetricsFile = this.getMetricsFile();
        truthBlockMetricsFile.addHistogram(this.truthBlockHistogram);
        truthBlockMetricsFile.write((Writer)new OutputStreamWriter(this.truthBlockHistogramFile.getOutputStream()));
        MetricsFile evalBlockMetricsFile = this.getMetricsFile();
        evalBlockMetricsFile.addHistogram(this.evalBlockHistogram);
        evalBlockMetricsFile.write((Writer)new OutputStreamWriter(this.evalBlockHistogramFile.getOutputStream()));
        MetricsFile confidenceConcordanceMetricsFile = this.getMetricsFile();
        confidenceConcordanceMetricsFile.addHistogram(this.confidenceConcordanceHistogram);
        confidenceConcordanceMetricsFile.write((Writer)new OutputStreamWriter(this.confidenceConcordanceHistogramFile.getOutputStream()));
        return "SUCCESS";
    }
}

