/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import java.util.ArrayDeque;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(summary="Remove indels that are close to each other from a vcf. For any pair of indels that are withinsome minimum allowed distance, both indels are removed, regardless of any intervening non-indel variants.", oneLineSummary="(Internal) Remove indels from the VCF file that are close to each other.", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public class RemoveNearbyIndels
extends VariantWalker {
    public static final String MIN_INDEL_SPACING_NAME = "min-indel-spacing";
    @Argument(fullName="output", shortName="O", doc="The output filtered VCF file", optional=false)
    private final GATKPath outputVcf = null;
    @Argument(fullName="min-indel-spacing", shortName="min-indel-spacing", doc="Minimum spacing between neighboring indels to be emitted", optional=false)
    private int minIndelSpacing = 1;
    private VariantContextWriter vcfWriter;
    private VariantBuffer variantBuffer = new VariantBuffer();

    @Override
    public void onTraversalStart() {
        VCFHeader inputHeader = this.getHeaderForVariants();
        VCFHeader vcfHeader = new VCFHeader(inputHeader.getMetaDataInSortedOrder(), inputHeader.getGenotypeSamples());
        this.getDefaultToolVCFHeaderLines().forEach(arg_0 -> ((VCFHeader)vcfHeader).addMetaDataLine(arg_0));
        this.vcfWriter = this.createVCFWriter(this.outputVcf);
        this.vcfWriter.writeHeader(vcfHeader);
    }

    @Override
    public void apply(VariantContext vc, ReadsContext readsContext, ReferenceContext refContext, FeatureContext fc) {
        this.variantBuffer.add(vc);
    }

    @Override
    public Object onTraversalSuccess() {
        this.variantBuffer.emitRemaining();
        return "SUCCESS";
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }

    private final class VariantBuffer {
        private VariantContext lastIndel = null;
        private final ArrayDeque<VariantContext> buffer = new ArrayDeque();

        public void add(VariantContext vc) {
            if (this.lastIndel == null && vc.isIndel()) {
                this.buffer.add(vc);
                this.lastIndel = vc;
            } else if (this.nearby(this.lastIndel, vc)) {
                if (vc.isIndel()) {
                    this.emitAllNonIndels();
                } else {
                    this.buffer.add(vc);
                }
            } else {
                this.emitAllVariants();
                this.buffer.add(vc);
            }
            this.lastIndel = vc.isIndel() ? vc : this.lastIndel;
        }

        private boolean nearby(VariantContext left, VariantContext right) {
            return left != null && left.getContig().equals(right.getContig()) && right.getStart() - left.getEnd() < RemoveNearbyIndels.this.minIndelSpacing;
        }

        private void emitAllNonIndels() {
            this.buffer.stream().filter(vc -> !vc.isIndel()).forEach(arg_0 -> ((VariantContextWriter)RemoveNearbyIndels.this.vcfWriter).add(arg_0));
            this.buffer.clear();
        }

        private void emitAllVariants() {
            this.buffer.forEach(arg_0 -> ((VariantContextWriter)RemoveNearbyIndels.this.vcfWriter).add(arg_0));
            this.buffer.clear();
        }

        public void emitRemaining() {
            this.buffer.stream().filter(vc -> !vc.isIndel() || !this.nearby(this.lastIndel, (VariantContext)vc) || vc == this.lastIndel).forEach(arg_0 -> ((VariantContextWriter)RemoveNearbyIndels.this.vcfWriter).add(arg_0));
            this.buffer.clear();
        }
    }
}

