/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation.basicshortmutpileup;

import htsjdk.variant.variantcontext.Allele;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public class AllelePileupCounter {
    private final Allele referenceAllele;
    private final List<Allele> alternateAlleles;
    private int minBaseQualityCutoff;
    private Map<Allele, MutableInt> countMap = new HashMap<Allele, MutableInt>();

    public AllelePileupCounter(Allele referenceAllele, List<Allele> alternateAlleles, int minBaseQualityCutoff) {
        this.referenceAllele = Utils.nonNull(referenceAllele);
        this.alternateAlleles = Utils.nonNull(alternateAlleles);
        if (referenceAllele.isSymbolic()) {
            throw new UserException.BadInput("A symbolic reference allele was specified.");
        }
        Utils.validateArg(!referenceAllele.isNonReference(), "Reference allele was non-reference: " + referenceAllele);
        Utils.validateArg(alternateAlleles.stream().allMatch(a -> a.isNonReference()), "One or more alternate alleles were reference: " + alternateAlleles.stream().map(a -> a.toString()).collect(Collectors.joining(", ")));
        this.minBaseQualityCutoff = ParamUtils.isPositiveOrZero(minBaseQualityCutoff, "Minimum base quality must be positive or zero.");
        alternateAlleles.forEach(a -> this.countMap.put((Allele)a, new MutableInt(0)));
        this.countMap.put(referenceAllele, new MutableInt(0));
    }

    public AllelePileupCounter(Allele referenceAllele, List<Allele> alternateAlleles, int minBaseQualityCutoff, ReadPileup readPileup) {
        this(referenceAllele, alternateAlleles, minBaseQualityCutoff);
        this.addPileup(readPileup);
    }

    public void addPileup(ReadPileup pileup) {
        if (pileup != null && !this.referenceAllele.isSymbolic()) {
            Utils.stream(pileup).filter(pe -> AllelePileupCounter.isUsableRead(pe.getRead())).forEach(pe -> AllelePileupCounter.incrementAlleleCountMap(pe, this.referenceAllele, this.alternateAlleles, this.minBaseQualityCutoff, this.countMap));
        }
    }

    private static boolean isUsableRead(GATKRead read) {
        return read.getMappingQuality() != 0 && read.getMappingQuality() != 255;
    }

    private static void incrementAlleleCountMap(PileupElement pileupElement, Allele referenceAllele, List<Allele> altAlleles, int minBaseQualityCutoff, Map<Allele, MutableInt> countMap) {
        ParamUtils.isPositiveOrZero(minBaseQualityCutoff, "Minimum base quality must be positive or zero.");
        Utils.nonNull(countMap);
        Utils.nonNull(referenceAllele);
        Utils.nonNull(altAlleles);
        Utils.nonNull(pileupElement);
        Allele pileupAllele = GATKVariantContextUtils.chooseAlleleForRead(pileupElement, referenceAllele, altAlleles, minBaseQualityCutoff);
        if (pileupAllele != null && countMap.containsKey(pileupAllele)) {
            countMap.get(pileupAllele).increment();
        }
    }

    public Map<Allele, MutableInt> getCountMap() {
        return this.countMap;
    }
}

