/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation.basicshortmutpileup;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hdf5.Utils;
import org.broadinstitute.hellbender.tools.walkers.validation.basicshortmutpileup.BasicValidationResult;
import org.broadinstitute.hellbender.tools.walkers.validation.basicshortmutpileup.PowerCalculationUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public class BasicSomaticShortMutationValidator {
    private static final Logger logger = LogManager.getLogger(BasicSomaticShortMutationValidator.class);
    private static final List<VariantContext.Type> VALIDATABLE_TYPES = Arrays.asList(VariantContext.Type.SNP, VariantContext.Type.MNP, VariantContext.Type.INDEL);

    private BasicSomaticShortMutationValidator() {
    }

    public static boolean isAbleToValidateGenotype(Genotype genotype, Allele referenceAllele) {
        boolean isValidateable;
        Utils.nonNull((Object)genotype);
        Utils.nonNull((Object)referenceAllele);
        boolean isDiploid = genotype.getAlleles().size() == 2;
        boolean doesGenotypeHaveReference = genotype.getAllele(0).equals((Object)referenceAllele);
        boolean isReferenceNotSymbolic = !referenceAllele.isSymbolic();
        VariantContext.Type variantType = GATKVariantContextUtils.typeOfVariant(genotype.getAllele(0), genotype.getAllele(1));
        boolean isValidatableVariantType = VALIDATABLE_TYPES.contains(variantType) && !GATKVariantContextUtils.isComplexIndel(genotype.getAllele(0), genotype.getAllele(1));
        boolean hasKnownCoverage = genotype.hasAD() && genotype.getAD().length == 2;
        boolean bl = isValidateable = isDiploid && doesGenotypeHaveReference && isValidatableVariantType && hasKnownCoverage && isReferenceNotSymbolic;
        if (!isValidateable) {
            logger.info("Cannot validate genotype: " + genotype + "  ploidy2: " + isDiploid + "  genotypeHasReferenceAllele: " + doesGenotypeHaveReference + "   validatableVariant: " + isValidatableVariantType + "  hasCompleteAD field: " + hasKnownCoverage + "  isNonSymbolicReference: " + isReferenceNotSymbolic);
        }
        return isValidateable;
    }

    public static BasicValidationResult calculateBasicValidationResult(Genotype genotype, Allele referenceAllele, ReadPileup validationNormalPileup, int validationTumorAltCount, int validationTumorTotalCount, int minBaseQualityCutoff, SimpleInterval interval, String filters) {
        if (!BasicSomaticShortMutationValidator.isAbleToValidateGenotype(genotype, referenceAllele) || validationNormalPileup == null) {
            return null;
        }
        Utils.nonNull((Object)referenceAllele);
        Utils.nonNull((Object)genotype);
        Utils.nonNull((Object)interval);
        Utils.nonNull((Object)filters);
        ParamUtils.isPositiveOrZero(validationTumorAltCount, "Validation alt count must be >= 0");
        ParamUtils.isPositiveOrZero(validationTumorTotalCount, "Validation total count must be >= 0");
        ParamUtils.isPositiveOrZero(minBaseQualityCutoff, "Minimum base quality cutoff must be >= 0");
        double maxAltRatioSeenInNormalValidation = PowerCalculationUtils.calculateMaxAltRatio(validationNormalPileup, referenceAllele, minBaseQualityCutoff);
        int discoveryTumorAltCount = genotype.getAD()[1];
        int discoveryTumorTotalCount = genotype.getAD()[0] + discoveryTumorAltCount;
        if (Double.isNaN(maxAltRatioSeenInNormalValidation) || discoveryTumorTotalCount == 0) {
            return null;
        }
        int minCountForSignal = PowerCalculationUtils.calculateMinCountForSignal(validationTumorTotalCount, maxAltRatioSeenInNormalValidation);
        double power = PowerCalculationUtils.calculatePower(validationTumorTotalCount, discoveryTumorAltCount, discoveryTumorTotalCount, minCountForSignal);
        boolean isNotNoise = validationTumorAltCount >= minCountForSignal;
        boolean isEnoughValidationCoverageToValidate = validationTumorAltCount >= 2;
        String genotypeFilters = genotype.getFilters() == null ? "" : genotype.getFilters();
        long numReadsSupportingAltInValidationNormal = PowerCalculationUtils.calculateNumReadsSupportingAllele(validationNormalPileup, genotype.getAllele(0), genotype.getAllele(1), minBaseQualityCutoff);
        return new BasicValidationResult(interval, minCountForSignal, isEnoughValidationCoverageToValidate, isNotNoise, power, validationTumorAltCount, validationTumorTotalCount - validationTumorAltCount, discoveryTumorAltCount, discoveryTumorTotalCount - discoveryTumorAltCount, referenceAllele, genotype.getAllele(1), filters + genotypeFilters, numReadsSupportingAltInValidationNormal);
    }
}

