/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation.basicshortmutpileup;

import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableReader;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;

public class BasicValidationResult
implements Locatable {
    private final int minValidationReadCount;
    private final boolean isEnoughValidationReads;
    private final boolean isOutOfNoiseFloor;
    private final double power;
    private final int validationAltCount;
    private final int validationRefCount;
    private final int discoveryAltCount;
    private final int discoveryRefCount;
    private final Locatable interval;
    private final Allele reference;
    private final Allele alternate;
    private final String filters;
    private final long numAltSupportingReadsInNormal;

    public BasicValidationResult(Locatable interval, int minValidationReadCount, boolean isEnoughValidationReads, boolean isOutOfNoiseFloor, double power, int validationAltCount, int validationRefCount, int discoveryAltCount, int discoveryRefCount, Allele ref, Allele alt, String filters, long numAltSupportingReadsInNormal) {
        this.minValidationReadCount = minValidationReadCount;
        this.isEnoughValidationReads = isEnoughValidationReads;
        this.isOutOfNoiseFloor = isOutOfNoiseFloor;
        this.power = power;
        this.validationAltCount = validationAltCount;
        this.validationRefCount = validationRefCount;
        this.discoveryAltCount = discoveryAltCount;
        this.discoveryRefCount = discoveryRefCount;
        this.interval = interval;
        this.alternate = alt;
        this.reference = ref;
        this.filters = filters;
        this.numAltSupportingReadsInNormal = numAltSupportingReadsInNormal;
    }

    public int getValidationAltCount() {
        return this.validationAltCount;
    }

    public int getValidationRefCount() {
        return this.validationRefCount;
    }

    public int getDiscoveryAltCount() {
        return this.discoveryAltCount;
    }

    public int getDiscoveryRefCount() {
        return this.discoveryRefCount;
    }

    public int getMinValidationReadCount() {
        return this.minValidationReadCount;
    }

    public boolean isEnoughValidationReads() {
        return this.isEnoughValidationReads;
    }

    public boolean isOutOfNoiseFloor() {
        return this.isOutOfNoiseFloor;
    }

    public double getPower() {
        return this.power;
    }

    public Locatable getInterval() {
        return this.interval;
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    public Allele getReference() {
        return this.reference;
    }

    public Allele getAlternate() {
        return this.alternate;
    }

    public String getFilters() {
        return this.filters;
    }

    public long getNumAltSupportingReadsInNormal() {
        return this.numAltSupportingReadsInNormal;
    }

    public static void write(List<BasicValidationResult> records, GATKPath file) {
        try (BasicValidationResultTableWriter writer = new BasicValidationResultTableWriter(file.toPath());){
            writer.writeHeaderIfApplies();
            writer.writeAllRecords(records);
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while writing to %s.", file));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<BasicValidationResult> read(GATKPath file) {
        try (BasicValidationResultTableReader reader = new BasicValidationResultTableReader(file.toPath());){
            List<BasicValidationResult> list = reader.toList();
            return list;
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while reading from %s.", file));
        }
    }

    private static enum BasicValidationResultTableColumn {
        CONTIG("CONTIG"),
        START("START"),
        END("END"),
        REF("ref_allele"),
        ALT("alt_allele"),
        DISCOVERY_ALT_COVERAGE("t_alt_count"),
        DISCOVERY_REF_COVERAGE("t_ref_count"),
        VALIDATION_ALT_COVERAGE("tv_alt_count"),
        VALIDATION_REF_COVERAGE("tv_ref_count"),
        MIN_VAL_COUNT("min_val_count"),
        POWER("power"),
        IS_NOT_NOISE("validated"),
        IS_ENOUGH_VALIDATION_COVERAGE("sufficient_tv_alt_coverage"),
        DISCOVERY_VCF_FILTER("discovery_vcf_filter"),
        NUM_ALT_READS_IN_VALIDATION_NORMAL("num_alt_reads_in_validation_normal");

        private final String columnName;
        public static final TableColumnCollection COLUMNS;

        private BasicValidationResultTableColumn(String columnName) {
            this.columnName = Utils.nonNull(columnName);
        }

        public String toString() {
            return this.columnName;
        }

        static {
            COLUMNS = new TableColumnCollection(new Object[]{CONTIG, START, END, REF, ALT, DISCOVERY_ALT_COVERAGE, DISCOVERY_REF_COVERAGE, VALIDATION_ALT_COVERAGE, VALIDATION_REF_COVERAGE, MIN_VAL_COUNT, POWER, IS_NOT_NOISE, IS_ENOUGH_VALIDATION_COVERAGE, DISCOVERY_VCF_FILTER, NUM_ALT_READS_IN_VALIDATION_NORMAL});
        }
    }

    private static class BasicValidationResultTableReader
    extends TableReader<BasicValidationResult> {
        public BasicValidationResultTableReader(Path path) throws IOException {
            super(path);
        }

        @Override
        protected BasicValidationResult createRecord(DataLine dataLine) {
            String contig = dataLine.get(BasicValidationResultTableColumn.CONTIG);
            int start = dataLine.getInt(BasicValidationResultTableColumn.START);
            int end = dataLine.getInt(BasicValidationResultTableColumn.END);
            Allele ref = Allele.create((byte[])dataLine.get(BasicValidationResultTableColumn.REF).getBytes(), (boolean)true);
            Allele alt = Allele.create((byte[])dataLine.get(BasicValidationResultTableColumn.ALT).getBytes(), (boolean)false);
            int discoveryAltCount = dataLine.getInt(BasicValidationResultTableColumn.DISCOVERY_ALT_COVERAGE);
            int discoveryRefCount = dataLine.getInt(BasicValidationResultTableColumn.DISCOVERY_REF_COVERAGE);
            int validationAltCount = dataLine.getInt(BasicValidationResultTableColumn.VALIDATION_ALT_COVERAGE);
            int validationRefCount = dataLine.getInt(BasicValidationResultTableColumn.VALIDATION_REF_COVERAGE);
            int minValidationReadCount = dataLine.getInt(BasicValidationResultTableColumn.MIN_VAL_COUNT);
            double power = dataLine.getDouble(BasicValidationResultTableColumn.POWER);
            boolean isOutOfNoiseFloor = dataLine.getBoolean(BasicValidationResultTableColumn.IS_NOT_NOISE.toString());
            boolean isEnoughValidationReads = dataLine.getBoolean(BasicValidationResultTableColumn.IS_ENOUGH_VALIDATION_COVERAGE.toString());
            String filters = dataLine.get(BasicValidationResultTableColumn.DISCOVERY_VCF_FILTER);
            long numAltSupportingReadsInNormal = dataLine.getLong(BasicValidationResultTableColumn.NUM_ALT_READS_IN_VALIDATION_NORMAL);
            SimpleInterval interval = new SimpleInterval(contig, start, end);
            return new BasicValidationResult(interval, minValidationReadCount, isEnoughValidationReads, isOutOfNoiseFloor, power, validationAltCount, validationRefCount, discoveryAltCount, discoveryRefCount, ref, alt, filters, numAltSupportingReadsInNormal);
        }
    }

    private static class BasicValidationResultTableWriter
    extends TableWriter<BasicValidationResult> {
        public BasicValidationResultTableWriter(Path output) throws IOException {
            super(output, BasicValidationResultTableColumn.COLUMNS);
        }

        @Override
        protected void composeLine(BasicValidationResult record, DataLine dataLine) {
            dataLine.set(BasicValidationResultTableColumn.CONTIG.toString(), record.getContig());
            dataLine.set(BasicValidationResultTableColumn.START.toString(), record.getStart());
            dataLine.set(BasicValidationResultTableColumn.END.toString(), record.getEnd());
            dataLine.set(BasicValidationResultTableColumn.REF.toString(), record.getReference().getBaseString());
            dataLine.set(BasicValidationResultTableColumn.ALT.toString(), record.getAlternate().getBaseString());
            dataLine.set(BasicValidationResultTableColumn.DISCOVERY_ALT_COVERAGE.toString(), record.getDiscoveryAltCount());
            dataLine.set(BasicValidationResultTableColumn.DISCOVERY_REF_COVERAGE.toString(), record.getDiscoveryRefCount());
            dataLine.set(BasicValidationResultTableColumn.VALIDATION_ALT_COVERAGE.toString(), record.getValidationAltCount());
            dataLine.set(BasicValidationResultTableColumn.VALIDATION_REF_COVERAGE.toString(), record.getValidationRefCount());
            dataLine.set(BasicValidationResultTableColumn.MIN_VAL_COUNT.toString(), record.getMinValidationReadCount());
            dataLine.set(BasicValidationResultTableColumn.POWER.toString(), record.getPower());
            dataLine.set(BasicValidationResultTableColumn.IS_NOT_NOISE.toString(), record.isOutOfNoiseFloor());
            dataLine.set(BasicValidationResultTableColumn.IS_ENOUGH_VALIDATION_COVERAGE.toString(), record.isEnoughValidationReads());
            dataLine.set(BasicValidationResultTableColumn.DISCOVERY_VCF_FILTER.toString(), record.getFilters() == null ? "" : record.getFilters());
            dataLine.set(BasicValidationResultTableColumn.NUM_ALT_READS_IN_VALIDATION_NORMAL.toString(), record.getNumAltSupportingReadsInNormal());
        }
    }
}

