/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation.basicshortmutpileup;

import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.special.Beta;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public class BetaBinomialDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 2325L;
    private double alpha;
    private double beta;
    private int n;

    public BetaBinomialDistribution(RandomGenerator rng, double alpha, double beta, int n) {
        super(rng);
        ParamUtils.isPositive(alpha, "alpha must be greater than zero.");
        ParamUtils.isPositive(beta, "beta must be greater than zero.");
        ParamUtils.isPositiveOrZero(n, "number of trials must be greater than (or equal to) zero.");
        this.alpha = alpha;
        this.beta = beta;
        this.n = n;
    }

    public double probability(int k) {
        return Math.exp(this.logProbability(k));
    }

    public double logProbability(int k) {
        ParamUtils.isPositiveOrZero(k, "Number of successes must be greater than or equal to zero.");
        return k > this.n ? Double.NEGATIVE_INFINITY : CombinatoricsUtils.binomialCoefficientLog((int)this.n, (int)k) + Beta.logBeta((double)((double)k + this.alpha), (double)((double)(this.n - k) + this.beta)) - Beta.logBeta((double)this.alpha, (double)this.beta);
    }

    public double cumulativeProbability(int k) {
        ParamUtils.isPositiveOrZero(k, "Number of successes must be greater than or equal to zero.");
        double result = 0.0;
        for (int i = 0; i <= k; ++i) {
            result += this.probability(i);
        }
        return result;
    }

    public double getNumericalMean() {
        return (double)this.n * this.alpha / (this.alpha + this.beta);
    }

    public double getNumericalVariance() {
        return (double)this.n * this.alpha * this.beta * (this.alpha + this.beta + (double)this.n) / ((this.alpha + this.beta) * (this.alpha + this.beta) * (this.alpha + this.beta + 1.0));
    }

    public int getSupportLowerBound() {
        return 0;
    }

    public int getSupportUpperBound() {
        return this.n;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

