/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation.basicshortmutpileup;

import htsjdk.variant.variantcontext.Allele;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.broadinstitute.hellbender.tools.walkers.validation.basicshortmutpileup.BetaBinomialDistribution;
import org.broadinstitute.hellbender.utils.Trilean;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public class PowerCalculationUtils {
    public static final double P_VALUE_FOR_NOISE = 0.99;
    public static final int MINIMUM_NUM_READS_FOR_SIGNAL_COUNT = 2;

    private PowerCalculationUtils() {
    }

    public static double calculatePower(int validationTumorTotalCount, int discoveryTumorAltCount, int discoveryTumorTotalCount, int minCountForSignal) {
        BetaBinomialDistribution betaBinomialDistribution = new BetaBinomialDistribution(null, discoveryTumorAltCount + 1, discoveryTumorTotalCount - discoveryTumorAltCount + 1, validationTumorTotalCount);
        return 1.0 - betaBinomialDistribution.cumulativeProbability(minCountForSignal - 1);
    }

    public static int calculateMinCountForSignal(int validationTumorTotalCount, double maxSignalRatioInNormal) {
        ParamUtils.isPositiveOrZero(validationTumorTotalCount, "Cannot have a negative total count.");
        ParamUtils.inRange(maxSignalRatioInNormal, 0.0, 1.0, "Cannot have have a ratio that is outside of 0.0 - 1.0.");
        BinomialDistribution binomialDistribution = new BinomialDistribution(validationTumorTotalCount, maxSignalRatioInNormal);
        return Math.max(binomialDistribution.inverseCumulativeProbability(0.99), 2);
    }

    public static double calculateMaxAltRatio(ReadPileup readPileup, Allele referenceAllele, int minBaseQualityCutoff) {
        ParamUtils.isPositiveOrZero(minBaseQualityCutoff, "Cannot have a negative minBaseQualityCutoff.");
        Utils.nonNull(readPileup);
        Utils.nonNull(referenceAllele);
        List<PileupElement> pileupElementsPassingQuality = PowerCalculationUtils.retrievePileupElements(readPileup, minBaseQualityCutoff);
        long numAlternate = pileupElementsPassingQuality.stream().filter(pe -> GATKVariantContextUtils.doesReadContainAllele(pe, referenceAllele) == Trilean.FALSE || pe.isBeforeDeletionStart() || pe.isBeforeInsertion()).count();
        long numReference = pileupElementsPassingQuality.stream().filter(pe -> GATKVariantContextUtils.doesReadContainAllele(pe, referenceAllele) == Trilean.TRUE && !pe.isBeforeDeletionStart() && !pe.isBeforeInsertion()).count();
        return numReference + numAlternate == 0L ? 0.0 : (double)numAlternate / ((double)numReference + (double)numAlternate);
    }

    private static List<PileupElement> retrievePileupElements(ReadPileup readPileup, int minBaseQualityCutoff) {
        return Utils.stream(readPileup.iterator()).filter(pe -> !pe.isDeletion()).filter(pe -> pe.getQual() >= minBaseQualityCutoff).collect(Collectors.toList());
    }

    public static long calculateNumReadsSupportingAllele(ReadPileup readPileup, Allele referenceAllele, Allele altAllele, int minBaseQualityCutoff) {
        ParamUtils.isPositiveOrZero(minBaseQualityCutoff, "Cannot have a negative minBaseQualityCutoff.");
        Utils.nonNull(readPileup);
        Utils.nonNull(altAllele);
        Utils.nonNull(referenceAllele);
        List<PileupElement> pileupElementsPassingQuality = PowerCalculationUtils.retrievePileupElements(readPileup, minBaseQualityCutoff);
        return pileupElementsPassingQuality.stream().filter(pe -> altAllele.equals((Object)GATKVariantContextUtils.chooseAlleleForRead(pe, referenceAllele, Collections.singletonList(altAllele), minBaseQualityCutoff))).count();
    }
}

