/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation.basicshortmutpileup;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.validation.ConcordanceSummaryRecord;
import org.broadinstitute.hellbender.tools.walkers.validation.basicshortmutpileup.AllelePileupCounter;
import org.broadinstitute.hellbender.tools.walkers.validation.basicshortmutpileup.BasicSomaticShortMutationValidator;
import org.broadinstitute.hellbender.tools.walkers.validation.basicshortmutpileup.BasicValidationResult;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="Check variants in a VCF against tumor-normal bams representing the same samples, though not the ones from the actual calls.\nBare-bones implementation heavily inspired by MutationValidator from Broad CGA group.\nThe algorithm is not the same.\nThis tool can only handle exactly one validation PAIR at a time and this should not be RNA.\nMultiallelics in a VCF are not supported and will be skipped.\nThis tool will validate germline mutations as true positives.\n", oneLineSummary="Check variants against tumor-normal bams representing the same samples, though not the ones from the actual calls.", programGroup=VariantEvaluationProgramGroup.class)
@ExperimentalFeature
@DocumentedFeature
public class ValidateBasicSomaticShortMutations
extends VariantWalker {
    public static final String ANNOTATED_VCF_LONG_NAME = "annotated-vcf";
    public static final String SAMPLE_NAME_DISCOVERY_VCF_LONG_NAME = "discovery-sample-name";
    public static final String SAMPLE_NAME_VALIDATION_CASE = "val-case-sample-name";
    public static final String SAMPLE_NAME_VALIDATION_CONTROL = "val-control-sample-name";
    public static final int DEFAULT_MIN_BQ_CUTOFF = 20;
    public static final String CUTOFF_LONG_NAME = "min-base-quality-cutoff";
    public static final String MIN_POWER_LONG_NAME = "min-power";
    public static final String MAX_VALIDATION_NORMAL_COUNT_LONG_NAME = "max-validation-normal-count";
    private static final double DEFAULT_MIN_POWER = 0.9;
    private static final int DEFAULT_MAX_VALIDATION_NORMAL_COUNT = 1;
    @Argument(fullName="discovery-sample-name", doc="sample name for discovery in VCF.")
    protected String discoverySampleInVcf;
    @Argument(shortName="O", fullName="output", doc="The output file, which will be a validation table (tsv).")
    protected GATKPath outputFile;
    @Argument(fullName="annotated-vcf", doc="Optional output vcf containing original variants annotated with validation info.", optional=true)
    protected GATKPath annotatedVcf;
    @Argument(doc="A table of summary statistics (true positives, sensitivity, etc.)", fullName="summary", optional=true)
    protected GATKPath summary;
    @Argument(doc="Minimum power for an unvalidated variant to be considered a false positive.", fullName="min-power", optional=true)
    protected double minPower = 0.9;
    @Argument(doc="Maximum read count in the validation normal for a variant to validate.  More counts is considered an artifact.", fullName="max-validation-normal-count", optional=true)
    protected int maxValidationNormalCount = 1;
    @Argument(fullName="val-case-sample-name", doc="validation case sample name (in the bam)")
    protected String validationCaseName;
    @Argument(fullName="val-control-sample-name", doc="validation control sample name (in the bam)")
    protected String validationControlName;
    @Argument(fullName="min-base-quality-cutoff", doc="minimum base quality to count a read toward validation.", optional=true)
    public int minBqCutoff = 20;
    private VariantContextWriter vcfWriter;
    public static final String POWER_INFO_FIELD_KEY = "POWER";
    public static final String VALIDATION_AD_INFO_FIELD_KEY = "VAL_AD";
    public static final String JUDGMENT_INFO_FIELD_KEY = "JUDGMENT";
    public final VCFInfoHeaderLine POWER_HEADER_LINE = new VCFInfoHeaderLine("POWER", 1, VCFHeaderLineType.Float, "Power to validate variant in validation bam.");
    public final VCFInfoHeaderLine VALIDATION_AD_HEADER_LINE = new VCFInfoHeaderLine("VAL_AD", VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Ref and alt allele count in validation bam.");
    public final VCFInfoHeaderLine JUDGMENT_HEADER_LINE = new VCFInfoHeaderLine("JUDGMENT", 1, VCFHeaderLineType.String, "Validation judgment: validated, unvalidated, or skipped.");
    private List<BasicValidationResult> results = new ArrayList<BasicValidationResult>();
    private final MutableInt snpTruePositiveCount = new MutableInt(0);
    private final MutableInt snpFalsePositiveCount = new MutableInt(0);
    private final MutableInt indelTruePositiveCount = new MutableInt(0);
    private final MutableInt indelFalsePositiveCount = new MutableInt(0);

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        ArrayList<ReadFilter> result = new ArrayList<ReadFilter>(super.getDefaultReadFilters());
        result.add(ReadFilterLibrary.PASSES_VENDOR_QUALITY_CHECK);
        result.add(ReadFilterLibrary.NOT_DUPLICATE);
        result.add(ReadFilterLibrary.MAPPING_QUALITY_NOT_ZERO);
        return result;
    }

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public void onTraversalStart() {
        if (this.annotatedVcf != null) {
            VCFHeader inputHeader = this.getHeaderForVariants();
            HashSet<Object> headerLines = new HashSet<Object>(inputHeader.getMetaDataInSortedOrder());
            headerLines.addAll(Arrays.asList(this.POWER_HEADER_LINE, this.VALIDATION_AD_HEADER_LINE, this.JUDGMENT_HEADER_LINE));
            headerLines.addAll(this.getDefaultToolVCFHeaderLines());
            VCFHeader vcfHeader = new VCFHeader(headerLines, inputHeader.getGenotypeSamples());
            this.vcfWriter = this.createVCFWriter(this.annotatedVcf);
            this.vcfWriter.writeHeader(vcfHeader);
        }
    }

    @Override
    public void apply(VariantContext discoveryVariantContext, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        boolean powered;
        Genotype genotype = discoveryVariantContext.getGenotype(this.discoverySampleInVcf);
        Allele referenceAllele = discoveryVariantContext.getReference();
        if (referenceAllele.isSymbolic()) {
            this.logger.warn("Skipping variant with symbolic reference allele: " + discoveryVariantContext);
            return;
        }
        boolean isAbleToValidate = BasicSomaticShortMutationValidator.isAbleToValidateGenotype(genotype, referenceAllele);
        if (!isAbleToValidate) {
            if (this.annotatedVcf != null) {
                this.vcfWriter.add(new VariantContextBuilder(discoveryVariantContext).attribute(JUDGMENT_INFO_FIELD_KEY, (Object)Judgment.SKIPPED).make());
            }
            return;
        }
        Allele altAllele = genotype.getAllele(1);
        ReadPileup readPileup = new ReadPileup((Locatable)discoveryVariantContext, readsContext);
        SAMFileHeader samFileHeader = this.getHeaderForReads();
        Map<String, ReadPileup> pileupsBySample = readPileup.splitBySample(samFileHeader, "__UNKNOWN__");
        if (pileupsBySample.isEmpty()) {
            return;
        }
        ReadPileup validationNormalPileup = pileupsBySample.get(this.validationControlName);
        if (validationNormalPileup == null) {
            return;
        }
        ReadPileup validationTumorPileup = pileupsBySample.get(this.validationCaseName);
        Map<Allele, MutableInt> validationTumorAllelicCounts = new AllelePileupCounter(referenceAllele, discoveryVariantContext.getAlternateAlleles(), this.minBqCutoff, validationTumorPileup).getCountMap();
        int validationTumorAltCount = validationTumorAllelicCounts.getOrDefault(altAllele, new MutableInt(0)).intValue();
        int validationTumorRefCount = validationTumorAllelicCounts.get(referenceAllele).intValue();
        String filterString = discoveryVariantContext.getFilters().stream().sorted().collect(Collectors.joining(";"));
        BasicValidationResult basicValidationResult = BasicSomaticShortMutationValidator.calculateBasicValidationResult(genotype, referenceAllele, validationNormalPileup, validationTumorAltCount, validationTumorRefCount + validationTumorAltCount, this.minBqCutoff, new SimpleInterval(discoveryVariantContext.getContig(), discoveryVariantContext.getStart(), discoveryVariantContext.getEnd()), filterString);
        if (basicValidationResult != null) {
            this.results.add(basicValidationResult);
        }
        boolean normalArtifact = basicValidationResult.getNumAltSupportingReadsInNormal() > (long)this.maxValidationNormalCount;
        boolean validated = !normalArtifact && basicValidationResult != null && basicValidationResult.isOutOfNoiseFloor();
        boolean bl = powered = normalArtifact || basicValidationResult != null && basicValidationResult.getPower() > this.minPower;
        if (discoveryVariantContext.isSNP()) {
            if (validated) {
                this.snpTruePositiveCount.increment();
            } else if (powered) {
                this.snpFalsePositiveCount.increment();
            }
        } else if (validated) {
            this.indelTruePositiveCount.increment();
        } else if (powered) {
            this.indelFalsePositiveCount.increment();
        }
        if (this.annotatedVcf != null) {
            this.vcfWriter.add(new VariantContextBuilder(discoveryVariantContext).attribute(JUDGMENT_INFO_FIELD_KEY, (Object)(validated ? Judgment.VALIDATED : Judgment.UNVALIDATED)).attribute(POWER_INFO_FIELD_KEY, (Object)(basicValidationResult == null ? 0.0 : basicValidationResult.getPower())).attribute(VALIDATION_AD_INFO_FIELD_KEY, (Object)new int[]{validationTumorRefCount, validationTumorAltCount}).make());
        }
    }

    @Override
    public Object onTraversalSuccess() {
        BasicValidationResult.write(this.results, this.outputFile);
        if (this.summary != null) {
            try (ConcordanceSummaryRecord.Writer concordanceSummaryWriter = ConcordanceSummaryRecord.getWriter(this.summary);){
                concordanceSummaryWriter.writeRecord(new ConcordanceSummaryRecord(VariantContext.Type.SNP, this.snpTruePositiveCount.getValue().intValue(), this.snpFalsePositiveCount.getValue().intValue(), 0L));
                concordanceSummaryWriter.writeRecord(new ConcordanceSummaryRecord(VariantContext.Type.INDEL, this.indelTruePositiveCount.getValue().intValue(), this.indelFalsePositiveCount.getValue().intValue(), 0L));
            }
            catch (IOException e) {
                throw new UserException("Encountered an IO exception writing the concordance summary table", e);
            }
        }
        return "SUCCESS";
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }

    public static enum Judgment {
        VALIDATED,
        UNVALIDATED,
        SKIPPED;

    }
}

