/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.metrics.MetricsUtils;
import org.broadinstitute.hellbender.metrics.analysis.AlleleFrequencyQCMetric;
import org.broadinstitute.hellbender.tools.walkers.varianteval.VariantEval;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.AlleleFrequency;
import org.broadinstitute.hellbender.utils.R.RScriptExecutor;
import org.broadinstitute.hellbender.utils.io.Resource;
import org.broadinstitute.hellbender.utils.report.GATKReport;
import org.broadinstitute.hellbender.utils.report.GATKReportTable;

public class AlleleFrequencyQC
extends VariantEval {
    @Argument(shortName="pvalue-threshold", doc="Threshold to cut off the pvalue.")
    protected double threshold = 0.05;
    @Argument(shortName="allowed-variance", doc="Variance allowed in calculating the modified chi squared statistic.")
    protected double allowedVariance = 0.01;
    @Argument(shortName="debug-file", doc="File to save the results from variant eval for debugging", optional=true)
    protected File debugFile;
    private static final String R_SCRIPT = "plotAlleleFrequencyQC.R";
    protected File metricOutput;
    protected String sample;

    @Override
    public void onTraversalStart() {
        this.NO_STANDARD_MODULES = true;
        this.MODULES_TO_USE = Collections.singletonList("VariantAFEvaluator");
        this.keepSitesWithAC0 = true;
        this.NO_STANDARD_STRATIFICATIONS = true;
        this.STRATIFICATIONS_TO_USE = Arrays.asList("AlleleFrequency", "Filter");
        this.AFScale = AlleleFrequency.StratifyingScale.LOGARITHMIC;
        this.useCompAFStratifier = true;
        this.metricOutput = this.outFile;
        try {
            this.outFile = this.debugFile == null ? File.createTempFile("variant_eval", ".txt") : this.debugFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Trouble creating temporary variant eval file", e);
        }
        if (this.debugFile == null) {
            this.outFile.deleteOnExit();
        }
        this.sample = this.getHeaderForVariants().getOtherHeaderLine("sampleAlias").getValue();
        super.onTraversalStart();
    }

    @Override
    public Object onTraversalSuccess() {
        super.onTraversalSuccess();
        GATKReportTable table = new GATKReport(this.outFile).getTable((String)this.MODULES_TO_USE.get(0));
        List columnNames = table.getColumnInfo().stream().map(c -> c.getColumnName()).collect(Collectors.toList());
        Map<Object, List<Object>> afMap = IntStream.range(0, table.getNumRows()).mapToObj(i -> table.getRow(i)).filter(r -> r[columnNames.indexOf("Filter")].equals("called")).collect(Collectors.groupingBy(r -> r[columnNames.indexOf("AlleleFrequency")], Collectors.mapping(r -> r[columnNames.indexOf("avgVarAF")], Collectors.toList())));
        ChiSquaredDistribution dist = new ChiSquaredDistribution((double)(afMap.size() - 1));
        double chiSqValue = this.calculateChiSquaredStatistic(afMap, this.allowedVariance);
        double pVal = 1.0 - dist.cumulativeProbability(chiSqValue);
        MetricsFile metricsFile = new MetricsFile();
        AlleleFrequencyQCMetric metric = new AlleleFrequencyQCMetric();
        metric.SAMPLE = this.sample;
        metric.CHI_SQ_VALUE = chiSqValue;
        metric.METRIC_TYPE = "Allele Frequency";
        metric.METRIC_VALUE = pVal;
        metricsFile.addMetric((MetricBase)metric);
        MetricsUtils.saveMetrics(metricsFile, this.metricOutput.getAbsolutePath());
        RScriptExecutor executer = new RScriptExecutor();
        executer.addScript(new Resource(R_SCRIPT, AlleleFrequencyQC.class));
        executer.addArgs(this.outFile.getAbsolutePath(), this.metricOutput.getAbsolutePath(), this.sample);
        executer.exec();
        if (pVal < this.threshold) {
            this.logger.error("Allele frequencies between your array VCF and the expected VCF do not match with a significant pvalue of " + pVal);
        }
        return null;
    }

    private double calculateChiSquaredStatistic(Map<Object, List<Object>> afMap, double variance) {
        return afMap.values().stream().mapToDouble(afs -> afs.size() >= 2 ? Math.pow((Double)afs.toArray()[0] - (Double)afs.toArray()[1], 2.0) : 0.0).sum() / Math.pow(variance, 2.0);
    }
}

