/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.tribble.Feature;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.VariantContextUtils;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLinePluginDescriptor;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.DbsnpArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.MultiVariantInputArgumentCollection;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.MultiVariantWalker;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.varianteval.VariantEvalReportWriter;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.CompOverlap;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.CountVariants;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.IndelSummary;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.MetricsCollection;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.MultiallelicSummary;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.TiTvVariantEvaluator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.AlleleFrequency;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.IntervalStratification;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.manager.StratificationManager;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.EvaluationContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.SortableJexlVCMatchExp;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.VariantEvalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.samples.PedigreeValidationType;
import org.broadinstitute.hellbender.utils.samples.SampleDB;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="Given a variant callset, it is common to calculate various quality control metrics. These metrics include the number of raw or filtered SNP counts; ratio of transition mutations to transversions; concordance of a particular sample's calls to a genotyping chip; number of singletons per sample; etc. Furthermore, it is often useful to stratify these metrics by various criteria like functional class (missense, nonsense, silent), whether the site is CpG site, the amino acid degeneracy of the site, etc. VariantEval facilitates these calculations in two ways: by providing several built-in evaluation and stratification modules, and by providing a framework that permits the easy development of new evaluation and stratification modules.", oneLineSummary="General-purpose tool for variant evaluation (% in dbSNP, genotype concordance, Ti/Tv ratios, and a lot more)", programGroup=VariantEvaluationProgramGroup.class)
@DocumentedFeature
@BetaFeature
public class VariantEval
extends MultiVariantWalker {
    public static final String IS_SINGLETON_KEY = "ISSINGLETON";
    @Argument(fullName="output", shortName="O", doc="File to which variants should be written")
    protected File outFile;
    @Argument(fullName="eval", shortName="eval", doc="Input evaluation file(s)", optional=false)
    public List<FeatureInput<VariantContext>> evals;
    @Argument(fullName="comparison", shortName="comp", doc="Input comparison file(s)", optional=true)
    public List<FeatureInput<VariantContext>> compsProvided = new ArrayList<FeatureInput<VariantContext>>();
    private List<FeatureInput<VariantContext>> comps = new ArrayList<FeatureInput<VariantContext>>();
    @ArgumentCollection
    protected DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    @Argument(fullName="gold-standard", shortName="gold", doc="Evaluations that count calls at sites of true variation (e.g., indel calls) will use this argument as their gold standard for comparison", optional=true)
    public FeatureInput<VariantContext> goldStandard = null;
    @Argument(fullName="list", shortName="ls", doc="List the available eval modules and exit", optional=true)
    protected Boolean LIST = false;
    @Argument(shortName="select", doc="One or more stratifications to use when evaluating the data", optional=true)
    protected ArrayList<String> SELECT_EXPS = new ArrayList();
    @Argument(shortName="select-name", doc="Names to use for the list of stratifications (must be a 1-to-1 mapping)", optional=true)
    protected ArrayList<String> SELECT_NAMES = new ArrayList();
    @Argument(fullName="sample", shortName="sn", doc="Derive eval and comp contexts using only these sample genotypes, when genotypes are available in the original context", optional=true)
    protected Set<String> SAMPLE_EXPRESSIONS = new TreeSet<String>();
    @Argument(fullName="pedigree", shortName="ped", doc="Pedigree file for determining the population \"founders\"", optional=true)
    private GATKPath pedigreeFile;
    @Argument(shortName="known-name", doc="Name of feature bindings containing variant sites that should be treated as known when splitting eval features into known and novel subsets", optional=true)
    protected Set<String> KNOWN_NAMES = new HashSet<String>();
    List<FeatureInput<VariantContext>> knowns = new ArrayList<FeatureInput<VariantContext>>();
    @Argument(fullName="stratification-module", shortName="ST", doc="One or more specific stratification modules to apply to the eval track(s) (in addition to the standard stratifications, unless -noS is specified)", optional=true)
    protected List<String> STRATIFICATIONS_TO_USE = new ArrayList<String>();
    @Argument(fullName="do-not-use-all-standard-stratifications", shortName="no-st", doc="Do not use the standard stratification modules by default (instead, only those that are specified with the -S option)", optional=true)
    protected Boolean NO_STANDARD_STRATIFICATIONS = false;
    @Argument(fullName="eval-module", shortName="EV", doc="One or more specific eval modules to apply to the eval track(s) (in addition to the standard modules, unless -no-ev is specified)", optional=true)
    protected List<String> MODULES_TO_USE = new ArrayList<String>();
    @Argument(fullName="do-not-use-all-standard-modules", shortName="no-ev", doc="Do not use the standard modules by default (instead, only those that are specified with the -EV option)", optional=true)
    protected Boolean NO_STANDARD_MODULES = false;
    @Argument(fullName="min-phase-quality", shortName="mpq", doc="Minimum phasing quality", optional=true)
    protected double MIN_PHASE_QUALITY = 10.0;
    @Argument(shortName="mvq", fullName="mendelian-violation-qual-threshold", doc="Minimum genotype QUAL score for each trio member required to accept a site as a violation. Default is 50.", optional=true)
    protected double MENDELIAN_VIOLATION_QUAL_THRESHOLD = 50.0;
    @Argument(shortName="ploidy", fullName="sample-ploidy", doc="Per-sample ploidy (number of chromosomes per sample)", optional=true)
    protected int ploidy = 2;
    @Argument(fullName="ancestral-alignments", shortName="aa", doc="Fasta file with ancestral alleles", optional=true)
    private File ancestralAlignmentsFile = null;
    @Argument(fullName="require-strict-allele-match", shortName="strict", doc="If provided only comp and eval tracks with exactly matching reference and alternate alleles will be counted as overlapping", optional=true)
    private boolean requireStrictAlleleMatch = false;
    @Argument(fullName="keep-ac0", shortName="keep-ac0", doc="If provided, modules that track polymorphic sites will not require that a site have AC > 0 when the input eval has genotypes", optional=true)
    protected boolean keepSitesWithAC0 = false;
    @Hidden
    @Argument(fullName="num-samples", doc="If provided, modules that track polymorphic sites will not require that a site have AC > 0 when the input eval has genotypes", optional=true)
    private int numSamplesFromArgument = 0;
    @Argument(fullName="merge-evals", shortName="merge-evals", doc="If provided, all -eval tracks will be merged into a single eval track", optional=true)
    public boolean mergeEvals = false;
    @Argument(fullName="strat-intervals", shortName="strat-intervals", doc="File containing tribble-readable features for the IntervalStratificiation", optional=true)
    public FeatureInput<Feature> intervalsFile = null;
    @Argument(fullName="known-cnvs", shortName="known-cnvs", doc="File containing tribble-readable features describing a known list of copy number variants", optional=true)
    public FeatureInput<Feature> knownCNVsFile = null;
    protected AlleleFrequency.StratifyingScale AFScale = AlleleFrequency.StratifyingScale.LINEAR;
    protected boolean useCompAFStratifier = false;
    private Set<SortableJexlVCMatchExp> jexlExpressions = new TreeSet<SortableJexlVCMatchExp>();
    private boolean isSubsettingSamples;
    private Set<String> sampleNamesForEvaluation = new LinkedHashSet<String>();
    private Set<String> familyNamesForEvaluation = new LinkedHashSet<String>();
    private Set<String> sampleNamesForStratification = new LinkedHashSet<String>();
    private Set<String> familyNamesForStratification = new LinkedHashSet<String>();
    private boolean byFilterIsEnabled = false;
    private boolean perSampleIsEnabled = false;
    private boolean perFamilyIsEnabled = false;
    private static final String ALL_SAMPLE_NAME = "all";
    private static final String ALL_FAMILY_NAME = "all";
    private final VariantEvalUtils variantEvalUtils = new VariantEvalUtils(this);
    private ReferenceSequenceFile ancestralAlignments = null;
    StratificationManager<VariantStratifier, EvaluationContext> stratManager;
    private SampleDB sampleDB = null;
    Map<FeatureInput<VariantContext>, String> inputToNameMap = new HashMap<FeatureInput<VariantContext>, String>();
    final PositionAggregator aggr = new PositionAggregator();

    @Override
    protected MultiVariantInputArgumentCollection getMultiVariantInputArgumentCollection() {
        return new MultiVariantInputArgumentCollection(){
            private static final long serialVersionUID = 1L;

            @Override
            public List<GATKPath> getDrivingVariantPaths() {
                return Collections.emptyList();
            }
        };
    }

    @Override
    protected void initializeDrivingVariants() {
        this.getDrivingVariantsFeatureInputs().addAll(this.evals);
        if (this.dbsnp.dbsnp != null) {
            this.getDrivingVariantsFeatureInputs().add(this.dbsnp.dbsnp);
        }
        this.getDrivingVariantsFeatureInputs().addAll(this.compsProvided);
        super.initializeDrivingVariants();
    }

    @Override
    public void onTraversalStart() {
        Utils.nonNull(this.outFile);
        if (this.LIST.booleanValue()) {
            this.variantEvalUtils.listModulesAndExit();
        }
        this.sampleDB = SampleDB.createSampleDBFromPedigreeAndDataSources(this.pedigreeFile, this.getSamplesForVariants(), PedigreeValidationType.STRICT);
        this.comps.addAll(this.compsProvided);
        this.compsProvided.forEach(x -> this.inputToNameMap.put((FeatureInput<VariantContext>)x, x.hasUserSuppliedName() ? x.getName() : "comp"));
        if (this.dbsnp.dbsnp != null) {
            this.comps.add(this.dbsnp.dbsnp);
            this.inputToNameMap.put(this.dbsnp.dbsnp, "dbsnp");
            this.knowns.add(this.dbsnp.dbsnp);
        }
        this.evals.forEach(x -> this.inputToNameMap.put((FeatureInput<VariantContext>)x, x.hasUserSuppliedName() ? x.getName() : "eval"));
        for (FeatureInput<VariantContext> compInput : this.comps) {
            if (!this.KNOWN_NAMES.contains(this.getNameForInput(compInput))) continue;
            this.knowns.add(compInput);
        }
        HashMap<String, VCFHeader> vcfInputs = new HashMap<String, VCFHeader>();
        this.evals.forEach(x -> vcfInputs.put(x.getName(), (VCFHeader)this.getHeaderForFeatures(x)));
        HashSet<String> vcfSamples = new HashSet<String>();
        vcfInputs.forEach((k, v) -> vcfSamples.addAll(v.getSampleNamesInOrder()));
        HashSet allSampleNames = new HashSet(vcfSamples);
        this.sampleNamesForEvaluation.addAll(new TreeSet(this.SAMPLE_EXPRESSIONS.isEmpty() ? vcfSamples : Utils.filterCollectionByExpressions(vcfSamples, this.SAMPLE_EXPRESSIONS, false)));
        this.isSubsettingSamples = !this.sampleNamesForEvaluation.containsAll(allSampleNames);
        this.familyNamesForEvaluation.addAll(this.sampleDB.getFamilyIDs());
        if (this.STRATIFICATIONS_TO_USE.contains("Sample")) {
            this.sampleNamesForStratification.addAll(this.sampleNamesForEvaluation);
        }
        this.sampleNamesForStratification.add("all");
        if (this.STRATIFICATIONS_TO_USE.contains("Family")) {
            this.familyNamesForStratification.addAll(this.familyNamesForEvaluation);
        }
        this.familyNamesForStratification.add("all");
        for (VariantContextUtils.JexlVCMatchExp jexl : VariantContextUtils.initializeMatchExps(this.SELECT_NAMES, this.SELECT_EXPS)) {
            SortableJexlVCMatchExp sjexl = new SortableJexlVCMatchExp(jexl.name, jexl.exp);
            this.jexlExpressions.add(sjexl);
        }
        List<VariantStratifier> stratificationObjects = this.variantEvalUtils.initializeStratificationObjects(this.NO_STANDARD_STRATIFICATIONS, this.STRATIFICATIONS_TO_USE);
        Set<Class<? extends VariantEvaluator>> evaluationClasses = this.variantEvalUtils.initializeEvaluationObjects(this.NO_STANDARD_MODULES, this.MODULES_TO_USE);
        this.checkForIncompatibleEvaluatorsAndStratifiers(stratificationObjects, evaluationClasses);
        for (VariantStratifier vs : stratificationObjects) {
            if (vs.getName().equals("Filter")) {
                this.byFilterIsEnabled = true;
                continue;
            }
            if (vs.getName().equals("Sample")) {
                this.perSampleIsEnabled = true;
                continue;
            }
            if (!vs.getName().equals("Family")) continue;
            this.perFamilyIsEnabled = true;
        }
        if (this.perSampleIsEnabled && this.perFamilyIsEnabled) {
            throw new CommandLineException.BadArgumentValue("ST", "Variants cannot be stratified by sample and family at the same time");
        }
        if (this.perFamilyIsEnabled && this.sampleDB.getTrios().isEmpty()) {
            throw new CommandLineException.BadArgumentValue("ST", "Cannot stratify by family without *.ped file");
        }
        if (this.intervalsFile != null) {
            boolean fail = true;
            for (VariantStratifier vs : stratificationObjects) {
                if (!vs.getClass().equals(IntervalStratification.class)) continue;
                fail = false;
            }
            if (fail) {
                throw new CommandLineException.BadArgumentValue("ST", "stratIntervals argument provided but -ST IntervalStratification not provided");
            }
        }
        this.createStratificationStates(stratificationObjects, evaluationClasses);
        if (this.ancestralAlignmentsFile != null) {
            try {
                this.ancestralAlignments = new IndexedFastaSequenceFile(this.ancestralAlignmentsFile.toPath());
            }
            catch (FileNotFoundException e) {
                throw new GATKException(String.format("The ancestral alignments file, '%s', could not be found", this.ancestralAlignmentsFile.getAbsolutePath()));
            }
        }
        this.assertThatTerritoryIsSpecifiedIfNecessary();
    }

    private void assertThatTerritoryIsSpecifiedIfNecessary() {
        Set evaluatorsWhichRequireTerritory = this.stratManager.values().stream().flatMap(ctx -> ctx.getVariantEvaluators().stream()).filter(Objects::nonNull).filter(VariantEvaluator::requiresTerritoryToBeSpecified).map(VariantEvaluator::getSimpleName).collect(Collectors.toSet());
        if (!evaluatorsWhichRequireTerritory.isEmpty() && this.getTraversalIntervals() == null) {
            throw new UserException("You specified evaluators which require a covered territory to be specified.  \nPlease specify intervals or a reference file or disable all of the following evaluators:" + evaluatorsWhichRequireTerritory.stream().collect(Collectors.joining(", ")));
        }
    }

    private void checkForIncompatibleEvaluatorsAndStratifiers(List<VariantStratifier> stratificationObjects, Set<Class<? extends VariantEvaluator>> evaluationClasses) {
        for (VariantStratifier vs : stratificationObjects) {
            for (Class<? extends VariantEvaluator> ec : evaluationClasses) {
                if (!vs.getIncompatibleEvaluators().contains(ec)) continue;
                throw new CommandLineException.BadArgumentValue("ST and ET", "The selected stratification " + vs.getName() + " and evaluator " + ec.getSimpleName() + " are incompatible due to combinatorial memory requirements. Please disable one");
            }
        }
    }

    final void createStratificationStates(List<VariantStratifier> stratificationObjects, Set<Class<? extends VariantEvaluator>> evaluationObjects) {
        ArrayList<VariantStratifier> strats = new ArrayList<VariantStratifier>(stratificationObjects);
        this.stratManager = new StratificationManager(strats);
        this.logger.info("Creating " + this.stratManager.size() + " combinatorial stratification states");
        for (int i = 0; i < this.stratManager.size(); ++i) {
            EvaluationContext ec = this.createEvaluationContext(evaluationObjects);
            this.stratManager.set(i, ec);
        }
    }

    protected EvaluationContext createEvaluationContext(Set<Class<? extends VariantEvaluator>> evaluationObjects) {
        return new EvaluationContext(this, evaluationObjects);
    }

    @Override
    public void apply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.aggr.addVariant(variant, readsContext, referenceContext, featureContext);
    }

    public String getNameForInput(FeatureInput<VariantContext> input) {
        return this.inputToNameMap.get(input);
    }

    public void doApply(ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        HashMap<FeatureInput<VariantContext>, HashMap<String, Collection<VariantContext>>> evalVCs = this.variantEvalUtils.bindVariantContexts(referenceContext, featureContext, this.evals, this.byFilterIsEnabled, true, this.perSampleIsEnabled, this.perFamilyIsEnabled, this.mergeEvals);
        HashMap<FeatureInput<VariantContext>, HashMap<String, Collection<VariantContext>>> compVCs = this.variantEvalUtils.bindVariantContexts(referenceContext, featureContext, this.comps, this.byFilterIsEnabled, false, false, false, false);
        for (FeatureInput<VariantContext> evalInput : this.evals) {
            Map emptyEvalMap = Collections.emptyMap();
            Map evalSet = evalVCs.containsKey(evalInput) ? (Map)evalVCs.get(evalInput) : emptyEvalMap;
            Set<String> statificationLevels = this.perFamilyIsEnabled ? this.familyNamesForStratification : this.sampleNamesForStratification;
            for (String stratLevelName : statificationLevels) {
                HashSet<VariantContext> evalSetBySample = (HashSet<VariantContext>)evalSet.get(stratLevelName);
                if (evalSetBySample == null) {
                    evalSetBySample = new HashSet<VariantContext>(1);
                    evalSetBySample.add(null);
                }
                for (VariantContext eval : evalSetBySample) {
                    String aastr;
                    String string = aastr = this.ancestralAlignments == null ? null : new String(this.ancestralAlignments.getSubsequenceAt(eval.getContig(), (long)eval.getStart(), (long)eval.getEnd()).getBases());
                    if (eval != null && aastr != null) {
                        eval = new VariantContextBuilder(eval).attribute("ANCESTRALALLELE", (Object)aastr).make();
                    }
                    String evalName = this.getNameForInput(evalInput);
                    for (FeatureInput<VariantContext> compInput : this.comps) {
                        this.processComp(referenceContext, readsContext, featureContext, eval, evalName, compInput, stratLevelName, compVCs, evalSetBySample);
                    }
                    if (!this.comps.isEmpty()) continue;
                    this.processComp(referenceContext, readsContext, featureContext, eval, evalName, null, stratLevelName, compVCs, evalSetBySample);
                }
            }
            if (!this.mergeEvals) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processComp(ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext, VariantContext eval, String evalName, FeatureInput<VariantContext> compInput, String stratLevelName, HashMap<FeatureInput<VariantContext>, HashMap<String, Collection<VariantContext>>> compVCs, Collection<VariantContext> evalSetBySample) {
        Collection<EvaluationContext> contextsForStratification;
        String compName = this.getNameForInput(compInput);
        HashMap<String, Collection<VariantContext>> compSetHash = compInput == null ? null : compVCs.get(compInput);
        List<VariantContext> compSet = compSetHash == null || compSetHash.isEmpty() ? Collections.emptyList() : compVCs.get(compInput).values().iterator().next();
        VariantContext comp = this.findMatchingComp(eval, compSet);
        if (this.perFamilyIsEnabled) {
            contextsForStratification = this.getEvaluationContexts(referenceContext, readsContext, featureContext, eval, evalName, comp, compName, null, stratLevelName);
        } else {
            String familyID = stratLevelName.equals("all") ? "all" : this.sampleDB.getSample(stratLevelName).getFamilyID();
            contextsForStratification = this.getEvaluationContexts(referenceContext, readsContext, featureContext, eval, evalName, comp, compName, stratLevelName, familyID);
        }
        for (EvaluationContext nec : contextsForStratification) {
            EvaluationContext evaluationContext = nec;
            synchronized (evaluationContext) {
                nec.apply(referenceContext, readsContext, featureContext, comp, eval);
            }
            for (VariantContext otherComp : compSet) {
                if (otherComp == comp || this.compHasMatchingEval(otherComp, evalSetBySample)) continue;
                EvaluationContext evaluationContext2 = nec;
                synchronized (evaluationContext2) {
                    nec.apply(referenceContext, readsContext, featureContext, otherComp, null);
                }
            }
        }
    }

    protected Collection<EvaluationContext> getEvaluationContexts(ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext, VariantContext eval, String evalName, VariantContext comp, String compName, String sampleName, String familyName) {
        LinkedList<List<Object>> states = new LinkedList<List<Object>>();
        for (VariantStratifier vs : this.stratManager.getStratifiers()) {
            states.add(vs.getRelevantStates(referenceContext, readsContext, featureContext, comp, compName, eval, evalName, sampleName, familyName));
        }
        return this.stratManager.values(states);
    }

    private boolean compHasMatchingEval(VariantContext comp, Collection<VariantContext> evals) {
        for (VariantContext eval : evals) {
            if (eval == null || this.doEvalAndCompMatch(comp, eval, this.requireStrictAlleleMatch) == EvalCompMatchType.NO_MATCH) continue;
            return true;
        }
        return false;
    }

    private EvalCompMatchType doEvalAndCompMatch(VariantContext eval, VariantContext comp, boolean requireStrictAlleleMatch) {
        Allele altComp;
        if (comp.getType() == VariantContext.Type.NO_VARIATION || eval.getType() == VariantContext.Type.NO_VARIATION) {
            return EvalCompMatchType.LENIENT;
        }
        if (comp.getType() != eval.getType()) {
            return EvalCompMatchType.NO_MATCH;
        }
        Allele altEval = eval.getAlternateAlleles().size() == 0 ? null : eval.getAlternateAllele(0);
        Allele allele = altComp = comp.getAlternateAlleles().size() == 0 ? null : comp.getAlternateAllele(0);
        if (altEval == null && altComp == null || altEval != null && altEval.equals((Object)altComp) && eval.getReference().equals((Object)comp.getReference())) {
            return EvalCompMatchType.STRICT;
        }
        return requireStrictAlleleMatch ? EvalCompMatchType.NO_MATCH : EvalCompMatchType.LENIENT;
    }

    private VariantContext findMatchingComp(VariantContext eval, Collection<VariantContext> comps) {
        if (comps == null || comps.isEmpty()) {
            return null;
        }
        if (eval == null) {
            return comps.iterator().next();
        }
        VariantContext lenientMatch = null;
        for (VariantContext comp : comps) {
            switch (this.doEvalAndCompMatch(comp, eval, this.requireStrictAlleleMatch)) {
                case STRICT: {
                    return comp;
                }
                case LENIENT: {
                    if (lenientMatch != null) break;
                    lenientMatch = comp;
                    break;
                }
            }
        }
        return lenientMatch;
    }

    @Override
    public Object onTraversalSuccess() {
        this.aggr.onComplete();
        this.logger.info("Finalizing variant report");
        for (EvaluationContext nec : this.stratManager.values()) {
            for (VariantEvaluator ve : nec.getVariantEvaluators()) {
                ve.finalizeEvaluation();
            }
        }
        CompOverlap compOverlap = null;
        IndelSummary indelSummary = null;
        CountVariants countVariants = null;
        MultiallelicSummary multiallelicSummary = null;
        TiTvVariantEvaluator tiTvVariantEvaluator = null;
        MetricsCollection metricsCollection = null;
        for (EvaluationContext nec : this.stratManager.values()) {
            for (VariantEvaluator ve : nec.getVariantEvaluators()) {
                if (ve instanceof CompOverlap) {
                    compOverlap = (CompOverlap)ve;
                    continue;
                }
                if (ve instanceof IndelSummary) {
                    indelSummary = (IndelSummary)ve;
                    continue;
                }
                if (ve instanceof CountVariants) {
                    countVariants = (CountVariants)ve;
                    continue;
                }
                if (ve instanceof MultiallelicSummary) {
                    multiallelicSummary = (MultiallelicSummary)ve;
                    continue;
                }
                if (ve instanceof TiTvVariantEvaluator) {
                    tiTvVariantEvaluator = (TiTvVariantEvaluator)ve;
                    continue;
                }
                if (!(ve instanceof MetricsCollection)) continue;
                metricsCollection = (MetricsCollection)ve;
            }
            if (metricsCollection == null) continue;
            metricsCollection.setData(compOverlap.concordantRate, indelSummary.n_SNPs, countVariants.nSNPs, indelSummary.n_indels, multiallelicSummary.nIndels, indelSummary.insertion_to_deletion_ratio, countVariants.insertionDeletionRatio, tiTvVariantEvaluator.tiTvRatio);
        }
        try (PrintStream out = IOUtils.makePrintStreamMaybeGzipped(new GATKPath(this.outFile.getAbsolutePath()));){
            VariantEvalReportWriter.writeReport(out, this.stratManager, this.stratManager.getStratifiers(), this.stratManager.get(0).getVariantEvaluators());
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(e.getMessage(), (Exception)e);
        }
        return null;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public double getMinPhaseQuality() {
        return this.MIN_PHASE_QUALITY;
    }

    public int getSamplePloidy() {
        return this.ploidy;
    }

    public double getMendelianViolationQualThreshold() {
        return this.MENDELIAN_VIOLATION_QUAL_THRESHOLD;
    }

    public static String getAllSampleName() {
        return "all";
    }

    public static String getAllFamilyName() {
        return "all";
    }

    public List<FeatureInput<VariantContext>> getKnowns() {
        return this.knowns;
    }

    public List<FeatureInput<VariantContext>> getEvals() {
        return this.evals;
    }

    public boolean isSubsettingToSpecificSamples() {
        return this.isSubsettingSamples;
    }

    public Set<String> getSampleNamesForEvaluation() {
        return this.sampleNamesForEvaluation;
    }

    public Set<String> getFamilyNamesForEvaluation() {
        return this.familyNamesForEvaluation;
    }

    public int getNumberOfSamplesForEvaluation() {
        if (this.sampleNamesForEvaluation != null && !this.sampleNamesForEvaluation.isEmpty()) {
            return this.sampleNamesForEvaluation.size();
        }
        return this.numSamplesFromArgument;
    }

    public Set<String> getSampleNamesForStratification() {
        return this.sampleNamesForStratification;
    }

    public Set<String> getFamilyNamesForStratification() {
        return this.familyNamesForStratification;
    }

    public List<FeatureInput<VariantContext>> getComps() {
        return this.comps;
    }

    public Set<SortableJexlVCMatchExp> getJexlExpressions() {
        return this.jexlExpressions;
    }

    public AlleleFrequency.StratifyingScale getAFScale() {
        return this.AFScale;
    }

    public boolean getCompAFStratifier() {
        return this.useCompAFStratifier;
    }

    public Set<String> getContigNames() {
        TreeSet<String> contigs = new TreeSet<String>();
        for (SAMSequenceRecord r : this.getSequenceDictionaryForDrivingVariants().getSequences()) {
            contigs.add(r.getSequenceName());
        }
        return contigs;
    }

    public boolean ignoreAC0Sites() {
        return !this.keepSitesWithAC0;
    }

    public SampleDB getSampleDB() {
        return this.sampleDB;
    }

    public long getnProcessedLoci() {
        if (this.getTraversalIntervals() == null) {
            throw new GATKException("BUG: One of the evaluators used should have overriden requiresTerritoryToBeSpecified, please report this to the developers.\nEvaluators: " + this.stratManager.values().stream().flatMap(evaluator -> evaluator.getVariantEvaluators().stream()).map(VariantEvaluator::getSimpleName).sorted().distinct().collect(Collectors.joining(", ")));
        }
        return this.getTraversalIntervals().stream().mapToLong(SimpleInterval::size).sum();
    }

    public FeatureInput<Feature> getKnownCNVsFile() {
        return this.knownCNVsFile;
    }

    @Override
    public List<? extends CommandLinePluginDescriptor<?>> getPluginDescriptors() {
        return Collections.emptyList();
    }

    private static enum EvalCompMatchType {
        NO_MATCH,
        STRICT,
        LENIENT;

    }

    private class PositionAggregator {
        private SimpleInterval i = null;
        private ReadsContext readsContext;
        private ReferenceContext referenceContext;
        private FeatureContext featureContext;

        private PositionAggregator() {
        }

        private void addVariant(VariantContext vc, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
            if (this.i == null || !vc.getContig().equals(this.i.getContig()) || vc.getStart() != this.i.getStart()) {
                this.callDoApply();
                this.i = new SimpleInterval(vc.getContig(), vc.getStart(), vc.getEnd());
                this.readsContext = readsContext;
                this.referenceContext = referenceContext;
                this.featureContext = featureContext;
            } else if (vc.getEnd() > this.i.getEnd()) {
                this.i = new SimpleInterval(this.i.getContig(), this.i.getStart(), vc.getEnd());
                this.readsContext = new ReadsContext(this.readsContext, this.i);
                this.referenceContext = new ReferenceContext(this.referenceContext, this.i);
                this.featureContext = new FeatureContext(this.featureContext, this.i);
            }
        }

        public void callDoApply() {
            if (this.i != null) {
                VariantEval.this.doApply(this.readsContext, this.referenceContext, this.featureContext);
                this.i = null;
            }
        }

        public void onComplete() {
            this.callDoApply();
        }
    }
}

