/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.manager.StratificationManager;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.Analysis;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.AnalysisModuleScanner;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.DataPoint;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.EvaluationContext;
import org.broadinstitute.hellbender.utils.report.GATKReport;
import org.broadinstitute.hellbender.utils.report.GATKReportTable;

public class VariantEvalReportWriter {
    protected VariantEvalReportWriter() {
    }

    public static void writeReport(PrintStream out, StratificationManager<VariantStratifier, EvaluationContext> stratManager, Collection<VariantStratifier> stratifiers, Collection<VariantEvaluator> evaluators) {
        GATKReport report = VariantEvalReportWriter.initializeGATKReport(stratifiers, evaluators);
        for (int key = 0; key < stratManager.size(); ++key) {
            String stratStateString = stratManager.getStratsAndStatesStringForKey(key);
            List<Pair<VariantStratifier, Object>> stratsAndStates = stratManager.getStratsAndStatesForKey(key);
            EvaluationContext nec = stratManager.get(key);
            for (VariantEvaluator ve : nec.getVariantEvaluators()) {
                GATKReportTable table = report.getTable(ve.getSimpleName());
                AnalysisModuleScanner scanner = new AnalysisModuleScanner(ve);
                Map<Field, DataPoint> datamap = scanner.getData();
                try {
                    if (scanner.hasMoltenField()) {
                        Field field = scanner.getMoltenField();
                        Object fieldValue = field.get(ve);
                        if (fieldValue == null || !(fieldValue instanceof Map)) {
                            throw new GATKException("BUG field " + field.getName() + " must be a non-null instance of Map in " + scanner.getAnalysis().name());
                        }
                        Map<Object, Object> map = VariantEvalReportWriter.cast((Map)fieldValue);
                        if (map.isEmpty()) {
                            throw new GATKException("BUG: map is null or empty in analysis " + scanner.getAnalysis());
                        }
                        int counter = 0;
                        for (Map.Entry<Object, Object> keyValue : map.entrySet()) {
                            String moltenStratStateString = stratStateString + String.format("%05d", counter++);
                            VariantEvalReportWriter.setStratificationColumns(table, moltenStratStateString, stratsAndStates);
                            table.set(moltenStratStateString, scanner.getMoltenAnnotation().variableName(), keyValue.getKey());
                            table.set(moltenStratStateString, scanner.getMoltenAnnotation().valueName(), keyValue.getValue());
                        }
                        continue;
                    }
                    VariantEvalReportWriter.setStratificationColumns(table, stratStateString, stratsAndStates);
                    for (Field field : datamap.keySet()) {
                        table.set(stratStateString, field.getName(), field.get(ve));
                    }
                }
                catch (IllegalAccessException e) {
                    throw new GATKException("BUG: analysis field not public: " + e);
                }
            }
        }
        report.print(out);
    }

    private static Map<Object, Object> cast(Map<?, ?> map) {
        LinkedHashMap<Object, Object> ret = new LinkedHashMap<Object, Object>();
        ret.putAll(map);
        return ret;
    }

    private static void setStratificationColumns(GATKReportTable table, String primaryKey, List<Pair<VariantStratifier, Object>> stratsAndStates) {
        table.set(primaryKey, table.getTableName(), (Object)table.getTableName());
        for (Pair<VariantStratifier, Object> stratAndState : stratsAndStates) {
            VariantStratifier vs = (VariantStratifier)stratAndState.getKey();
            String columnName = vs.getName();
            Object strat = stratAndState.getValue();
            if (columnName == null || strat == null) {
                throw new GATKException("Unexpected null variant stratifier state at " + table + " key = " + primaryKey);
            }
            table.set(primaryKey, columnName, strat);
        }
    }

    private static GATKReport initializeGATKReport(Collection<VariantStratifier> stratifiers, Collection<VariantEvaluator> evaluators) {
        GATKReport report = new GATKReport();
        for (VariantEvaluator ve : evaluators) {
            AnalysisModuleScanner scanner = new AnalysisModuleScanner(ve);
            Map<Field, DataPoint> datamap = scanner.getData();
            String tableName = ve.getSimpleName();
            String tableDesc = ve.getClass().getAnnotation(Analysis.class).description();
            report.addTable(tableName, tableDesc, 1 + stratifiers.size() + (scanner.hasMoltenField() ? 2 : datamap.size()), GATKReportTable.Sorting.SORT_BY_ROW);
            GATKReportTable table = report.getTable(tableName);
            table.addColumn(tableName, tableName);
            for (VariantStratifier variantStratifier : stratifiers) {
                String columnName = variantStratifier.getName();
                table.addColumn(columnName, variantStratifier.getFormat());
            }
            if (scanner.hasMoltenField()) {
                table.addColumn(scanner.getMoltenAnnotation().variableName(), scanner.getMoltenAnnotation().variableFormat());
                table.addColumn(scanner.getMoltenAnnotation().valueName(), scanner.getMoltenAnnotation().valueFormat());
                continue;
            }
            if (datamap.isEmpty()) {
                throw new GATKException("Datamap is empty for analysis " + scanner.getAnalysis());
            }
            for (Map.Entry entry : datamap.entrySet()) {
                try {
                    ((Field)entry.getKey()).setAccessible(true);
                    String format = ((DataPoint)entry.getValue()).format();
                    table.addColumn(((Field)entry.getKey()).getName(), format);
                }
                catch (SecurityException e) {
                    throw new GATKException("SecurityException: " + e);
                }
            }
        }
        return report;
    }
}

