/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.Analysis;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.DataPoint;

@Analysis(description="The overlap between eval and comp sites")
public class CompOverlap
extends VariantEvaluator
implements StandardEval {
    @DataPoint(description="number of eval variant sites", format="%d")
    public long nEvalVariants = 0L;
    @DataPoint(description="number of eval sites outside of comp sites", format="%d")
    public long novelSites = 0L;
    @DataPoint(description="number of eval sites at comp sites", format="%d")
    public long nVariantsAtComp = 0L;
    @DataPoint(description="percentage of eval sites at comp sites", format="%.2f")
    public double compRate = 0.0;
    @DataPoint(description="number of concordant sites", format="%d")
    public long nConcordant = 0L;
    @DataPoint(description="the concordance rate", format="%.2f")
    public double concordantRate = 0.0;

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    public long nNovelSites() {
        return this.nEvalVariants - this.nVariantsAtComp;
    }

    public double compRate() {
        return this.rate(this.nVariantsAtComp, this.nEvalVariants);
    }

    public double concordanceRate() {
        return this.rate(this.nConcordant, this.nVariantsAtComp);
    }

    @Override
    public void finalizeEvaluation() {
        this.compRate = 100.0 * this.compRate();
        this.concordantRate = 100.0 * this.concordanceRate();
        this.novelSites = this.nNovelSites();
    }

    public boolean discordantP(VariantContext eval, VariantContext comp) {
        for (Allele a : eval.getAlleles()) {
            if (comp.hasAllele(a, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update2(VariantContext eval, VariantContext comp, ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext) {
        boolean compIsGood;
        boolean evalIsGood = eval != null && eval.isPolymorphicInSamples();
        boolean bl = compIsGood = comp != null && comp.isNotFiltered();
        if (evalIsGood) {
            ++this.nEvalVariants;
        }
        if (compIsGood && evalIsGood) {
            ++this.nVariantsAtComp;
            if (!this.discordantP(eval, comp)) {
                ++this.nConcordant;
            }
        }
    }
}

