/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.Analysis;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.DataPoint;

@Analysis(description="Counts called and filtered genotypes across samples")
public class GenotypeFilterSummary
extends VariantEvaluator {
    @DataPoint(description="Number of Called Genotypes", format="%d")
    public long nCalledNotFiltered = 0L;
    @DataPoint(description="Number of No-Call Genotypes", format="%d")
    public long nNoCallOrFiltered = 0L;

    @Override
    public int getComparisonOrder() {
        return 1;
    }

    @Override
    public void update1(VariantContext eval, ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext) {
        for (Genotype g : eval.getGenotypes()) {
            if (g.isCalled() && !g.isFiltered()) {
                ++this.nCalledNotFiltered;
                continue;
            }
            if (!g.isNoCall() && !g.isFiltered()) continue;
            ++this.nNoCallOrFiltered;
        }
    }
}

