/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.Analysis;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.Molten;

@Analysis(description="Indel length histogram", molten=true)
public class IndelLengthHistogram
extends VariantEvaluator
implements StandardEval {
    private final Map<Integer, Integer> counts = new HashMap<Integer, Integer>();
    private static final boolean asFrequencies = true;
    int nIndels = 0;
    @Molten(variableName="Length", valueName="Freq", variableFormat="%d", valueFormat="%.2f")
    public TreeMap<Object, Object> results;
    public static final int MAX_SIZE_FOR_HISTOGRAM = 10;
    private static final boolean INCLUDE_LONG_EVENTS_AT_MAX_SIZE = false;

    public IndelLengthHistogram() {
        this.initializeCounts(10);
    }

    private void initializeCounts(int size) {
        for (int i = -size; i <= size; ++i) {
            if (i == 0) continue;
            this.counts.put(i, 0);
        }
    }

    @Override
    public void finalizeEvaluation() {
        this.results = new TreeMap();
        for (int len : this.counts.keySet()) {
            double value = this.nIndels == 0 ? 0.0 : (double)this.counts.get(len).intValue() / (1.0 * (double)this.nIndels);
            this.results.put(len, value);
        }
    }

    @Override
    public int getComparisonOrder() {
        return 1;
    }

    @Override
    public void update1(VariantContext eval, ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext) {
        if (!(!eval.isIndel() || eval.isComplexIndel() || this.getWalker().ignoreAC0Sites() && eval.isMonomorphicInSamples())) {
            for (Allele alt : eval.getAlternateAlleles()) {
                int alleleSize = alt.length() - eval.getReference().length();
                if (alleleSize == 0) {
                    throw new GATKException("Allele size not expected to be zero for indel: alt = " + alt + " ref = " + eval.getReference());
                }
                this.updateLengthHistogram(eval.getReference(), alt);
            }
        }
    }

    public void updateLengthHistogram(Allele ref, Allele alt) {
        int len = alt.length() - ref.length();
        if (Math.abs(len) > 10) {
            return;
        }
        ++this.nIndels;
        this.counts.put(len, this.counts.get(len) + 1);
    }
}

