/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators;

import htsjdk.variant.variantcontext.VariantContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.Analysis;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.DataPoint;

@Analysis(name="PrintMissingComp", description="count the number of comp SNP sites that are not in eval")
public class PrintMissingComp
extends VariantEvaluator {
    @DataPoint(description="number of comp SNP sites outside of eval sites", format="%d")
    public long nMissing = 0L;

    public String getName() {
        return "PrintMissingComp";
    }

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    @Override
    public void update2(VariantContext eval, VariantContext comp, ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext) {
        boolean evalIsGood;
        boolean compIsGood = comp != null && comp.isNotFiltered() && comp.isSNP();
        boolean bl = evalIsGood = eval != null && eval.isSNP();
        if (compIsGood && !evalIsGood) {
            ++this.nMissing;
        }
    }
}

