/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.concurrent.ConcurrentHashMap;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.Analysis;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.DataPoint;

@Analysis(description="Computes different estimates of theta based on variant sites and genotypes")
public class ThetaVariantEvaluator
extends VariantEvaluator {
    @DataPoint(description="Average heterozygosity at variant sites; note that missing genotypes are ignored when computing this value", format="%.8f")
    public double avgHet = 0.0;
    @DataPoint(description="Average pairwise differences at aligned sequences; averaged over both number of sequeneces and number of variant sites; note that missing genotypes are ignored when computing this value", format="%.8f")
    public double avgAvgDiffs = 0.0;
    @DataPoint(description="Sum of heterozygosity over all variant sites; divide this by total target to get estimate of per base theta", format="%.8f")
    public double totalHet = 0.0;
    @DataPoint(description="Sum of pairwise diffs over all variant sites; divide this by total target to get estimate of per base theta", format="%.8f")
    public double totalAvgDiffs = 0.0;
    @DataPoint(description="Theta for entire region estimated based on number of segregating sites; divide ths by total target to get estimate of per base theta", format="%.8f")
    public double thetaRegionNumSites = 0.0;
    double numSites = 0.0;

    @Override
    public int getComparisonOrder() {
        return 1;
    }

    @Override
    public void update1(VariantContext vc, ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext) {
        if (vc == null || !vc.isSNP() || this.getWalker().ignoreAC0Sites() && vc.isMonomorphicInSamples()) {
            return;
        }
        ConcurrentHashMap<String, Integer> alleleCounts = new ConcurrentHashMap<String, Integer>();
        int numHetsHere = 0;
        int numGenosHere = 0;
        int numIndsHere = 0;
        for (Genotype genotype : vc.getGenotypes()) {
            ++numIndsHere;
            if (genotype.isNoCall()) continue;
            if (genotype.isHet()) {
                ++numHetsHere;
            }
            ++numGenosHere;
            for (Allele allele : genotype.getAlleles()) {
                if (!allele.isCalled()) continue;
                String alleleString = allele.toString();
                alleleCounts.putIfAbsent(alleleString, 0);
                alleleCounts.put(alleleString, (Integer)alleleCounts.get(alleleString) + 1);
            }
        }
        if (numGenosHere > 0) {
            this.numSites += 1.0;
            this.totalHet += (double)numHetsHere / (double)numGenosHere;
            float harmonicFactor = 0.0f;
            for (int i = 1; i <= numIndsHere; ++i) {
                harmonicFactor = (float)((double)harmonicFactor + 1.0 / (double)i);
            }
            this.thetaRegionNumSites += 1.0 / (double)harmonicFactor;
            float numPairwise = 0.0f;
            int numDiffs = 0;
            for (String allele1 : alleleCounts.keySet()) {
                int allele1Count = (Integer)alleleCounts.get(allele1);
                for (String allele2 : alleleCounts.keySet()) {
                    if (allele1.compareTo(allele2) < 0) continue;
                    if (allele1.compareTo(allele2) == 0) {
                        numPairwise = (float)((double)numPairwise + (double)(allele1Count * (allele1Count - 1)) * 0.5);
                        continue;
                    }
                    int allele2Count = (Integer)alleleCounts.get(allele2);
                    numPairwise += (float)(allele1Count * allele2Count);
                    numDiffs += allele1Count * allele2Count;
                }
            }
            if (numPairwise > 0.0f) {
                this.totalAvgDiffs += (double)((float)numDiffs / numPairwise);
            }
        }
    }

    @Override
    public void finalizeEvaluation() {
        if (this.numSites > 0.0) {
            this.avgHet = this.totalHet / this.numSites;
            this.avgAvgDiffs = this.totalAvgDiffs / this.numSites;
        }
    }
}

