/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators;

import htsjdk.variant.variantcontext.VariantContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.Analysis;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.DataPoint;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

@Analysis(description="Ti/Tv Variant Evaluator")
public class TiTvVariantEvaluator
extends VariantEvaluator
implements StandardEval {
    @DataPoint(description="number of transition loci", format="%d")
    public long nTi = 0L;
    @DataPoint(description="number of transversion loci", format="%d")
    public long nTv = 0L;
    @DataPoint(description="the transition to transversion ratio", format="%.2f")
    public double tiTvRatio = 0.0;
    @DataPoint(description="number of comp transition sites", format="%d")
    public long nTiInComp = 0L;
    @DataPoint(description="number of comp transversion sites", format="%d")
    public long nTvInComp = 0L;
    @DataPoint(description="the transition to transversion ratio for comp sites", format="%.2f")
    public double TiTvRatioStandard = 0.0;
    @DataPoint(description="number of derived transition loci", format="%d")
    public long nTiDerived = 0L;
    @DataPoint(description="number of derived transversion loci", format="%d")
    public long nTvDerived = 0L;
    @DataPoint(description="the derived transition to transversion ratio", format="%.2f")
    public double tiTvDerivedRatio = 0.0;

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    public void updateTiTv(VariantContext vc, boolean updateStandard) {
        if (vc != null && vc.isSNP() && vc.isBiallelic() && vc.isPolymorphicInSamples()) {
            String aaStr;
            if (GATKVariantContextUtils.isTransition(vc)) {
                if (updateStandard) {
                    ++this.nTiInComp;
                } else {
                    ++this.nTi;
                }
            } else if (updateStandard) {
                ++this.nTvInComp;
            } else {
                ++this.nTv;
            }
            if (vc.hasAttribute("ANCESTRALALLELE") && !(aaStr = vc.getAttributeAsString("ANCESTRALALLELE", "null").toUpperCase()).equals(".")) {
                switch (BaseUtils.SNPSubstitutionType(aaStr.getBytes()[0], vc.getAlternateAllele(0).getBases()[0])) {
                    case TRANSITION: {
                        ++this.nTiDerived;
                        break;
                    }
                    case TRANSVERSION: {
                        ++this.nTvDerived;
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void update2(VariantContext eval, VariantContext comp, ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext) {
        if (eval != null) {
            this.updateTiTv(eval, false);
        }
        if (comp != null) {
            this.updateTiTv(comp, true);
        }
    }

    @Override
    public void finalizeEvaluation() {
        this.tiTvRatio = this.rate(this.nTi, this.nTv);
        this.tiTvDerivedRatio = this.rate(this.nTiDerived, this.nTvDerived);
        this.TiTvRatioStandard = this.rate(this.nTiInComp, this.nTvInComp);
    }
}

