/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.List;
import java.util.Set;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.Analysis;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.DataPoint;

@Analysis(description="Assess site accuracy and sensitivity of callset against follow-up validation assay")
public class ValidationReport
extends VariantEvaluator
implements StandardEval {
    @DataPoint(description="nComp", format="%d")
    public int nComp = 0;
    @DataPoint(description="TP", format="%d")
    public int TP = 0;
    @DataPoint(description="FP", format="%d")
    public int FP = 0;
    @DataPoint(description="FN", format="%d")
    public int FN = 0;
    @DataPoint(description="TN", format="%d")
    public int TN = 0;
    @DataPoint(description="Sensitivity", format="%.2f")
    public double sensitivity = 0.0;
    @DataPoint(description="Specificity", format="%.2f")
    public double specificity = 0.0;
    @DataPoint(description="PPV", format="%.2f")
    public double PPV = 0.0;
    @DataPoint(description="FDR", format="%.2f")
    public double FDR = 0.0;
    @DataPoint(description="CompMonoEvalNoCall", format="%d")
    public int CompMonoEvalNoCall = 0;
    @DataPoint(description="CompMonoEvalFiltered", format="%d")
    public int CompMonoEvalFiltered = 0;
    @DataPoint(description="CompMonoEvalMono", format="%d")
    public int CompMonoEvalMono = 0;
    @DataPoint(description="CompMonoEvalPoly", format="%d")
    public int CompMonoEvalPoly = 0;
    @DataPoint(description="CompPolyEvalNoCall", format="%d")
    public int CompPolyEvalNoCall = 0;
    @DataPoint(description="CompPolyEvalFiltered", format="%d")
    public int CompPolyEvalFiltered = 0;
    @DataPoint(description="CompPolyEvalMono", format="%d")
    public int CompPolyEvalMono = 0;
    @DataPoint(description="CompPolyEvalPoly", format="%d")
    public int CompPolyEvalPoly = 0;
    @DataPoint(description="CompFiltered", format="%d")
    public int CompFiltered = 0;
    @DataPoint(description="Eval and comp have different alleles", format="%d")
    public int nDifferentAlleleSites = 0;
    private static final boolean TREAT_ALL_SITES_IN_EVAL_VCF_AS_CALLED = true;
    private static final boolean REQUIRE_IDENTICAL_ALLELES = false;
    final int[][] counts = new int[SiteStatus.values().length][SiteStatus.values().length];

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    @Override
    public void finalizeEvaluation() {
        for (SiteStatus x : SiteStatus.values()) {
            this.CompFiltered += this.getCounts(SiteStatus.FILTERED, x);
        }
        this.CompMonoEvalNoCall = this.getCounts(SiteStatus.MONO, SiteStatus.NO_CALL);
        this.CompMonoEvalFiltered = this.getCounts(SiteStatus.MONO, SiteStatus.FILTERED);
        this.CompMonoEvalMono = this.getCounts(SiteStatus.MONO, SiteStatus.MONO);
        this.CompMonoEvalPoly = this.getCounts(SiteStatus.MONO, SiteStatus.POLY);
        this.CompPolyEvalNoCall = this.getCounts(SiteStatus.POLY, SiteStatus.NO_CALL);
        this.CompPolyEvalFiltered = this.getCounts(SiteStatus.POLY, SiteStatus.FILTERED);
        this.CompPolyEvalMono = this.getCounts(SiteStatus.POLY, SiteStatus.MONO);
        this.TP = this.CompPolyEvalPoly = this.getCounts(SiteStatus.POLY, SiteStatus.POLY);
        this.FN = this.CompPolyEvalNoCall + this.CompPolyEvalFiltered + this.CompPolyEvalMono;
        this.FP = this.CompMonoEvalPoly;
        this.TN = this.CompMonoEvalNoCall + this.CompMonoEvalFiltered + this.CompMonoEvalMono;
        for (SiteStatus x : SiteStatus.values()) {
            for (SiteStatus y : SiteStatus.values()) {
                this.nComp += this.getCounts(x, y);
            }
        }
        if (this.nComp != this.TP + this.FN + this.FP + this.TN + this.CompFiltered) {
            throw new GATKException("BUG: nComp != TP + FN + FP + TN + CompFiltered!");
        }
        this.sensitivity = 100.0 * (double)this.TP / (double)(this.TP + this.FN);
        this.specificity = this.TN + this.FP > 0 ? 100.0 * (double)this.TN / (double)(this.TN + this.FP) : 100.0;
        this.PPV = 100.0 * (double)this.TP / (double)(this.TP + this.FP);
        this.FDR = 100.0 * (double)this.FP / (double)(this.FP + this.TP);
    }

    private int getCounts(SiteStatus comp, SiteStatus eval) {
        return this.counts[comp.ordinal()][eval.ordinal()];
    }

    @Override
    public void update2(VariantContext eval, VariantContext comp, ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext) {
        if (comp != null) {
            SiteStatus evalStatus = this.calcSiteStatus(eval);
            Set<String> evalSamples = this.getWalker().getSampleNamesForEvaluation();
            if (comp.hasGenotypes() && !evalSamples.isEmpty() && comp.hasGenotypes(evalSamples)) {
                comp = comp.subContextFromSamples(evalSamples, false);
            }
            SiteStatus compStatus = this.calcSiteStatus(comp);
            int[] nArray = this.counts[compStatus.ordinal()];
            int n = evalStatus.ordinal();
            nArray[n] = nArray[n] + 1;
        }
    }

    private SiteStatus calcSiteStatus(VariantContext vc) {
        if (vc == null) {
            return SiteStatus.NO_CALL;
        }
        if (vc.isFiltered()) {
            return SiteStatus.FILTERED;
        }
        if (vc.isMonomorphicInSamples()) {
            return SiteStatus.MONO;
        }
        if (vc.hasGenotypes()) {
            return SiteStatus.POLY;
        }
        if (vc.hasAttribute("AC")) {
            int ac = 0;
            if (vc.getNAlleles() > 2) {
                return SiteStatus.POLY;
            }
            ac = vc.getAttributeAsInt("AC", 0);
            return ac > 0 ? SiteStatus.POLY : SiteStatus.MONO;
        }
        return SiteStatus.POLY;
    }

    private boolean haveDifferentAltAlleles(VariantContext eval, VariantContext comp) {
        List evalAlts = eval.getAlternateAlleles();
        List compAlts = comp.getAlternateAlleles();
        if (evalAlts.size() != compAlts.size()) {
            return true;
        }
        for (Allele a : evalAlts) {
            if (compAlts.contains(a)) continue;
            return true;
        }
        return false;
    }

    private static enum SiteStatus {
        NO_CALL,
        FILTERED,
        MONO,
        POLY;

    }
}

