/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.Analysis;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.DataPoint;

@Analysis(description="Computes different estimates of theta based on variant sites and genotypes")
public class VariantAFEvaluator
extends VariantEvaluator {
    @DataPoint(description="Average variant allele fraction over all variant sites", format="%.8f")
    public double avgVarAF = 0.0;
    @DataPoint(description="Number of called sites over all variant sites;", format="%d")
    public int totalCalledSites = 0;
    @DataPoint(description="Number of called heterozygous sites;", format="%d")
    public int totalHetSites;
    @DataPoint(description="Number of called homozygous variant sites;", format="%d")
    public int totalHomVarSites;
    @DataPoint(description="Number of called homozygous reference sites;", format="%d")
    public int totalHomRefSites;
    private static final double PLOIDY = 2.0;
    private double sumVariantAFs = 0.0;

    @Override
    public int getComparisonOrder() {
        return 1;
    }

    @Override
    public void update1(VariantContext vc, ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext) {
        vc.getStart();
        if (vc == null || !vc.isSNP() || this.getWalker().ignoreAC0Sites() && vc.isMonomorphicInSamples()) {
            return;
        }
        for (Genotype genotype : vc.getGenotypes()) {
            if (genotype.isNoCall()) continue;
            if ((double)genotype.getPloidy() != 2.0) {
                throw new UserException.BadInput("This tool only works with ploidy 2");
            }
            ++this.totalCalledSites;
            int numReferenceAlleles = genotype.countAllele(vc.getReference());
            double varAFHere = (2.0 - (double)numReferenceAlleles) / 2.0;
            this.sumVariantAFs += varAFHere;
            this.totalHetSites += numReferenceAlleles == 1 ? 1 : 0;
            this.totalHomVarSites += numReferenceAlleles == 0 ? 1 : 0;
            this.totalHomRefSites += numReferenceAlleles == 2 ? 1 : 0;
        }
        if (!vc.hasGenotypes()) {
            ++this.totalCalledSites;
            this.sumVariantAFs += vc.getAttributeAsDouble("AF", 0.0);
        }
    }

    @Override
    public void finalizeEvaluation() {
        this.avgVarAF = this.totalCalledSites == 0 ? 0.0 : this.sumVariantAFs / (double)this.totalCalledSites;
    }
}

