/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators;

import htsjdk.variant.variantcontext.VariantContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.varianteval.VariantEval;

public abstract class VariantEvaluator
implements Comparable<VariantEvaluator> {
    private VariantEval walker;
    private final String simpleName;

    protected VariantEvaluator(String simpleName) {
        this.simpleName = simpleName;
    }

    protected VariantEvaluator() {
        this.simpleName = this.getClass().getSimpleName();
    }

    public void initialize(VariantEval walker) {
        this.walker = walker;
    }

    public VariantEval getWalker() {
        return this.walker;
    }

    public abstract int getComparisonOrder();

    public void update1(VariantContext eval, ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext) {
    }

    public void update2(VariantContext eval, VariantContext comp, ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext) {
    }

    public void finalizeEvaluation() {
    }

    protected double rate(long n, long d) {
        return (double)n / (1.0 * (double)Math.max(d, 1L));
    }

    protected long inverseRate(long n, long d) {
        return n == 0L ? 0L : d / Math.max(n, 1L);
    }

    protected double ratio(long num, long denom) {
        return (double)num / (double)Math.max(denom, 1L);
    }

    protected static boolean variantWasSingleton(VariantContext eval) {
        return eval.getAttributeAsBoolean("ISSINGLETON", false);
    }

    public final String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public int compareTo(VariantEvaluator variantEvaluator) {
        return this.getSimpleName().compareTo(variantEvaluator.getSimpleName());
    }

    public void combine(VariantEvaluator other) {
        throw new GATKException(this.getSimpleName() + " doesn't support combining results, sorry");
    }

    public boolean supportsCombine() {
        return false;
    }

    public boolean requiresTerritoryToBeSpecified() {
        return false;
    }
}

