/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators;

import htsjdk.tribble.Feature;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.VariantEval;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.Analysis;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.DataPoint;
import org.broadinstitute.hellbender.utils.GenomeLoc;
import org.broadinstitute.hellbender.utils.GenomeLocParser;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

@Analysis(description="1000 Genomes Phase I summary of variants table")
public class VariantSummary
extends VariantEvaluator
implements StandardEval {
    protected static final Logger logger = LogManager.getLogger(VariantSummary.class);
    private static final int MAX_INDEL_LENGTH = 50;
    private static final double MIN_CNV_OVERLAP = 0.5;
    FeatureInput<Feature> knownCNVs = null;
    @DataPoint(description="Number of samples", format="%d")
    public long nSamples = 0L;
    @DataPoint(description="Number of processed loci", format="%d")
    public long nProcessedLoci = 0L;
    @DataPoint(description="Number of SNPs", format="%d")
    public long nSNPs = 0L;
    @DataPoint(description="Overall TiTv ratio", format="%.2f")
    public double TiTvRatio = 0.0;
    @DataPoint(description="SNP Novelty Rate", format="%s")
    public String SNPNoveltyRate = "NA";
    @DataPoint(description="Mean number of SNPs per individual", format="%d")
    public long nSNPsPerSample = 0L;
    @DataPoint(description="Mean TiTv ratio per individual", format="%.2f")
    public double TiTvRatioPerSample = 0.0;
    @DataPoint(description="Mean depth of coverage per sample at SNPs", format="%.1f")
    public double SNPDPPerSample = 0.0;
    @DataPoint(description="Number of Indels", format="%d")
    public long nIndels = 0L;
    @DataPoint(description="Indel Novelty Rate", format="%s")
    public String IndelNoveltyRate = "NA";
    @DataPoint(description="Mean number of Indels per individual", format="%d")
    public long nIndelsPerSample = 0L;
    @DataPoint(description="Mean depth of coverage per sample at Indels", format="%.1f")
    public double IndelDPPerSample = 0.0;
    @DataPoint(description="Number of SVs", format="%d")
    public long nSVs = 0L;
    @DataPoint(description="SV Novelty Rate", format="%s")
    public String SVNoveltyRate = "NA";
    @DataPoint(description="Mean number of SVs per individual", format="%d")
    public long nSVsPerSample = 0L;
    TypeSampleMap allVariantCounts;
    TypeSampleMap knownVariantCounts;
    TypeSampleMap countsPerSample;
    TypeSampleMap transitionsPerSample;
    TypeSampleMap transversionsPerSample;
    TypeSampleMap depthPerSample;
    private static final String ALL = "ALL";

    @Override
    public void initialize(VariantEval walker) {
        super.initialize(walker);
        this.knownCNVs = walker.getKnownCNVsFile();
        this.nSamples = walker.getSampleNamesForEvaluation().size();
        this.countsPerSample = new TypeSampleMap(walker.getSampleNamesForEvaluation());
        this.transitionsPerSample = new TypeSampleMap(walker.getSampleNamesForEvaluation());
        this.transversionsPerSample = new TypeSampleMap(walker.getSampleNamesForEvaluation());
        this.allVariantCounts = new TypeSampleMap(walker.getSampleNamesForEvaluation());
        this.knownVariantCounts = new TypeSampleMap(walker.getSampleNamesForEvaluation());
        this.depthPerSample = new TypeSampleMap(walker.getSampleNamesForEvaluation());
    }

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    private Type getType(VariantContext vc) {
        switch (vc.getType()) {
            case SNP: {
                return Type.SNP;
            }
            case INDEL: {
                Iterator iterator = vc.getIndelLengths().iterator();
                while (iterator.hasNext()) {
                    int l = (Integer)iterator.next();
                    if (Math.abs(l) <= 50) continue;
                    return Type.CNV;
                }
                return Type.INDEL;
            }
            case SYMBOLIC: {
                return Type.CNV;
            }
        }
        return null;
    }

    private boolean overlapsKnownCNV(VariantContext cnv, FeatureContext featureContext) {
        if (this.knownCNVs != null) {
            List<Feature> overlaps = featureContext.getValues(this.knownCNVs);
            GenomeLocParser parser = new GenomeLocParser(this.getWalker().getReferenceDictionary());
            GenomeLoc loc1 = parser.createGenomeLoc((Feature)cnv);
            for (Feature vc : overlaps) {
                GenomeLoc loc2 = parser.createGenomeLoc(vc);
                double overlapP = loc1.reciprocialOverlapFraction(loc2);
                if (!(overlapP > 0.5)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void update2(VariantContext eval, VariantContext comp, ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext) {
        if (eval == null || this.getWalker().ignoreAC0Sites() && eval.isMonomorphicInSamples()) {
            return;
        }
        Type type = this.getType(eval);
        if (type == null) {
            return;
        }
        TypeSampleMap titvTable = null;
        if (eval.hasAttribute("DP")) {
            this.depthPerSample.inc(type, ALL);
        }
        this.allVariantCounts.inc(type, ALL);
        if (type == Type.SNP && eval.isBiallelic()) {
            titvTable = GATKVariantContextUtils.isTransition(eval) ? this.transitionsPerSample : this.transversionsPerSample;
            titvTable.inc(type, ALL);
        }
        if (comp != null || type == Type.CNV && this.overlapsKnownCNV(eval, featureContext)) {
            this.knownVariantCounts.inc(type, ALL);
        }
        for (Genotype g : eval.getGenotypes()) {
            if (g.isNoCall() || g.isHomRef()) continue;
            this.countsPerSample.inc(type, g.getSampleName());
            if (titvTable != null) {
                titvTable.inc(type, g.getSampleName());
            }
            if (!g.hasDP()) continue;
            this.depthPerSample.inc(type, g.getSampleName());
        }
    }

    private String noveltyRate(Type type) {
        int all = this.allVariantCounts.all(type);
        int known = this.knownVariantCounts.all(type);
        return Utils.formattedPercent(all - known, all);
    }

    @Override
    public void finalizeEvaluation() {
        this.nProcessedLoci = this.getWalker().getnProcessedLoci();
        this.nSNPs = this.allVariantCounts.all(Type.SNP);
        this.nIndels = this.allVariantCounts.all(Type.INDEL);
        this.nSVs = this.allVariantCounts.all(Type.CNV);
        this.TiTvRatio = this.transitionsPerSample.ratioValue(Type.SNP, this.transversionsPerSample, true);
        this.TiTvRatioPerSample = this.transitionsPerSample.ratioValue(Type.SNP, this.transversionsPerSample, false);
        this.nSNPsPerSample = this.countsPerSample.meanValue(Type.SNP);
        this.nIndelsPerSample = this.countsPerSample.meanValue(Type.INDEL);
        this.nSVsPerSample = this.countsPerSample.meanValue(Type.CNV);
        this.SNPNoveltyRate = this.noveltyRate(Type.SNP);
        this.IndelNoveltyRate = this.noveltyRate(Type.INDEL);
        this.SVNoveltyRate = this.noveltyRate(Type.CNV);
        this.SNPDPPerSample = this.depthPerSample.meanValue(Type.SNP);
        this.IndelDPPerSample = this.depthPerSample.meanValue(Type.INDEL);
    }

    @Override
    public boolean requiresTerritoryToBeSpecified() {
        return true;
    }

    private class TypeSampleMap
    extends EnumMap<Type, Map<String, Integer>> {
        private static final long serialVersionUID = 1L;

        public TypeSampleMap(Collection<String> samples) {
            super(Type.class);
            for (Type type : Type.values()) {
                HashMap<String, Integer> bySample = new HashMap<String, Integer>(samples.size());
                for (String sample : samples) {
                    bySample.put(sample, 0);
                }
                bySample.put(VariantSummary.ALL, 0);
                this.put(type, bySample);
            }
        }

        public final void inc(Type type, String sample) {
            int count = (Integer)((Map)this.get((Object)type)).get(sample);
            ((Map)this.get((Object)type)).put(sample, count + 1);
        }

        public final int all(Type type) {
            return (Integer)((Map)this.get((Object)type)).get(VariantSummary.ALL);
        }

        public final int meanValue(Type type) {
            long sum = 0L;
            int n = 0;
            for (Map.Entry pair : ((Map)this.get((Object)type)).entrySet()) {
                if (pair.getKey() == VariantSummary.ALL) continue;
                ++n;
                sum += (long)((Integer)pair.getValue()).intValue();
            }
            return (int)Math.round((double)sum / (1.0 * (double)n));
        }

        public final double ratioValue(Type type, TypeSampleMap denoms, boolean allP) {
            double sum = 0.0;
            int n = 0;
            for (String sample : ((Map)this.get((Object)type)).keySet()) {
                if ((!allP || sample != VariantSummary.ALL) && (allP || sample == VariantSummary.ALL)) continue;
                long num = ((Integer)((Map)this.get((Object)type)).get(sample)).intValue();
                long denom = ((Integer)((Map)denoms.get((Object)type)).get(sample)).intValue();
                sum += VariantSummary.this.ratio(num, denom);
                ++n;
            }
            return n > 0 ? sum / (1.0 * (double)n) : 0.0;
        }
    }

    public static enum Type {
        SNP,
        INDEL,
        CNV;

    }
}

