/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.VariantSummary;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.VariantStratifier;

public class AlleleCount
extends VariantStratifier {
    int nchrom;

    @Override
    public void initialize() {
        if (this.getVariantEvalWalker().getEvals().size() != 1 && !this.getVariantEvalWalker().mergeEvals) {
            throw new CommandLineException.BadArgumentValue("AlleleCount", "AlleleCount stratification only works with a single eval vcf");
        }
        this.nchrom = this.getVariantEvalWalker().getNumberOfSamplesForEvaluation() * this.getVariantEvalWalker().getSamplePloidy();
        if (this.nchrom < 2) {
            throw new CommandLineException.BadArgumentValue("AlleleCount", "AlleleCount stratification requires an eval vcf with at least one sample");
        }
        for (int ac = 0; ac <= this.nchrom; ++ac) {
            this.states.add(ac);
        }
        this.getVariantEvalWalker().getLogger().info("AlleleCount using " + this.nchrom + " chromosomes");
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName, String familyName) {
        if (eval != null) {
            int AC = 0;
            try {
                if (eval.isBiallelic()) {
                    if (eval.hasAttribute("MLEAC")) {
                        AC = Math.min(eval.getAttributeAsInt("MLEAC", 0), this.nchrom);
                    } else if (eval.hasAttribute("AC")) {
                        AC = eval.getAttributeAsInt("AC", 0);
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (AC == 0 && eval.isVariant()) {
                for (Allele allele : eval.getAlternateAlleles()) {
                    AC = Math.max(AC, eval.getCalledChrCount(allele));
                }
            }
            if (AC > this.nchrom) {
                throw new UserException(String.format("The AC value (%d) at position %s:%d is larger than the number of chromosomes over all samples (%d)", AC, eval.getContig(), eval.getStart(), this.nchrom));
            }
            return Collections.singletonList(AC);
        }
        return Collections.emptyList();
    }

    @Override
    public Set<Class<? extends VariantEvaluator>> getIncompatibleEvaluators() {
        return new HashSet<Class<? extends VariantEvaluator>>(Arrays.asList(VariantSummary.class));
    }

    @Override
    public String getFormat() {
        return "%d";
    }
}

