/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.hellbender.utils.MathUtils;

public class AlleleFrequency
extends VariantStratifier {
    private StratifyingScale scale;
    private boolean useCompAFStratifier;
    private static final int LOGIT_BIN_WIDTH = 1;
    private static int logLimit = 30;

    @Override
    public void initialize() {
        this.scale = this.getVariantEvalWalker().getAFScale();
        this.useCompAFStratifier = this.getVariantEvalWalker().getCompAFStratifier();
        switch (this.scale) {
            case LINEAR: {
                for (double a = 0.0; a <= 1.005; a += 0.005) {
                    this.states.add(String.format("%.3f", a));
                }
                break;
            }
            case LOGARITHMIC: {
                for (int a = -logLimit; a <= logLimit; ++a) {
                    this.states.add(String.format("%d", a));
                }
                break;
            }
        }
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName, String FamilyName) {
        if (eval != null) {
            try {
                double alleleFrequency = (Double)Collections.max(eval.getAttributeAsDoubleList("AF", 0.0));
                if (this.useCompAFStratifier) {
                    alleleFrequency = comp != null ? (Double)Collections.max(comp.getAttributeAsDoubleList("AF", 0.0)) : 0.0;
                }
                switch (this.scale) {
                    case LINEAR: {
                        return Collections.singletonList(String.format("%.3f", 5.0 * MathUtils.roundToNDecimalPlaces(alleleFrequency / 5.0, 3)));
                    }
                    case LOGARITHMIC: {
                        return Collections.singletonList(String.format("%d", this.getLogitBucket(alleleFrequency + Math.pow(10.0, -6.0))));
                    }
                }
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private int getLogitBucket(double alleleFrequency) {
        Float score = Float.valueOf((float)(-10.0 * Math.log10(alleleFrequency / (1.0 - alleleFrequency))));
        return Math.min(logLimit, Math.max(-logLimit, Math.round(score.floatValue())));
    }

    public static enum StratifyingScale {
        LINEAR,
        LOGARITHMIC;

    }
}

