/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.VariantStratifier;

public class Degeneracy
extends VariantStratifier {
    private HashMap<String, HashMap<Integer, String>> degeneracies;

    @Override
    public void initialize() {
        this.states.add("1-fold");
        this.states.add("2-fold");
        this.states.add("3-fold");
        this.states.add("4-fold");
        this.states.add("6-fold");
        this.states.add("all");
        HashMap<String, String[]> aminoAcids = new HashMap<String, String[]>();
        aminoAcids.put("Ile", new String[]{"ATT", "ATC", "ATA"});
        aminoAcids.put("Leu", new String[]{"CTT", "CTC", "CTA", "CTG", "TTA", "TTG"});
        aminoAcids.put("Val", new String[]{"GTT", "GTC", "GTA", "GTG"});
        aminoAcids.put("Phe", new String[]{"TTT", "TTC"});
        aminoAcids.put("Met", new String[]{"ATG"});
        aminoAcids.put("Cys", new String[]{"TGT", "TGC"});
        aminoAcids.put("Ala", new String[]{"GCT", "GCC", "GCA", "GCG"});
        aminoAcids.put("Gly", new String[]{"GGT", "GGC", "GGA", "GGG"});
        aminoAcids.put("Pro", new String[]{"CCT", "CCC", "CCA", "CCG"});
        aminoAcids.put("Thr", new String[]{"ACT", "ACC", "ACA", "ACG"});
        aminoAcids.put("Ser", new String[]{"TCT", "TCC", "TCA", "TCG", "AGT", "AGC"});
        aminoAcids.put("Tyr", new String[]{"TAT", "TAC"});
        aminoAcids.put("Trp", new String[]{"TGG"});
        aminoAcids.put("Glu", new String[]{"CAA", "CAG"});
        aminoAcids.put("Asn", new String[]{"AAT", "AAC"});
        aminoAcids.put("His", new String[]{"CAT", "CAC"});
        aminoAcids.put("Gln", new String[]{"GAA", "GAG"});
        aminoAcids.put("Asp", new String[]{"GAT", "GAC"});
        aminoAcids.put("Lys", new String[]{"AAA", "AAG"});
        aminoAcids.put("Arg", new String[]{"CGT", "CGC", "CGA", "CGG", "AGA", "AGG"});
        aminoAcids.put("Stop", new String[]{"TAA", "TAG", "TGA"});
        this.degeneracies = new HashMap();
        for (String aminoAcid : aminoAcids.keySet()) {
            String[] codons = (String[])aminoAcids.get(aminoAcid);
            for (int pos = 0; pos < 3; ++pos) {
                String degeneracy;
                HashSet<Character> alleles = new HashSet<Character>();
                for (String codon : codons) {
                    alleles.add(Character.valueOf(codon.charAt(pos)));
                }
                switch (alleles.size()) {
                    case 1: {
                        degeneracy = "1-fold";
                        break;
                    }
                    case 2: {
                        degeneracy = "2-fold";
                        break;
                    }
                    case 3: {
                        degeneracy = "3-fold";
                        break;
                    }
                    case 4: {
                        degeneracy = "4-fold";
                        break;
                    }
                    case 6: {
                        degeneracy = "6-fold";
                        break;
                    }
                    default: {
                        degeneracy = "1-fold";
                    }
                }
                if (!this.degeneracies.containsKey(aminoAcid)) {
                    this.degeneracies.put(aminoAcid, new HashMap());
                }
                this.degeneracies.get(aminoAcid).put(pos, degeneracy);
            }
        }
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName, String FamilyName) {
        ArrayList<Object> relevantStates = new ArrayList<Object>();
        relevantStates.add("all");
        if (eval != null && eval.isVariant()) {
            String type = null;
            String aa = null;
            Integer frame = null;
            if (eval.hasAttribute("refseq.functionalClass")) {
                aa = eval.getAttributeAsString("refseq.variantAA", null);
                frame = eval.getAttributeAsInt("refseq.frame", 0);
            } else if (eval.hasAttribute("refseq.functionalClass_1")) {
                String key;
                int annotationId = 1;
                do {
                    String newtype;
                    if ((newtype = eval.getAttributeAsString(key = String.format("refseq.functionalClass_%d", annotationId), null)) != null && (type == null || type.equals("silent") && !newtype.equals("silent") || type.equals("missense") && newtype.equals("nonsense"))) {
                        String framekey;
                        type = newtype;
                        String aakey = String.format("refseq.variantAA_%d", annotationId);
                        aa = eval.getAttributeAsString(aakey, null);
                        if (aa != null && eval.hasAttribute(framekey = String.format("refseq.frame_%d", annotationId))) {
                            frame = eval.getAttributeAsInt(framekey, 0);
                        }
                    }
                    ++annotationId;
                } while (eval.hasAttribute(key));
            }
            if (aa != null && this.degeneracies.containsKey(aa) && frame != null) {
                relevantStates.add(this.degeneracies.get(aa).get(frame));
            }
        }
        return relevantStates;
    }
}

