/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.VariantStratifier;

public class FilterType
extends VariantStratifier {
    @Override
    public void initialize() {
        HashSet<String> filterNames = new HashSet<String>();
        for (FeatureInput<VariantContext> eval : this.getVariantEvalWalker().getEvals()) {
            VCFHeader header = (VCFHeader)this.getVariantEvalWalker().getHeaderForFeatures(eval);
            for (VCFFilterHeaderLine line : header.getFilterLines()) {
                filterNames.add(line.getID());
            }
        }
        this.states.addAll(filterNames);
        this.states.add("PASS");
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName, String familyName) {
        if (eval == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> relevantStates = new ArrayList<Object>();
        if (eval.isFiltered()) {
            relevantStates.addAll(eval.getFilters());
        } else {
            relevantStates.add("PASS");
        }
        return relevantStates;
    }
}

