/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.SnpEffUtil;

public class FunctionalClass
extends VariantStratifier {
    private static final String FUNCTIONAL_CLASS_KEY = "SNPEFF_FUNCTIONAL_CLASS";

    @Override
    public void initialize() {
        this.states.add("all");
        for (FunctionalType type : FunctionalType.values()) {
            this.states.add(type.name());
        }
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName, String FamilyName) {
        ArrayList<Object> relevantStates = new ArrayList<Object>();
        relevantStates.add("all");
        if (eval != null && eval.isVariant()) {
            FunctionalType type = null;
            if (eval.hasAttribute("refseq.functionalClass")) {
                try {
                    type = FunctionalType.valueOf(eval.getAttributeAsString("refseq.functionalClass", null));
                }
                catch (Exception exception) {}
            } else if (eval.hasAttribute("refseq.functionalClass_1")) {
                String key;
                int annotationId = 1;
                do {
                    String newtypeStr;
                    if ((newtypeStr = eval.getAttributeAsString(key = String.format("refseq.functionalClass_%d", annotationId), null)) != null && !newtypeStr.equalsIgnoreCase("null")) {
                        try {
                            FunctionalType newType = FunctionalType.valueOf(newtypeStr);
                            if (type == null || type == FunctionalType.silent && newType != FunctionalType.silent || type == FunctionalType.missense && newType == FunctionalType.nonsense) {
                                type = newType;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++annotationId;
                } while (eval.hasAttribute(key));
            } else if (eval.hasAttribute(FUNCTIONAL_CLASS_KEY)) {
                try {
                    SnpEffUtil.EffectFunctionalClass snpEffFunctionalClass = SnpEffUtil.EffectFunctionalClass.valueOf(eval.getAttribute(FUNCTIONAL_CLASS_KEY).toString());
                    if (snpEffFunctionalClass == SnpEffUtil.EffectFunctionalClass.NONSENSE) {
                        type = FunctionalType.nonsense;
                    } else if (snpEffFunctionalClass == SnpEffUtil.EffectFunctionalClass.MISSENSE) {
                        type = FunctionalType.missense;
                    } else if (snpEffFunctionalClass == SnpEffUtil.EffectFunctionalClass.SILENT) {
                        type = FunctionalType.silent;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (type != null) {
                relevantStates.add(type.name());
            }
        }
        return relevantStates;
    }

    public static enum FunctionalType {
        silent,
        missense,
        nonsense;

    }
}

