/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.VariantStratifier;

public class IndelSize
extends VariantStratifier {
    static final int MAX_INDEL_SIZE = 100;

    @Override
    public void initialize() {
        for (int a = -100; a <= 100; ++a) {
            this.states.add(a);
        }
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName, String FamilyName) {
        if (eval != null && eval.isIndel() && eval.isBiallelic()) {
            try {
                int eventLength = 0;
                if (eval.isSimpleInsertion()) {
                    eventLength = eval.getAlternateAllele(0).length();
                } else if (eval.isSimpleDeletion()) {
                    eventLength = -eval.getReference().length();
                }
                if (eventLength > 100) {
                    eventLength = 100;
                } else if (eventLength < -100) {
                    eventLength = -100;
                }
                return Collections.singletonList(eventLength);
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String getFormat() {
        return "%d";
    }
}

