/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications;

import htsjdk.tribble.Feature;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.VariantStratifier;

public class IntervalStratification
extends VariantStratifier {
    protected static final Logger logger = LogManager.getLogger(IntervalStratification.class);
    final List<Object> OVERLAPPING = Arrays.asList("all", "overlaps.intervals");
    final List<Object> NOT_OVERLAPPING = Arrays.asList("all", "outside.intervals");

    @Override
    public void initialize() {
        if (this.getVariantEvalWalker().intervalsFile == null) {
            throw new CommandLineException.MissingArgument("stratIntervals", "Must be provided when IntervalStratification is enabled");
        }
        this.states.addAll(Arrays.asList("all", "overlaps.intervals", "outside.intervals"));
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName, String FamilyName) {
        if (eval != null) {
            List<Feature> overlapping = featureContext.getValues(this.getVariantEvalWalker().intervalsFile);
            if (!overlapping.isEmpty()) {
                return this.OVERLAPPING;
            }
            return this.NOT_OVERLAPPING;
        }
        return Collections.emptyList();
    }
}

