/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.StandardStratification;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.VariantStratifier;

public class Novelty
extends VariantStratifier
implements StandardStratification {
    private List<FeatureInput<VariantContext>> knowns;
    private static final List<Object> KNOWN_STATES = Arrays.asList("all", "known");
    private static final List<Object> NOVEL_STATES = Arrays.asList("all", "novel");

    @Override
    public void initialize() {
        this.states.addAll(Arrays.asList("all", "known", "novel"));
        this.knowns = this.getVariantEvalWalker().getKnowns();
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName, String FamilyName) {
        if (eval != null) {
            List knownComps = featureContext.getValues(this.knowns, eval.getStart());
            for (VariantContext c : knownComps) {
                if (eval.getType() != c.getType() && eval.getType() != VariantContext.Type.NO_VARIATION) continue;
                return KNOWN_STATES;
            }
        }
        return NOVEL_STATES;
    }
}

