/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.VariantStratifier;

public class OneBPIndel
extends VariantStratifier {
    private static final List<Object> ALL = Arrays.asList("all", "one.bp", "two.plus.bp");
    private static final List<Object> ONE_BP = Arrays.asList("all", "one.bp");
    private static final List<Object> TWO_PLUS_BP = Arrays.asList("all", "two.plus.bp");

    @Override
    public void initialize() {
        this.states.addAll(ALL);
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName, String FamilyName) {
        if (eval != null && eval.isIndel()) {
            Iterator iterator = eval.getIndelLengths().iterator();
            while (iterator.hasNext()) {
                int l = (Integer)iterator.next();
                if (Math.abs(l) <= 1) continue;
                return TWO_PLUS_BP;
            }
            return ONE_BP;
        }
        return ALL;
    }
}

