/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.hellbender.tools.walkers.varianteval.util.SnpEffUtil;

public class SnpEffPositionModifier
extends VariantStratifier {
    public static final String EFFECT_KEY = "SNPEFF_EFFECT";

    @Override
    public void initialize() {
        for (PositionModifier type : PositionModifier.values()) {
            this.states.add(type.name());
        }
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName, String FamilyName) {
        ArrayList<Object> relevantStates = new ArrayList<Object>();
        if (eval != null && eval.isVariant() && eval.hasAttribute(EFFECT_KEY)) {
            SnpEffUtil.EffectType effectType = SnpEffUtil.EffectType.valueOf(eval.getAttribute(EFFECT_KEY).toString());
            if (SnpEffUtil.isSubTypeOf(effectType, SnpEffUtil.EffectType.EXON)) {
                relevantStates.add(PositionModifier.GENE.name());
            }
            if (SnpEffUtil.isSubTypeOf(effectType, SnpEffUtil.EffectType.CDS)) {
                relevantStates.add(PositionModifier.CODING_REGION.name());
            }
            if (SnpEffUtil.isSubTypeOf(effectType, SnpEffUtil.EffectType.STOP_GAINED)) {
                relevantStates.add(PositionModifier.STOP_GAINED.name());
            }
            if (SnpEffUtil.isSubTypeOf(effectType, SnpEffUtil.EffectType.STOP_LOST)) {
                relevantStates.add(PositionModifier.STOP_LOST.name());
            }
            if (SnpEffUtil.isSubTypeOf(effectType, SnpEffUtil.EffectType.SPLICE_SITE_ACCEPTOR) || SnpEffUtil.isSubTypeOf(effectType, SnpEffUtil.EffectType.SPLICE_SITE_DONOR)) {
                relevantStates.add(PositionModifier.SPLICE_SITE.name());
            }
        }
        return relevantStates;
    }

    public static enum PositionModifier {
        GENE,
        CODING_REGION,
        SPLICE_SITE,
        STOP_GAINED,
        STOP_LOST;

    }
}

