/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public class TandemRepeat
extends VariantStratifier {
    private static final List<Object> JUST_ALL = Arrays.asList("all");
    private static final List<Object> ALL = Arrays.asList("all", "is.repeat", "not.repeat");
    private static final List<Object> REPEAT = Arrays.asList("all", "is.repeat");
    private static final List<Object> NOT_REPEAT = Arrays.asList("all", "not.repeat");

    @Override
    public void initialize() {
        this.states.addAll(ALL);
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName, String FamilyName) {
        if (eval == null || !eval.isIndel()) {
            return ALL;
        }
        byte[] bases = referenceContext.getBases(0, 50 - referenceContext.getInterval().size() + 1);
        if (GATKVariantContextUtils.isTandemRepeat(eval, bases)) {
            return REPEAT;
        }
        return NOT_REPEAT;
    }
}

