/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.manager;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.manager.StratNodeIterator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.manager.Stratifier;

class StratNode<T extends Stratifier<Object>>
implements Iterable<StratNode<T>> {
    int key = -1;
    final T stratifier;
    final Map<Object, StratNode<T>> subnodes;

    protected StratNode() {
        this.subnodes = Collections.emptyMap();
        this.stratifier = null;
    }

    protected StratNode(T stratifier, Map<Object, StratNode<T>> subnodes) {
        this.stratifier = stratifier;
        this.subnodes = Collections.unmodifiableMap(new HashMap<Object, StratNode<T>>(subnodes));
    }

    public void setKey(int key) {
        if (!this.isLeaf()) {
            throw new GATKException("Cannot set key of non-leaf node");
        }
        this.key = key;
    }

    public int find(List<Object> states, int offset) {
        if (this.isLeaf()) {
            return this.key;
        }
        Object state = states.get(offset);
        StratNode<T> subnode = this.subnodes.get(state);
        if (subnode == null) {
            return -1;
        }
        return subnode.find(states, offset + 1);
    }

    public void find(List<List<Object>> multipleStates, int offset, HashSet<Integer> keys) {
        if (this.isLeaf()) {
            keys.add(this.key);
        } else {
            for (Object state : multipleStates.get(offset)) {
                StratNode<T> subnode = this.subnodes.get(state);
                if (subnode == null) {
                    throw new GATKException("Couldn't find state for " + state + " at node " + this);
                }
                subnode.find(multipleStates, offset + 1, keys);
            }
        }
    }

    public int getKey() {
        if (!this.isLeaf()) {
            throw new GATKException("Cannot get key of non-leaf node");
        }
        return this.key;
    }

    protected Map<Object, StratNode<T>> getSubnodes() {
        return this.subnodes;
    }

    public int size() {
        if (this.isLeaf()) {
            return 1;
        }
        return this.subnodes.values().iterator().next().size() * this.subnodes.size();
    }

    public T getSetOfStates() {
        return this.stratifier;
    }

    public boolean isLeaf() {
        return this.stratifier == null;
    }

    @Override
    public Iterator<StratNode<T>> iterator() {
        return new StratNodeIterator(this);
    }
}

