/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.util;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.varianteval.VariantEval;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.manager.StratificationManager;
import org.broadinstitute.hellbender.utils.ClassUtils;

public class EvaluationContext {
    final VariantEval walker;
    private final List<VariantEvaluator> evaluationInstances;
    private final Set<Class<? extends VariantEvaluator>> evaluationClasses;
    public static final EvaluationContextCombiner COMBINER = new EvaluationContextCombiner();

    public EvaluationContext(VariantEval walker, Set<Class<? extends VariantEvaluator>> evaluationClasses) {
        this(walker, evaluationClasses, true);
    }

    private EvaluationContext(VariantEval walker, Set<Class<? extends VariantEvaluator>> evaluationClasses, boolean doInitialize) {
        this.walker = walker;
        this.evaluationClasses = evaluationClasses;
        this.evaluationInstances = new ArrayList<VariantEvaluator>(evaluationClasses.size());
        for (Class<? extends VariantEvaluator> c : evaluationClasses) {
            VariantEvaluator eval = ClassUtils.makeInstanceOf(c);
            if (doInitialize) {
                eval.initialize(walker);
            }
            this.evaluationInstances.add(eval);
        }
    }

    public List<VariantEvaluator> getEvaluationInstances() {
        return this.evaluationInstances;
    }

    public Set<Class<? extends VariantEvaluator>> getEvaluationClasses() {
        return this.evaluationClasses;
    }

    public final TreeSet<VariantEvaluator> getVariantEvaluators() {
        return new TreeSet<VariantEvaluator>(this.evaluationInstances);
    }

    public final void apply(ReferenceContext referenceContext, ReadsContext readsContext, FeatureContext featureContext, VariantContext comp, VariantContext eval) {
        block4: for (VariantEvaluator evaluation : this.evaluationInstances) {
            switch (evaluation.getComparisonOrder()) {
                case 1: {
                    if (eval == null) continue block4;
                    evaluation.update1(eval, referenceContext, readsContext, featureContext);
                    continue block4;
                }
                case 2: {
                    evaluation.update2(eval, comp, referenceContext, readsContext, featureContext);
                    continue block4;
                }
            }
            throw new GATKException("BUG: Unexpected evaluation order " + evaluation);
        }
    }

    public void combine(EvaluationContext rhs) {
        for (int i = 0; i < this.evaluationInstances.size(); ++i) {
            this.evaluationInstances.get(i).combine(rhs.evaluationInstances.get(i));
        }
    }

    private static class EvaluationContextCombiner
    implements StratificationManager.Combiner<EvaluationContext> {
        private EvaluationContextCombiner() {
        }

        @Override
        public EvaluationContext combine(EvaluationContext lhs, EvaluationContext rhs) {
            if (lhs == null) {
                lhs = new EvaluationContext(rhs.walker, rhs.evaluationClasses, false);
            }
            lhs.combine(rhs);
            return lhs;
        }
    }
}

