/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SnpEffUtil {
    private static final Map<EffectType, EffectType> snpEffectGraph = new HashMap<EffectType, EffectType>();
    private static final Map<EffectType, Set<EffectType>> snpEffectAncestorSet = new HashMap<EffectType, Set<EffectType>>();

    private static Set<EffectType> getParentSet(Set<EffectType> children) {
        HashSet<EffectType> parents = new HashSet<EffectType>();
        for (EffectType child : children) {
            EffectType parent = snpEffectGraph.get((Object)child);
            if (parent == null) continue;
            parents.add(parent);
        }
        return parents;
    }

    private static Set<EffectType> getAncestorSet(EffectType child, boolean isSelfIncluded) {
        HashSet<EffectType> ancestors = new HashSet<EffectType>();
        if (isSelfIncluded) {
            ancestors.add(child);
        }
        Set<EffectType> untraversedNodes = Collections.singleton(child);
        while (!untraversedNodes.isEmpty()) {
            Set<EffectType> putativeParents = SnpEffUtil.getParentSet(untraversedNodes);
            putativeParents.removeAll(ancestors);
            ancestors.addAll(putativeParents);
            untraversedNodes = putativeParents;
        }
        return ancestors;
    }

    public static boolean isSubTypeOf(EffectType childEffect, EffectType parentEffect) {
        Set<EffectType> ancestorSet = snpEffectAncestorSet.get((Object)childEffect);
        if (ancestorSet == null) {
            ancestorSet = new HashSet<EffectType>();
            ancestorSet.addAll(SnpEffUtil.getAncestorSet(childEffect, true));
            snpEffectAncestorSet.put(childEffect, ancestorSet);
        }
        return ancestorSet.contains((Object)parentEffect);
    }

    static {
        snpEffectGraph.put(EffectType.UPSTREAM, EffectType.INTERGENIC);
        snpEffectGraph.put(EffectType.DOWNSTREAM, EffectType.INTERGENIC);
        snpEffectGraph.put(EffectType.INTERGENIC_CONSERVED, EffectType.INTERGENIC);
        snpEffectGraph.put(EffectType.INTRON_CONSERVED, EffectType.INTRON);
        snpEffectGraph.put(EffectType.SPLICE_SITE_ACCEPTOR, EffectType.INTRON);
        snpEffectGraph.put(EffectType.SPLICE_SITE_DONOR, EffectType.INTRON);
        snpEffectGraph.put(EffectType.EXON_DELETED, EffectType.CDS);
        snpEffectGraph.put(EffectType.SYNONYMOUS_CODING, EffectType.CDS);
        snpEffectGraph.put(EffectType.NON_SYNONYMOUS_CODING, EffectType.CDS);
        snpEffectGraph.put(EffectType.SYNONYMOUS_STOP, EffectType.SYNONYMOUS_CODING);
        snpEffectGraph.put(EffectType.SYNONYMOUS_START, EffectType.SYNONYMOUS_CODING);
        snpEffectGraph.put(EffectType.START_LOST, EffectType.NON_SYNONYMOUS_CODING);
        snpEffectGraph.put(EffectType.STOP_GAINED, EffectType.NON_SYNONYMOUS_CODING);
        snpEffectGraph.put(EffectType.STOP_LOST, EffectType.NON_SYNONYMOUS_CODING);
        snpEffectGraph.put(EffectType.CODON_CHANGE, EffectType.NON_SYNONYMOUS_CODING);
        snpEffectGraph.put(EffectType.CODON_INSERTION, EffectType.NON_SYNONYMOUS_CODING);
        snpEffectGraph.put(EffectType.CODON_DELETION, EffectType.NON_SYNONYMOUS_CODING);
        snpEffectGraph.put(EffectType.CODON_CHANGE_PLUS_CODON_DELETION, EffectType.NON_SYNONYMOUS_CODING);
        snpEffectGraph.put(EffectType.CODON_CHANGE_PLUS_CODON_INSERTION, EffectType.NON_SYNONYMOUS_CODING);
        snpEffectGraph.put(EffectType.FRAME_SHIFT, EffectType.NON_SYNONYMOUS_CODING);
        snpEffectGraph.put(EffectType.UTR_5_DELETED, EffectType.UTR_5_PRIME);
        snpEffectGraph.put(EffectType.UTR_3_DELETED, EffectType.UTR_3_PRIME);
        snpEffectGraph.put(EffectType.START_GAINED, EffectType.UTR_5_PRIME);
        snpEffectGraph.put(EffectType.UTR_5_PRIME, EffectType.EXON);
        snpEffectGraph.put(EffectType.UTR_3_PRIME, EffectType.EXON);
        snpEffectGraph.put(EffectType.CDS, EffectType.EXON);
        snpEffectGraph.put(EffectType.INTRON, EffectType.TRANSCRIPT);
        snpEffectGraph.put(EffectType.EXON, EffectType.TRANSCRIPT);
        snpEffectGraph.put(EffectType.TRANSCRIPT, EffectType.GENE);
        snpEffectGraph.put(EffectType.REGULATION, EffectType.GENE);
        snpEffectGraph.put(EffectType.GENE, EffectType.CHROMOSOME);
        snpEffectGraph.put(EffectType.INTERGENIC, EffectType.CHROMOSOME);
    }

    public static enum EffectFunctionalClass {
        NONE(0),
        SILENT(1),
        MISSENSE(2),
        NONSENSE(3);

        private final int priority;

        private EffectFunctionalClass(int priority) {
            this.priority = priority;
        }

        public boolean isHigherPriorityThan(EffectFunctionalClass other) {
            return this.priority > other.priority;
        }
    }

    public static enum EffectType {
        SPLICE_SITE_ACCEPTOR,
        SPLICE_SITE_DONOR,
        START_LOST,
        EXON_DELETED,
        FRAME_SHIFT,
        STOP_GAINED,
        STOP_LOST,
        NON_SYNONYMOUS_CODING,
        CODON_CHANGE,
        CODON_INSERTION,
        CODON_CHANGE_PLUS_CODON_INSERTION,
        CODON_DELETION,
        CODON_CHANGE_PLUS_CODON_DELETION,
        UTR_5_DELETED,
        UTR_3_DELETED,
        SYNONYMOUS_START,
        NON_SYNONYMOUS_START,
        START_GAINED,
        SYNONYMOUS_CODING,
        SYNONYMOUS_STOP,
        NON_SYNONYMOUS_STOP,
        NONE,
        CHROMOSOME,
        CUSTOM,
        CDS,
        GENE,
        TRANSCRIPT,
        EXON,
        INTRON_CONSERVED,
        UTR_5_PRIME,
        UTR_3_PRIME,
        DOWNSTREAM,
        INTRAGENIC,
        INTERGENIC,
        INTERGENIC_CONSERVED,
        UPSTREAM,
        REGULATION,
        INTRON;

    }
}

