/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.varianteval.util;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.VariantContextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.varianteval.VariantEval;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.RequiredStratification;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.StandardStratification;
import org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.hellbender.utils.ClassUtils;
import org.broadinstitute.hellbender.utils.samples.Sample;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class VariantEvalUtils {
    private final VariantEval variantEvalWalker;
    Logger logger;
    private static final Map<String, Class<? extends VariantStratifier>> stratifierClasses = new HashMap<String, Class<? extends VariantStratifier>>();
    private static final Set<String> standardStratificationNames = new HashSet<String>();
    private static final Set<String> requiredStratificationNames = new HashSet<String>();
    private static final Map<String, Class<? extends VariantEvaluator>> evaluatorClasses;
    private static final Set<String> standardEvaluatorNames;

    public VariantEvalUtils(VariantEval variantEvalWalker) {
        this.variantEvalWalker = variantEvalWalker;
        this.logger = variantEvalWalker.getLogger();
    }

    public void listModulesAndExit() {
        this.logger.info("Available stratification modules:");
        this.logger.info("(Standard modules are starred)");
        for (String name : stratifierClasses.keySet()) {
            this.logger.info("\t" + name + (requiredStratificationNames.contains(name) || standardStratificationNames.contains(name) ? "*" : ""));
        }
        this.logger.info("");
        this.logger.info("Available evaluation modules:");
        this.logger.info("(Standard modules are starred)");
        for (String veName : evaluatorClasses.keySet()) {
            this.logger.info("\t" + veName + (standardEvaluatorNames.contains(veName) ? "*" : ""));
        }
        this.logger.info("");
        System.exit(0);
    }

    public List<VariantStratifier> initializeStratificationObjects(boolean noStandardStrats, List<String> modulesToUse) {
        TreeSet<VariantStratifier> strats = new TreeSet<VariantStratifier>();
        HashSet<String> stratsToUse = new HashSet<String>(requiredStratificationNames);
        if (!noStandardStrats) {
            stratsToUse.addAll(standardStratificationNames);
        }
        stratsToUse.addAll(modulesToUse);
        for (String module : stratsToUse) {
            if (!stratifierClasses.containsKey(module)) {
                throw new CommandLineException("Module " + module + " could not be found; please check that you have specified the class name correctly");
            }
            if (!stratifierClasses.containsKey(module)) continue;
            Class<? extends VariantStratifier> c = stratifierClasses.get(module);
            VariantStratifier vs = ClassUtils.makeInstanceOf(c);
            vs.setVariantEvalWalker(this.variantEvalWalker);
            vs.initialize();
            strats.add(vs);
        }
        return new ArrayList<VariantStratifier>(strats);
    }

    public Set<Class<? extends VariantEvaluator>> initializeEvaluationObjects(boolean noStandardEvals, List<String> modulesToUse) {
        TreeSet<String> evalsToUse = new TreeSet<String>(modulesToUse);
        if (!noStandardEvals) {
            evalsToUse.addAll(standardEvaluatorNames);
        }
        HashSet<Class<? extends VariantEvaluator>> evals = new HashSet<Class<? extends VariantEvaluator>>();
        for (String module : evalsToUse) {
            if (!evaluatorClasses.containsKey(module)) {
                throw new CommandLineException("Module " + module + " could not be found; please check that you have specified the class name correctly");
            }
            evals.add(evaluatorClasses.get(module));
        }
        if (evals.contains(evaluatorClasses.get("CompOverlap")) && evals.contains(evaluatorClasses.get("IndelSummary")) && evals.contains(evaluatorClasses.get("TiTvVariantEvaluator")) && evals.contains(evaluatorClasses.get("CountVariants")) && evals.contains(evaluatorClasses.get("MultiallelicSummary"))) {
            evals.add(evaluatorClasses.get("MetricsCollection"));
        }
        return evals;
    }

    public VariantContext getSubsetOfVariantContext(VariantContext vc, String sampleName) {
        return this.getSubsetOfVariantContext(vc, Collections.singleton(sampleName));
    }

    public VariantContext getSubsetOfVariantContext(VariantContext vc, Set<String> sampleNames) {
        boolean deriveAlleles = this.variantEvalWalker.ignoreAC0Sites();
        return this.ensureAnnotations(vc, vc.subContextFromSamples(sampleNames, deriveAlleles));
    }

    public VariantContext ensureAnnotations(VariantContext vc, VariantContext vcsub) {
        boolean hasChrCountAnnotations;
        int newAlleleCount;
        int originalAlleleCount = vc.getHetCount() + 2 * vc.getHomVarCount();
        boolean isSingleton = originalAlleleCount == (newAlleleCount = vcsub.getHetCount() + 2 * vcsub.getHomVarCount()) && newAlleleCount == 1;
        boolean bl = hasChrCountAnnotations = vcsub.hasAttribute("AC") && vcsub.hasAttribute("AF") && vcsub.hasAttribute("AN");
        if (!isSingleton && hasChrCountAnnotations) {
            return vcsub;
        }
        VariantContextBuilder builder = new VariantContextBuilder(vcsub);
        if (isSingleton) {
            builder.attribute("ISSINGLETON", (Object)true);
        }
        if (!hasChrCountAnnotations) {
            VariantContextUtils.calculateChromosomeCounts((VariantContextBuilder)builder, (boolean)true);
        }
        return builder.make();
    }

    public HashMap<FeatureInput<VariantContext>, HashMap<String, Collection<VariantContext>>> bindVariantContexts(ReferenceContext referenceContext, FeatureContext featureContext, List<FeatureInput<VariantContext>> tracks, boolean byFilter, boolean subsetBySample, boolean trackPerSample, boolean trackPerFamily, boolean mergeTracks) {
        HashMap<FeatureInput<VariantContext>, HashMap<String, Collection<VariantContext>>> bindings = new HashMap<FeatureInput<VariantContext>, HashMap<String, Collection<VariantContext>>>();
        FeatureInput<VariantContext> firstTrack = tracks.isEmpty() ? null : tracks.get(0);
        for (FeatureInput<VariantContext> track : tracks) {
            HashMap<String, Collection<VariantContext>> mapping = new HashMap<String, Collection<VariantContext>>();
            Iterator<VariantContext> iterator = featureContext.getValues(track, referenceContext.getInterval().getStart()).iterator();
            while (iterator.hasNext()) {
                VariantContext vc;
                VariantContext vcsub = vc = iterator.next();
                if (subsetBySample && vc.hasGenotypes()) {
                    vcsub = this.getSubsetOfVariantContext(vc, this.variantEvalWalker.getSampleNamesForEvaluation());
                }
                if (byFilter || !vcsub.isFiltered()) {
                    this.addMapping(mapping, VariantEval.getAllSampleName(), vcsub);
                }
                if (vc.hasGenotypes() && trackPerSample) {
                    for (String sampleName : this.variantEvalWalker.getSampleNamesForEvaluation()) {
                        VariantContext samplevc = this.getSubsetOfVariantContext(vc, sampleName);
                        if (!byFilter && samplevc.isFiltered()) continue;
                        this.addMapping(mapping, sampleName, samplevc);
                    }
                    continue;
                }
                if (!vc.hasGenotypes() || !trackPerFamily) continue;
                for (String familyName : this.variantEvalWalker.getFamilyNamesForEvaluation()) {
                    HashSet<String> familyMemberNames = new HashSet();
                    if (familyName.equals(VariantEval.getAllFamilyName())) {
                        familyMemberNames = this.variantEvalWalker.getSampleNamesForEvaluation();
                    } else {
                        Set<Sample> familyMembers = this.variantEvalWalker.getSampleDB().getFamily(familyName);
                        for (Sample s : familyMembers) {
                            familyMemberNames.add(s.getID());
                        }
                    }
                    VariantContext samplevc = this.getSubsetOfVariantContext(vc, familyMemberNames);
                    if (!byFilter && samplevc.isFiltered()) continue;
                    this.addMapping(mapping, familyName, samplevc);
                }
            }
            if (mergeTracks && bindings.containsKey(firstTrack)) {
                HashMap<String, Collection<VariantContext>> firstMapping = bindings.get(firstTrack);
                for (Map.Entry elt : mapping.entrySet()) {
                    Collection<VariantContext> firstMappingSet = firstMapping.get(elt.getKey());
                    if (firstMappingSet != null) {
                        firstMappingSet.addAll((Collection)elt.getValue());
                        continue;
                    }
                    firstMapping.put((String)elt.getKey(), (Collection<VariantContext>)elt.getValue());
                }
                continue;
            }
            bindings.put(track, mapping);
        }
        return bindings;
    }

    private void addMapping(HashMap<String, Collection<VariantContext>> mappings, String sample, VariantContext vc) {
        if (!mappings.containsKey(sample)) {
            mappings.put(sample, new ArrayList(1));
        }
        mappings.get(sample).add(vc);
    }

    static {
        Reflections reflectionsStrat = new Reflections("org.broadinstitute.hellbender.tools.walkers.varianteval.stratifications", new Scanner[0]);
        Set allClasses = reflectionsStrat.getSubTypesOf(VariantStratifier.class);
        for (Class clazz : allClasses) {
            stratifierClasses.put(clazz.getSimpleName(), clazz);
            if (StandardStratification.class.isAssignableFrom(clazz)) {
                standardStratificationNames.add(clazz.getSimpleName());
            }
            if (!RequiredStratification.class.isAssignableFrom(clazz)) continue;
            requiredStratificationNames.add(clazz.getSimpleName());
        }
        evaluatorClasses = new HashMap<String, Class<? extends VariantEvaluator>>();
        standardEvaluatorNames = new HashSet<String>();
        Reflections reflectionsEval = new Reflections("org.broadinstitute.hellbender.tools.walkers.varianteval.evaluators", new Scanner[0]);
        Set allEvalClasses = reflectionsEval.getSubTypesOf(VariantEvaluator.class);
        for (Class clazz : allEvalClasses) {
            evaluatorClasses.put(clazz.getSimpleName(), clazz);
            if (!StandardEval.class.isAssignableFrom(clazz)) continue;
            standardEvaluatorNames.add(clazz.getSimpleName());
        }
    }
}

