/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.variantutils;

import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.VariantContextUtils;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import htsjdk.variant.vcf.VCFUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.variantutils.FamilyLikelihoods;
import org.broadinstitute.hellbender.tools.walkers.variantutils.PosteriorProbabilitiesUtils;
import org.broadinstitute.hellbender.utils.samples.Sample;
import org.broadinstitute.hellbender.utils.samples.SampleDB;
import org.broadinstitute.hellbender.utils.samples.Trio;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.hellbender.utils.variant.VcfUtils;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="This tool calculates the posterior genotype probability for each sample genotype in a VCF of input variant calls,\n based on the genotype likelihoods from the samples themselves and, optionally, from input VCFs describing allele\n frequencies in related populations. The input variants must possess genotype likelihoods generated by\n HaplotypeCaller, UnifiedGenotyper or another source that provides *unbiased* genotype likelihoods.", oneLineSummary="Calculate genotype posterior probabilities given family and/or known population genotypes", programGroup=VariantEvaluationProgramGroup.class)
@DocumentedFeature
public final class CalculateGenotypePosteriors
extends VariantWalker {
    private static final Logger logger = LogManager.getLogger(CalculateGenotypePosteriors.class);
    public static final String SUPPORTING_CALLSETS_SHORT_NAME = "supporting";
    public static final String SUPPORTING_CALLSETS_LONG_NAME = "supporting-callsets";
    public static final String NUM_REF_SAMPLES_LONG_NAME = "num-reference-samples-if-no-call";
    @Argument(fullName="supporting-callsets", shortName="supporting", doc="Other callsets to use in generating genotype posteriors", optional=true)
    public List<FeatureInput<VariantContext>> supportVariants = new ArrayList<FeatureInput<VariantContext>>();
    @Argument(doc="File to which variants should be written", fullName="output", shortName="O", optional=false)
    public GATKPath out = null;
    @Argument(fullName="global-prior-snp", doc="Global Dirichlet prior parameters for the SNP allele frequency", optional=true)
    public double globalPriorSnp = 0.001;
    @Argument(fullName="global-prior-indel", doc="Global Dirichlet prior parameters for the indel allele frequency", optional=true)
    public double globalPriorIndel = 0.001;
    @Argument(fullName="de-novo-prior", doc="Prior for de novo mutations", optional=true)
    public double deNovoPrior = 1.0E-6;
    @Argument(fullName="num-reference-samples-if-no-call", doc="Number of hom-ref genotypes to infer at sites not present in a panel", optional=true)
    public int numRefIfMissing = 0;
    @Argument(fullName="default-to-allele-count", doc="Use AC rather than MLEAC", optional=true)
    public boolean defaultToAC = false;
    @Argument(fullName="ignore-input-samples", doc="Use external information only", optional=true)
    public boolean ignoreInputSamples = false;
    @Argument(fullName="discovered-allele-count-priors-off", doc="Do not use discovered allele count in the input callset for variants that do not appear in the external callset. ", optional=true)
    public boolean ignoreInputSamplesForMissingResources = false;
    @Argument(fullName="use-flat-priors-for-indels", shortName="skipIndels", doc="Use flat priors for indels")
    public boolean useFlatPriorsForIndels = false;
    @Argument(fullName="skip-population-priors", doc="Skip application of population-based priors", optional=true)
    public boolean skipPopulationPriors = false;
    @Argument(fullName="skip-family-priors", doc="Skip application of family-based priors", optional=true)
    public boolean skipFamilyPriors = false;
    @Argument(fullName="pedigree", shortName="ped", doc="Pedigree file for samples", optional=true)
    private GATKPath pedigreeFile = null;
    private FamilyLikelihoods famUtils;
    private VariantContextWriter vcfWriter;
    private PosteriorProbabilitiesUtils.PosteriorProbabilitiesOptions options;

    @Override
    public void onTraversalStart() {
        VCFHeader header;
        Set<Trio> trios;
        this.vcfWriter = this.createVCFWriter(this.out);
        SampleDB sampleDB = SampleDB.createSampleDBFromPedigree(this.pedigreeFile);
        Map<String, VCFHeader> vcfHeaders = Collections.singletonMap(this.getDrivingVariantsFeatureInput().getName(), this.getHeaderForVariants());
        SortedSet<String> vcfSamples = VcfUtils.getSortedSampleSet(vcfHeaders, GATKVariantContextUtils.GenotypeMergeType.REQUIRE_UNIQUE);
        if (!this.skipFamilyPriors && (trios = sampleDB.getTrios()).isEmpty()) {
            logger.warn("No PED file passed or no *non-skipped* trios found in PED file. Skipping family priors.");
            this.skipFamilyPriors = true;
        }
        if (!(header = vcfHeaders.values().iterator().next()).hasGenotypingData()) {
            throw new UserException.BadInput("VCF has no genotypes");
        }
        if (header.hasInfoLine("MLEAC")) {
            VCFInfoHeaderLine mleLine = header.getInfoHeaderLine("MLEAC");
            if (mleLine.getCountType() != VCFHeaderLineCount.A) {
                throw new UserException.BadInput("VCF does not have a properly formatted MLEAC field: the count type should be \"A\"");
            }
            if (mleLine.getType() != VCFHeaderLineType.Integer) {
                throw new UserException.BadInput("VCF does not have a properly formatted MLEAC field: the field type should be \"Integer\"");
            }
        }
        Set headerLines = VCFUtils.smartMergeHeaders(vcfHeaders.values(), (boolean)true);
        headerLines.add(VCFStandardHeaderLines.getInfoLine((String)"AC"));
        headerLines.add(VCFStandardHeaderLines.getInfoLine((String)"AF"));
        headerLines.add(VCFStandardHeaderLines.getInfoLine((String)"AN"));
        headerLines.add(GATKVCFHeaderLines.getFormatLine("PP"));
        headerLines.add(GATKVCFHeaderLines.getInfoLine("PG"));
        if (!this.skipFamilyPriors) {
            headerLines.add(GATKVCFHeaderLines.getFormatLine("JL"));
            headerLines.add(GATKVCFHeaderLines.getFormatLine("JP"));
        }
        headerLines.addAll(this.getDefaultToolVCFHeaderLines());
        this.vcfWriter.writeHeader(new VCFHeader(headerLines, vcfSamples));
        Map<String, Set<Sample>> families = sampleDB.getFamilies(vcfSamples);
        this.famUtils = new FamilyLikelihoods(sampleDB, this.deNovoPrior, vcfSamples, families);
        this.options = new PosteriorProbabilitiesUtils.PosteriorProbabilitiesOptions(this.globalPriorSnp, this.globalPriorIndel, !this.ignoreInputSamples, !this.defaultToAC, this.ignoreInputSamplesForMissingResources, this.useFlatPriorsForIndels);
    }

    @Override
    public void apply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        List otherVCs = featureContext.getValues(this.supportVariants);
        List<VariantContext> resourcesWithMatchingStarts = otherVCs.stream().filter(vc -> variant.getStart() == vc.getStart()).collect(Collectors.toList());
        VariantContextBuilder builder = new VariantContextBuilder(variant);
        if (!this.skipFamilyPriors && variant.isBiallelic()) {
            GenotypesContext gc = this.famUtils.calculatePosteriorGLs(variant);
            builder.genotypes(gc);
        }
        VariantContextUtils.calculateChromosomeCounts((VariantContextBuilder)builder, (boolean)false);
        VariantContext vc_familyPriors = builder.make();
        VariantContext vc_bothPriors = !this.skipPopulationPriors ? PosteriorProbabilitiesUtils.calculatePosteriorProbs(vc_familyPriors, resourcesWithMatchingStarts, resourcesWithMatchingStarts.isEmpty() ? this.numRefIfMissing : 0, this.options) : vc_familyPriors;
        this.vcfWriter.add(vc_bothPriors);
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }
}

