/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.variantutils;

import htsjdk.variant.utils.GeneralUtils;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.GenotypeType;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeAssignmentMethod;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.QualityUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.samples.Sample;
import org.broadinstitute.hellbender.utils.samples.SampleDB;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public final class FamilyLikelihoods {
    private static final Logger logger = LogManager.getLogger(FamilyLikelihoods.class);
    private final EnumMap<GenotypeType, EnumMap<GenotypeType, EnumMap<GenotypeType, Integer>>> mvCountMatrix = new EnumMap(GenotypeType.class);
    static final int NUM_CALLED_GENOTYPETYPES = 3;
    double[] configurationLikelihoodsMatrix = new double[27];
    private List<Sample> trios = new ArrayList<Sample>();
    public final double NO_JOINT_VALUE = -1.0;
    private double deNovoPrior = 1.0E-8;
    private static final double ONE_THIRD = 0.3333333333333333;
    private static final double LOG10_OF_ONE_THIRD = -0.4771213;

    public FamilyLikelihoods(SampleDB sampleDB, double DNprior, Set<String> vcfSamples, Map<String, Set<Sample>> families) {
        this.deNovoPrior = DNprior;
        Arrays.fill(this.configurationLikelihoodsMatrix, 0.0);
        this.buildMatrices();
        this.trios = this.setTrios(sampleDB, vcfSamples, families);
    }

    public void getUpdatedGenotypes(VariantContext vc, Genotype motherGenotype, Genotype fatherGenotype, Genotype childGenotype, ArrayList<Genotype> updatedGenotypes) {
        boolean fatherIsCalled = fatherGenotype != null && this.hasCalledGT(fatherGenotype.getType()) && fatherGenotype.hasLikelihoods();
        boolean motherIsCalled = motherGenotype != null && this.hasCalledGT(motherGenotype.getType()) && motherGenotype.hasLikelihoods();
        boolean childIsCalled = childGenotype != null && this.hasCalledGT(childGenotype.getType()) && childGenotype.hasLikelihoods();
        double[] uninformativeLikelihoods = new double[]{0.3333333333333333, 0.3333333333333333, 0.3333333333333333};
        double[] motherLikelihoods = motherIsCalled ? GeneralUtils.normalizeFromLog10((double[])motherGenotype.getLikelihoods().getAsVector()) : uninformativeLikelihoods;
        double[] fatherLikelihoods = fatherIsCalled ? GeneralUtils.normalizeFromLog10((double[])fatherGenotype.getLikelihoods().getAsVector()) : uninformativeLikelihoods;
        double[] childLikelihoods = childIsCalled ? GeneralUtils.normalizeFromLog10((double[])childGenotype.getLikelihoods().getAsVector()) : uninformativeLikelihoods;
        double[] motherLog10Posteriors = this.getPosteriors(FamilyMember.MOTHER);
        double[] fatherLog10Posteriors = this.getPosteriors(FamilyMember.FATHER);
        double[] childLog10Posteriors = this.getPosteriors(FamilyMember.CHILD);
        double[] motherPosteriors = GeneralUtils.normalizeFromLog10((double[])motherLog10Posteriors);
        double[] fatherPosteriors = GeneralUtils.normalizeFromLog10((double[])fatherLog10Posteriors);
        double[] childPosteriors = GeneralUtils.normalizeFromLog10((double[])childLog10Posteriors);
        double jointPosteriorProbability = -1.0;
        double jointTrioLikelihood = -1.0;
        if (childIsCalled && motherIsCalled && fatherIsCalled) {
            jointTrioLikelihood = motherLikelihoods[MathUtils.maxElementIndex(motherPosteriors)] * fatherLikelihoods[MathUtils.maxElementIndex(fatherPosteriors)] * childLikelihoods[MathUtils.maxElementIndex(childPosteriors)];
            jointPosteriorProbability = MathUtils.arrayMax(motherPosteriors) * MathUtils.arrayMax(fatherPosteriors) * MathUtils.arrayMax(childPosteriors);
        }
        updatedGenotypes.add(this.getUpdatedGenotype(vc, motherGenotype, jointTrioLikelihood, jointPosteriorProbability, motherLog10Posteriors));
        updatedGenotypes.add(this.getUpdatedGenotype(vc, fatherGenotype, jointTrioLikelihood, jointPosteriorProbability, fatherLog10Posteriors));
        updatedGenotypes.add(this.getUpdatedGenotype(vc, childGenotype, jointTrioLikelihood, jointPosteriorProbability, childLog10Posteriors));
    }

    private Genotype getUpdatedGenotype(VariantContext vc, Genotype genotype, double jointLikelihood, double jointPosteriorProb, double[] log10Posteriors) {
        if (genotype == null || !this.hasCalledGT(genotype.getType())) {
            return genotype;
        }
        int phredScaledJL = -1;
        int phredScaledJP = -1;
        if (jointLikelihood != -1.0) {
            double dphredScaledJL = QualityUtils.phredScaleLog10ErrorRate(Math.log10(1.0 - jointLikelihood));
            int n = phredScaledJL = dphredScaledJL < 127.0 ? (int)((int)dphredScaledJL) : 127;
        }
        if (jointPosteriorProb != -1.0) {
            double dphredScaledJP = QualityUtils.phredScaleLog10ErrorRate(Math.log10(1.0 - jointPosteriorProb));
            phredScaledJP = dphredScaledJP < 127.0 ? (int)((int)dphredScaledJP) : 127;
        }
        LinkedHashMap<String, Integer> genotypeAttributes = new LinkedHashMap<String, Integer>();
        genotypeAttributes.putAll(genotype.getExtendedAttributes());
        genotypeAttributes.put("JL", phredScaledJL);
        genotypeAttributes.put("JP", phredScaledJP);
        GenotypeBuilder builder = new GenotypeBuilder(genotype);
        GATKVariantContextUtils.makeGenotypeCall(vc.getMaxPloidy(2), builder, GenotypeAssignmentMethod.USE_PLS_TO_ASSIGN, log10Posteriors, vc.getAlleles(), null);
        builder.attribute("PP", Utils.listFromPrimitives(GenotypeLikelihoods.fromLog10Likelihoods((double[])log10Posteriors).getAsPLs()));
        builder.attributes(genotypeAttributes);
        return builder.make();
    }

    private double[] getPosteriors(FamilyMember recalcInd) {
        double[] marginalOverChangedHR = new double[9];
        double[] marginalOverChangedHET = new double[9];
        double[] marginalOverChangedHV = new double[9];
        double[] recalcPosteriors = new double[3];
        GenotypeType[] calledTypes = new GenotypeType[]{GenotypeType.HOM_REF, GenotypeType.HET, GenotypeType.HOM_VAR};
        int counter = 0;
        switch (recalcInd) {
            case MOTHER: {
                for (GenotypeType father : calledTypes) {
                    for (GenotypeType child : calledTypes) {
                        GenotypeType mother = GenotypeType.HOM_REF;
                        marginalOverChangedHR[counter] = this.configurationLikelihoodsMatrix[this.getLikelihoodMatrixIndex(mother, father, child)];
                        mother = GenotypeType.HET;
                        marginalOverChangedHET[counter] = this.configurationLikelihoodsMatrix[this.getLikelihoodMatrixIndex(mother, father, child)];
                        mother = GenotypeType.HOM_VAR;
                        marginalOverChangedHV[counter] = this.configurationLikelihoodsMatrix[this.getLikelihoodMatrixIndex(mother, father, child)];
                        ++counter;
                    }
                }
                break;
            }
            case FATHER: {
                for (GenotypeType mother : calledTypes) {
                    for (GenotypeType child : calledTypes) {
                        GenotypeType father = GenotypeType.HOM_REF;
                        marginalOverChangedHR[counter] = this.configurationLikelihoodsMatrix[this.getLikelihoodMatrixIndex(mother, father, child)];
                        father = GenotypeType.HET;
                        marginalOverChangedHET[counter] = this.configurationLikelihoodsMatrix[this.getLikelihoodMatrixIndex(mother, father, child)];
                        father = GenotypeType.HOM_VAR;
                        marginalOverChangedHV[counter] = this.configurationLikelihoodsMatrix[this.getLikelihoodMatrixIndex(mother, father, child)];
                        ++counter;
                    }
                }
                break;
            }
            case CHILD: {
                for (GenotypeType mother : calledTypes) {
                    for (GenotypeType father : calledTypes) {
                        GenotypeType child = GenotypeType.HOM_REF;
                        marginalOverChangedHR[counter] = this.configurationLikelihoodsMatrix[this.getLikelihoodMatrixIndex(mother, father, child)];
                        child = GenotypeType.HET;
                        marginalOverChangedHET[counter] = this.configurationLikelihoodsMatrix[this.getLikelihoodMatrixIndex(mother, father, child)];
                        child = GenotypeType.HOM_VAR;
                        marginalOverChangedHV[counter] = this.configurationLikelihoodsMatrix[this.getLikelihoodMatrixIndex(mother, father, child)];
                        ++counter;
                    }
                }
                break;
            }
            default: {
                throw new UserException(String.format("%d does not indicate a valid trio FamilyMember -- use 0 for mother, 1 for father, 2 for child", recalcInd.ordinal()));
            }
        }
        recalcPosteriors[0] = MathUtils.log10sumLog10(marginalOverChangedHR, 0);
        recalcPosteriors[1] = MathUtils.log10sumLog10(marginalOverChangedHET, 0);
        recalcPosteriors[2] = MathUtils.log10sumLog10(marginalOverChangedHV, 0);
        return MathUtils.scaleLogSpaceArrayForNumericalStability(recalcPosteriors);
    }

    public GenotypesContext calculatePosteriorGLs(VariantContext vc) {
        Utils.nonNull(vc);
        GenotypesContext genotypesContext = GenotypesContext.copy((GenotypesContext)vc.getGenotypes());
        for (Sample sample : this.trios) {
            Genotype mother = vc.getGenotype(sample.getMaternalID());
            Genotype father = vc.getGenotype(sample.getPaternalID());
            Genotype child = vc.getGenotype(sample.getID());
            if (mother == null && father == null || child == null) {
                logger.warn("Null genotypes in variant: " + vc.toStringDecodeGenotypes());
                continue;
            }
            ArrayList<Genotype> trioGenotypes = new ArrayList<Genotype>(3);
            this.updateFamilyGenotypes(vc, mother, father, child, trioGenotypes);
            if (trioGenotypes.isEmpty()) continue;
            genotypesContext.replace(trioGenotypes.get(0));
            genotypesContext.replace(trioGenotypes.get(1));
            genotypesContext.replace(trioGenotypes.get(2));
        }
        return genotypesContext;
    }

    private List<Sample> setTrios(SampleDB sampleDB, Set<String> vcfSamples, Map<String, Set<Sample>> families) {
        ArrayList<Sample> trios = new ArrayList<Sample>();
        for (Map.Entry<String, Set<Sample>> familyEntry : families.entrySet()) {
            Set<Sample> family = familyEntry.getValue();
            TreeSet<Sample> familyMembersInVCF = new TreeSet<Sample>();
            for (Sample familyMember : family) {
                if (!vcfSamples.contains(familyMember.getID())) continue;
                familyMembersInVCF.add(familyMember);
            }
            family = familyMembersInVCF;
            if (family.size() != 3) continue;
            for (Sample familyMember : family) {
                List<Sample> parents = sampleDB.getParents(familyMember);
                if (parents.size() != 2 || !family.containsAll(parents)) continue;
                trios.add(familyMember);
            }
        }
        return trios;
    }

    private void buildMatrices() {
        for (GenotypeType mother : GenotypeType.values()) {
            this.mvCountMatrix.put(mother, new EnumMap(GenotypeType.class));
            for (GenotypeType father : GenotypeType.values()) {
                this.mvCountMatrix.get(mother).put(father, new EnumMap(GenotypeType.class));
                for (GenotypeType child : GenotypeType.values()) {
                    this.mvCountMatrix.get(mother).get(father).put(child, this.getCombinationMVCount(mother, father, child));
                }
            }
        }
    }

    private int getCombinationMVCount(GenotypeType mother, GenotypeType father, GenotypeType child) {
        if (child == GenotypeType.NO_CALL || child == GenotypeType.UNAVAILABLE) {
            return 0;
        }
        ArrayList<GenotypeType> parents = new ArrayList<GenotypeType>();
        if (mother != GenotypeType.NO_CALL && mother != GenotypeType.UNAVAILABLE) {
            parents.add(mother);
        }
        if (father != GenotypeType.NO_CALL && father != GenotypeType.UNAVAILABLE) {
            parents.add(father);
        }
        if (parents.isEmpty()) {
            return 0;
        }
        int parentsNumRefAlleles = 0;
        int parentsNumAltAlleles = 0;
        for (GenotypeType parent : parents) {
            if (parent == GenotypeType.HOM_REF) {
                ++parentsNumRefAlleles;
                continue;
            }
            if (parent == GenotypeType.HET) {
                ++parentsNumRefAlleles;
                ++parentsNumAltAlleles;
                continue;
            }
            if (parent != GenotypeType.HOM_VAR) continue;
            ++parentsNumAltAlleles;
        }
        if (child == GenotypeType.HOM_REF) {
            if (parentsNumRefAlleles == parents.size()) {
                return 0;
            }
            return parents.size() - parentsNumRefAlleles;
        }
        if (child == GenotypeType.HOM_VAR) {
            if (parentsNumAltAlleles == parents.size()) {
                return 0;
            }
            return parents.size() - parentsNumAltAlleles;
        }
        if (child == GenotypeType.HET && (parentsNumRefAlleles > 0 && parentsNumAltAlleles > 0 || parents.size() < 2)) {
            return 0;
        }
        return 1;
    }

    private void updateFamilyGenotypes(VariantContext vc, Genotype mother, Genotype father, Genotype child, ArrayList<Genotype> finalGenotypes) {
        EnumMap<GenotypeType, Double> motherLikelihoods = this.getLikelihoodsAsMapSafeNull(mother);
        EnumMap<GenotypeType, Double> fatherLikelihoods = this.getLikelihoodsAsMapSafeNull(father);
        EnumMap<GenotypeType, Double> childLikelihoods = this.getLikelihoodsAsMapSafeNull(child);
        if (!this.hasCalledGT(child.getType()) || !this.hasCalledGT(mother.getType()) && !this.hasCalledGT(father.getType())) {
            return;
        }
        for (Map.Entry childGenotype : childLikelihoods.entrySet()) {
            for (Map.Entry motherGenotype : motherLikelihoods.entrySet()) {
                for (Map.Entry fatherGenotype : fatherLikelihoods.entrySet()) {
                    int mvCount = this.mvCountMatrix.get(motherGenotype.getKey()).get(fatherGenotype.getKey()).get(childGenotype.getKey());
                    double jointLikelihood = (Double)motherGenotype.getValue() + (Double)fatherGenotype.getValue() + (Double)childGenotype.getValue();
                    double mvCoeff = mvCount > 0 ? Math.pow(this.deNovoPrior, mvCount) : 1.0 - 10.0 * this.deNovoPrior - this.deNovoPrior * this.deNovoPrior;
                    double configurationLikelihood = Math.log10(mvCoeff) + jointLikelihood;
                    int matInd = this.getLikelihoodMatrixIndex((GenotypeType)motherGenotype.getKey(), (GenotypeType)fatherGenotype.getKey(), (GenotypeType)childGenotype.getKey());
                    this.configurationLikelihoodsMatrix[matInd] = configurationLikelihood;
                }
            }
        }
        this.getUpdatedGenotypes(vc, mother, father, child, finalGenotypes);
    }

    private EnumMap<GenotypeType, Double> getLikelihoodsAsMapSafeNull(Genotype genotype) {
        double[] likelihoods;
        EnumMap<GenotypeType, Double> likelihoodsMap = new EnumMap<GenotypeType, Double>(GenotypeType.class);
        if (genotype != null && this.hasCalledGT(genotype.getType()) && genotype.hasExtendedAttribute("PP")) {
            Object GPfromVCF = genotype.getExtendedAttribute("PP");
            String[] likelihoodsAsStringVector = ((String)GPfromVCF).split(",");
            double[] likelihoodsAsVector = new double[likelihoodsAsStringVector.length];
            for (int i = 0; i < likelihoodsAsStringVector.length; ++i) {
                likelihoodsAsVector[i] = Double.parseDouble(likelihoodsAsStringVector[i]) / -10.0;
            }
            likelihoods = GeneralUtils.normalizeFromLog10((double[])likelihoodsAsVector, (boolean)true, (boolean)true);
        } else {
            likelihoods = genotype == null || !this.hasCalledGT(genotype.getType()) || genotype.getLikelihoods() == null ? new double[]{-0.4771213, -0.4771213, -0.4771213} : GeneralUtils.normalizeFromLog10((double[])genotype.getLikelihoods().getAsVector(), (boolean)true, (boolean)true);
        }
        if (likelihoods.length != 3) {
            String key = genotype.hasExtendedAttribute("PP") ? "PP" : "PL";
            throw new UserException(genotype + " has " + likelihoods.length + " " + key + " values, should be " + 3 + " since only the diploid case is supported when applying family priors.");
        }
        likelihoodsMap.put(GenotypeType.HOM_REF, likelihoods[this.genotypeTypeToValue(GenotypeType.HOM_REF)]);
        likelihoodsMap.put(GenotypeType.HET, likelihoods[this.genotypeTypeToValue(GenotypeType.HET)]);
        likelihoodsMap.put(GenotypeType.HOM_VAR, likelihoods[this.genotypeTypeToValue(GenotypeType.HOM_VAR)]);
        return likelihoodsMap;
    }

    private int getLikelihoodMatrixIndex(GenotypeType mother, GenotypeType father, GenotypeType child) {
        int childInd = this.genotypeTypeToValue(child);
        int INVALID = -1;
        int motherInd = this.genotypeTypeToValue(mother);
        int fatherInd = this.genotypeTypeToValue(father);
        if (childInd == -1 || motherInd == -1 || fatherInd == -1) {
            return -1;
        }
        return motherInd * 3 * 3 + fatherInd * 3 + childInd;
    }

    private int genotypeTypeToValue(GenotypeType input) {
        if (input == GenotypeType.HOM_REF) {
            return 0;
        }
        if (input == GenotypeType.HET) {
            return 1;
        }
        if (input == GenotypeType.HOM_VAR) {
            return 2;
        }
        return -1;
    }

    private boolean hasCalledGT(GenotypeType genotype) {
        return genotype == GenotypeType.HOM_REF || genotype == GenotypeType.HET || genotype == GenotypeType.HOM_VAR;
    }

    private static enum FamilyMember {
        MOTHER,
        FATHER,
        CHILD;

    }
}

