/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.variantutils;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFUtils;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeAssignmentMethod;
import org.broadinstitute.hellbender.utils.IndexRange;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.read.AlignmentUtils;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.hellbender.utils.variant.VcfUtils;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(summary="This tool takes a VCF file, left-aligns the indels and trims common bases from indels,leaving them with a minimum representation. The same indel can often be placed at multiple positions and stillrepresent the same haplotype. While the standard convention with VCF is to place an indel at the left-most positionthis isn't always done, so this tool can be used to left-align them. This tool optionally splits multiallelicsites into biallelics and left-aligns individual alleles. Optionally, the tool will not trim common bases from indels.", oneLineSummary="Left align and trim vairants", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public class LeftAlignAndTrimVariants
extends VariantWalker {
    public static final String DONT_TRIM_ALLELES_LONG_NAME = "dont-trim-alleles";
    public static final String DONT_TRIM_ALLELES_SHORT_NAME = "no-trim";
    public static final String SPLIT_MULTIALLELEICS_LONG_NAME = "split-multi-allelics";
    public static final String KEEP_ORIGINAL_AC_LONG_NAME = "keep-original-ac";
    public static final String MAX_INDEL_LENGTH_LONG_NAME = "max-indel-length";
    public static final int DEFAULT_MAX_LEADING_BASES = 1000;
    @VisibleForTesting
    static final int DEFAULT_MAX_INDEL_SIZE = 200;
    public static final String MAX_LEADING_BASES_LONG_NAME = "max-leading-bases";
    @Argument(fullName="output", shortName="O", doc="File to which variants should be written")
    public GATKPath outFile = null;
    @Argument(fullName="dont-trim-alleles", shortName="no-trim", doc="Do not Trim alleles to remove bases common to all of them", optional=true)
    protected boolean dontTrimAlleles = false;
    @Argument(fullName="split-multi-allelics", doc="Split multiallelic records and left-align individual alleles", optional=true)
    protected boolean splitMultiallelics = false;
    @Argument(fullName="keep-original-ac", doc="Store the original AC, AF, and AN values after subsetting", optional=true)
    private boolean keepOriginalChrCounts = false;
    @Argument(fullName="max-indel-length", doc="Set maximum indel size to realign", optional=true)
    protected int maxIndelSize = 200;
    @Argument(fullName="max-leading-bases", doc="Set max reference window size to look back before allele", optional=true)
    protected int maxLeadingBases = 1000;
    @Hidden
    @Argument(fullName="suppress-reference-path", optional=true, doc="Suppress reference path in output for test result differencing")
    private boolean suppressReferencePath = false;
    private VariantContextWriter vcfWriter = null;
    private VCFHeader vcfHeader = null;
    VariantContext lastVariant;

    @Override
    public void onTraversalStart() {
        Map<String, VCFHeader> vcfHeaders = Collections.singletonMap(this.getDrivingVariantsFeatureInput().getName(), this.getHeaderForVariants());
        SortedSet<String> vcfSamples = VcfUtils.getSortedSampleSet(vcfHeaders, GATKVariantContextUtils.GenotypeMergeType.REQUIRE_UNIQUE);
        Path refPath = this.referenceArguments.getReferencePath();
        Set<VCFHeaderLine> actualLines = VcfUtils.updateHeaderContigLines(this.createVCFHeaderLineList(vcfHeaders), refPath, this.getReferenceDictionary(), this.suppressReferencePath);
        this.vcfWriter = this.createVCFWriter(this.outFile);
        this.vcfHeader = new VCFHeader(actualLines, vcfSamples);
        this.vcfWriter.writeHeader(this.vcfHeader);
    }

    private Set<VCFHeaderLine> createVCFHeaderLineList(Map<String, VCFHeader> vcfHeaders) {
        Set headerLines = VCFUtils.smartMergeHeaders(vcfHeaders.values(), (boolean)true);
        headerLines.addAll(this.getDefaultToolVCFHeaderLines());
        if (this.splitMultiallelics) {
            GATKVariantContextUtils.addChromosomeCountsToHeader(headerLines);
        }
        if (this.keepOriginalChrCounts) {
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AC_Orig"));
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AF_Orig"));
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AN_Orig"));
        }
        return headerLines;
    }

    @Override
    public void apply(VariantContext vc, ReadsContext readsContext, ReferenceContext ref, FeatureContext featureContext) {
        List<VariantContext> vcList = this.splitMultiallelics ? (vc.getGenotypes().stream().anyMatch(g -> g.hasAnyAttribute("AF")) ? GATKVariantContextUtils.splitSomaticVariantContextToBiallelics(vc, false, this.vcfHeader) : GATKVariantContextUtils.splitVariantContextToBiallelics(vc, false, GenotypeAssignmentMethod.BEST_MATCH_TO_ORIGINAL, this.keepOriginalChrCounts)) : Collections.singletonList(vc);
        for (VariantContext splitVariant : vcList) {
            int indelLength;
            List indelLengths = splitVariant.getIndelLengths();
            int n = indelLength = indelLengths == null ? 0 : indelLengths.stream().map(Math::abs).max(Integer::compareTo).orElse(0);
            if (indelLength > this.maxIndelSize) {
                this.logger.info(String.format("%s (%d) at position %s:%d; skipping that record. Set --max-indel-length >= %d", "Indel is too long", indelLength, splitVariant.getContig(), splitVariant.getStart(), indelLength));
                this.lastVariant = splitVariant;
                this.vcfWriter.add(splitVariant);
                continue;
            }
            int distanceToLastVariant = this.lastVariant != null && splitVariant.contigsMatch((Locatable)this.lastVariant) ? splitVariant.getStart() - this.lastVariant.getEnd() : Integer.MAX_VALUE;
            this.lastVariant = LeftAlignAndTrimVariants.leftAlignAndTrim(splitVariant, ref, Math.min(this.maxLeadingBases, distanceToLastVariant - 1), !this.dontTrimAlleles);
            this.vcfWriter.add(this.lastVariant);
        }
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public Object onTraversalSuccess() {
        return "SUCCESS";
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }

    @VisibleForTesting
    static VariantContext leftAlignAndTrim(VariantContext vc, ReferenceContext ref, int maxLeadingBases, boolean trim) {
        if (!vc.isIndel() || maxLeadingBases <= 0) {
            return vc;
        }
        int leadingBases = Math.min(maxLeadingBases, 10);
        while (leadingBases <= maxLeadingBases) {
            List<IndexRange> alleleRanges;
            int refStart = Math.max(vc.getStart() - leadingBases, 1);
            byte[] refSeq = ref.getBases(new SimpleInterval(vc.getContig(), refStart, vc.getEnd()));
            int variantOffsetInRef = vc.getStart() - refStart;
            List<byte[]> sequences = vc.getAlleles().stream().map(a -> {
                byte[] result = new byte[variantOffsetInRef + a.length()];
                System.arraycopy(refSeq, 0, result, 0, variantOffsetInRef);
                System.arraycopy(a.getBases(), 0, result, variantOffsetInRef, a.length());
                return result;
            }).collect(Collectors.toList());
            Pair<Integer, Integer> shifts = AlignmentUtils.normalizeAlleles(sequences, alleleRanges = vc.getAlleles().stream().map(a -> new IndexRange(variantOffsetInRef + 1, variantOffsetInRef + a.length())).collect(Collectors.toList()), variantOffsetInRef, trim);
            if ((Integer)shifts.getLeft() == 0 && (Integer)shifts.getRight() == 0) {
                return vc;
            }
            if ((Integer)shifts.getLeft() != variantOffsetInRef || leadingBases >= maxLeadingBases) {
                Map<Allele, Allele> alleleMap = IntStream.range(0, alleleRanges.size()).boxed().collect(Collectors.toMap(n -> (Allele)vc.getAlleles().get((int)n), n -> Allele.create((byte[])Arrays.copyOfRange((byte[])sequences.get((int)n), variantOffsetInRef - (Integer)shifts.getLeft(), variantOffsetInRef - (Integer)shifts.getRight() + ((Allele)vc.getAlleles().get((int)n)).length()), (n == 0 ? 1 : 0) != 0)));
                GenotypesContext newGenotypes = GenotypesContext.create((int)vc.getNSamples());
                for (Genotype genotype : vc.getGenotypes()) {
                    List newAlleles = genotype.getAlleles().stream().map(a -> alleleMap.getOrDefault(a, Allele.NO_CALL)).collect(Collectors.toList());
                    newGenotypes.add(new GenotypeBuilder(genotype).alleles(newAlleles).make());
                }
                return new VariantContextBuilder(vc).start((long)(vc.getStart() - (Integer)shifts.getLeft())).stop((long)(vc.getEnd() - (Integer)shifts.getRight())).alleles(alleleMap.values()).genotypes(newGenotypes).make();
            }
            leadingBases = Math.min(2 * leadingBases, maxLeadingBases);
        }
        return vc;
    }
}

