/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.variantutils;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.DbsnpArgumentCollection;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.annotator.Annotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.AnnotationUtils;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.QualByDepth;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_QualByDepth;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotation;
import org.broadinstitute.hellbender.tools.walkers.genotyper.AlleleSubsettingUtils;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeAssignmentMethod;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeCalculationArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.genotyper.OutputMode;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerGenotypingEngine;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceMode;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.genotyper.IndexedSampleList;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;
import org.broadinstitute.hellbender.utils.logging.OneShotLogger;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.hellbender.utils.variant.writers.GVCFWriter;
import picard.cmdline.programgroups.OtherProgramGroup;

@BetaFeature
@CommandLineProgramProperties(summary="Compress a single-sample GVCF from HaplotypeCaller by merging homRef blocks using new GQ band parameters", oneLineSummary="Condenses homRef blocks in a single-sample GVCF", programGroup=OtherProgramGroup.class, omitFromCommandLine=true)
@DocumentedFeature
public final class ReblockGVCF
extends VariantWalker {
    private static final OneShotLogger logger = new OneShotLogger(ReblockGVCF.class);
    private static final int PLOIDY_TWO = 2;
    @Argument(fullName="output", shortName="O", doc="File to which variants should be written")
    private GATKPath outputFile;
    @ArgumentCollection
    public GenotypeCalculationArgumentCollection genotypeArgs = new GenotypeCalculationArgumentCollection();
    @Advanced
    @Argument(fullName="floor-blocks", doc="Output the band lower bound for each GQ block regardless of the data it represents", optional=true)
    private boolean floorBlocks = false;
    @Advanced
    @Argument(fullName="gvcf-gq-bands", shortName="GQB", doc="Exclusive upper bounds for reference confidence GQ bands (must be in [1, 100] and specified in increasing order)")
    public List<Integer> GVCFGQBands = new ArrayList<Integer>();
    @Advanced
    @Argument(fullName="drop-low-quals", shortName="drop-low-quals", doc="Exclude variants and homRef blocks that are GQ0 from the reblocked GVCF to save space; drop low quality/uncalled alleles")
    protected boolean dropLowQuals;
    @Advanced
    @Argument(fullName="rgq-threshold-to-no-call", shortName="rgq-threshold", doc="Reference genotype quality (PL[0]) value below which variant sites will be converted to GQ0 homRef calls")
    protected double rgqThreshold;
    @Advanced
    @Argument(fullName="do-qual-score-approximation", shortName="do-qual-approx", doc="Add necessary INFO field annotation to perform QUAL approximation downstream; required for GnarlyGenotyper")
    protected boolean doQualApprox;
    @Advanced
    @Argument(fullName="allow-missing-hom-ref-data", doc="Fill in homozygous reference genotypes with no PLs and no GQ with PL=[0,0,0].  Necessary for input from Regeneron's WeCall variant caller.")
    protected boolean allowMissingHomRefData;
    @ArgumentCollection
    protected DbsnpArgumentCollection dbsnp;
    private HaplotypeCallerGenotypingEngine genotypingEngine;
    private VariantAnnotatorEngine annotationEngine;
    private final List<String> infoFieldAnnotationKeyNamesToRemove;
    private VariantContextWriter vcfWriter;

    public ReblockGVCF() {
        this.GVCFGQBands.add(20);
        this.GVCFGQBands.add(100);
        this.dropLowQuals = false;
        this.rgqThreshold = 0.0;
        this.doQualApprox = false;
        this.allowMissingHomRefData = false;
        this.dbsnp = new DbsnpArgumentCollection();
        this.infoFieldAnnotationKeyNamesToRemove = Arrays.asList("GVCFBlock", "HaplotypeScore", "InbreedingCoeff", "MLEAC", "MLEAF", "ExcessHet");
    }

    @Override
    public boolean useVariantAnnotations() {
        return true;
    }

    @Override
    public List<Class<? extends Annotation>> getDefaultVariantAnnotationGroups() {
        return Arrays.asList(StandardAnnotation.class, AS_StandardAnnotation.class);
    }

    @Override
    public void onTraversalStart() {
        VCFHeader inputHeader = this.getHeaderForVariants();
        if (inputHeader.getGenotypeSamples().size() > 1) {
            throw new UserException.BadInput("ReblockGVCF is a single sample tool, but the input GVCF has more than 1 sample.");
        }
        Set inputHeaders = inputHeader.getMetaDataInSortedOrder();
        HashSet<Object> headerLines = new HashSet<Object>(inputHeaders);
        headerLines.removeIf(vcfHeaderLine -> vcfHeaderLine.getKey().startsWith("GVCFBlock") || vcfHeaderLine.getKey().equals("INFO") && ((VCFInfoHeaderLine)vcfHeaderLine).getID().equals("RAW_MQ") || vcfHeaderLine.getKey().equals("INFO") && this.infoFieldAnnotationKeyNamesToRemove.contains(((VCFInfoHeaderLine)vcfHeaderLine).getID()));
        headerLines.addAll(this.getDefaultToolVCFHeaderLines());
        this.genotypingEngine = this.createGenotypingEngine(new IndexedSampleList(inputHeader.getGenotypeSamples()));
        this.createAnnotationEngine();
        headerLines.addAll(this.annotationEngine.getVCFAnnotationDescriptions(false));
        headerLines.add(VCFStandardHeaderLines.getInfoLine((String)"DP"));
        headerLines.add(GATKVCFHeaderLines.getInfoLine("QUALapprox"));
        headerLines.add(GATKVCFHeaderLines.getInfoLine("AS_QUALapprox"));
        headerLines.add(GATKVCFHeaderLines.getInfoLine("VarDP"));
        headerLines.add(GATKVCFHeaderLines.getInfoLine("AS_VarDP"));
        headerLines.add(GATKVCFHeaderLines.getInfoLine("RAW_GT_COUNT"));
        headerLines.add(GATKVCFHeaderLines.getInfoLine("RAW_MQandDP"));
        headerLines.add(GATKVCFHeaderLines.getInfoLine("MQ_DP"));
        if (inputHeader.hasInfoLine("RAW_MQ")) {
            headerLines.add(GATKVCFHeaderLines.getInfoLine("RAW_MQ"));
        }
        if (this.dbsnp.dbsnp != null) {
            VCFStandardHeaderLines.addStandardInfoLines(headerLines, (boolean)true, (String[])new String[]{"DB"});
        }
        VariantContextWriter writer = this.createVCFWriter(this.outputFile);
        try {
            this.vcfWriter = new GVCFWriter(writer, new ArrayList<Number>(this.GVCFGQBands), 2, this.floorBlocks);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("GQBands are malformed: " + e.getMessage(), e);
        }
        this.vcfWriter.writeHeader(new VCFHeader(headerLines, inputHeader.getGenotypeSamples()));
        if (this.genotypeArgs.samplePloidy != 2) {
            throw new UserException.BadInput("The -ploidy parameter is ignored in " + this.getClass().getSimpleName() + " tool as this is tool assumes a diploid sample");
        }
    }

    private HaplotypeCallerGenotypingEngine createGenotypingEngine(SampleList samples) {
        HaplotypeCallerArgumentCollection hcArgs = new HaplotypeCallerArgumentCollection();
        hcArgs.standardArgs.outputMode = OutputMode.EMIT_ALL_ACTIVE_SITES;
        hcArgs.standardArgs.annotateAllSitesWithPLs = true;
        hcArgs.standardArgs.genotypeArgs = this.genotypeArgs.clone();
        hcArgs.emitReferenceConfidence = ReferenceConfidenceMode.GVCF;
        return new HaplotypeCallerGenotypingEngine(hcArgs, samples, true, false);
    }

    @VisibleForTesting
    protected void createAnnotationEngine() {
        this.annotationEngine = new VariantAnnotatorEngine(this.makeVariantAnnotations(), this.dbsnp.dbsnp, Collections.emptyList(), false, false);
    }

    @Override
    public void apply(VariantContext variant, ReadsContext reads, ReferenceContext ref, FeatureContext features) {
        VariantContext newVC = this.regenotypeVC(variant);
        if (newVC != null) {
            this.vcfWriter.add(newVC);
        }
    }

    private VariantContext regenotypeVC(VariantContext originalVC) {
        VariantContext result = originalVC;
        if (this.isHomRefBlock(result)) {
            return this.filterHomRefBlock(result);
        }
        if (result.getAttributeAsInt("DP", 0) > 0 && !this.isHomRefCall(result) && this.dropLowQuals) {
            result = this.genotypingEngine.calculateGenotypes(originalVC);
        }
        if (result == null) {
            return null;
        }
        if (this.shouldBeReblocked(result)) {
            return this.lowQualVariantToGQ0HomRef(result, originalVC);
        }
        return this.cleanUpHighQualityVariant(result, originalVC);
    }

    private boolean isHomRefBlock(VariantContext result) {
        return result.getAlternateAlleles().contains(Allele.NON_REF_ALLELE) && result.hasAttribute("END");
    }

    private boolean isHomRefCall(VariantContext result) {
        Genotype genotype = result.getGenotype(0);
        return genotype.isHomRef() && result.getLog10PError() != 1.0;
    }

    private VariantContext filterHomRefBlock(VariantContext result) {
        Genotype genotype = result.getGenotype(0);
        if (this.dropLowQuals && (!genotype.hasGQ() || (double)genotype.getGQ() < this.rgqThreshold || genotype.getGQ() == 0)) {
            return null;
        }
        if (genotype.isCalled() && genotype.isHomRef()) {
            if (!genotype.hasPL()) {
                if (genotype.hasGQ()) {
                    logger.warn("PL is missing for hom ref genotype at at least one position for sample " + genotype.getSampleName() + ": " + result.getContig() + ":" + result.getStart() + ".  Using GQ to determine quality.");
                    int gq = genotype.getGQ();
                    GenotypeBuilder gBuilder = new GenotypeBuilder(genotype);
                    VariantContextBuilder vcBuilder = new VariantContextBuilder(result);
                    vcBuilder.genotypes(new Genotype[]{gBuilder.GQ(gq).make()});
                    return vcBuilder.make();
                }
                String message = "Homozygous reference genotypes must contain GQ or PL. Both are missing for hom ref genotype at " + result.getContig() + ":" + result.getStart() + " for sample " + genotype.getSampleName() + ".";
                if (this.allowMissingHomRefData) {
                    logger.warn(message);
                    GenotypeBuilder gBuilder = new GenotypeBuilder(genotype);
                    VariantContextBuilder vcBuilder = new VariantContextBuilder(result);
                    vcBuilder.genotypes(new Genotype[]{gBuilder.GQ(0).PL(new int[]{0, 0, 0}).make()});
                    return vcBuilder.make();
                }
                throw new UserException.BadInput(message);
            }
            return result;
        }
        if (!genotype.isCalled() && genotype.hasPL() && genotype.getPL()[0] == 0) {
            return result;
        }
        return null;
    }

    @VisibleForTesting
    protected boolean shouldBeReblocked(VariantContext result) {
        Genotype genotype = result.getGenotype(0);
        return !genotype.isCalled() || genotype.hasPL() && (double)genotype.getPL()[0] < this.rgqThreshold || genotype.isHomRef();
    }

    @VisibleForTesting
    public VariantContext lowQualVariantToGQ0HomRef(VariantContext result, VariantContext originalVC) {
        if (!(!this.dropLowQuals || this.isHomRefCall(result) && result.getGenotype(0).isCalled())) {
            return null;
        }
        if (!result.getGenotype(0).isCalled()) {
            return new VariantContextBuilder(result).attributes(null).make();
        }
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        GenotypeBuilder gb = this.changeCallToGQ0HomRef(result, attrMap);
        if (this.isHomRefCall(originalVC)) {
            Genotype genotype = result.getGenotype(0);
            int[] idxVector = originalVC.getGLIndicesOfAlternateAllele(Allele.NON_REF_ALLELE);
            if (genotype.hasPL()) {
                int[] multiallelicPLs = genotype.getPL();
                int[] newPLs = new int[]{multiallelicPLs[idxVector[0]], multiallelicPLs[idxVector[1]], multiallelicPLs[idxVector[2]]};
                gb.PL(newPLs);
            }
            if (genotype.hasAD()) {
                int depth = (int)MathUtils.sum(genotype.getAD());
                gb.DP(depth);
                gb.attribute("MIN_DP", (Object)depth);
            }
        }
        VariantContextBuilder builder = new VariantContextBuilder(result);
        Genotype newG = gb.make();
        return builder.alleles(Arrays.asList((Allele)newG.getAlleles().get(0), Allele.NON_REF_ALLELE)).unfiltered().log10PError(1.0).attributes(attrMap).genotypes(new Genotype[]{newG}).make();
    }

    @VisibleForTesting
    protected GenotypeBuilder changeCallToGQ0HomRef(VariantContext result, Map<String, Object> attrMap) {
        Genotype genotype = result.getGenotype(0);
        Allele newRef = result.getReference();
        GenotypeBuilder gb = new GenotypeBuilder(genotype);
        if (result.getReference().length() > 1) {
            attrMap.put("END", result.getEnd());
            newRef = Allele.create((byte)newRef.getBases()[0], (boolean)true);
            gb.alleles(Collections.nCopies(2, newRef));
        }
        if (!this.isHomRefCall(result)) {
            gb.PL(new int[3]);
            gb.GQ(0).noAD().alleles(Collections.nCopies(2, newRef)).noAttributes();
        }
        return gb;
    }

    @VisibleForTesting
    protected VariantContext cleanUpHighQualityVariant(VariantContext result, VariantContext originalVC) {
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        Map origMap = originalVC.getAttributes();
        for (InfoFieldAnnotation annotation : this.annotationEngine.getInfoAnnotations()) {
            for (String key : annotation.getKeyNames()) {
                if (this.infoFieldAnnotationKeyNamesToRemove.contains(key) || !origMap.containsKey(key)) continue;
                attrMap.put(key, origMap.get(key));
            }
            if (!(annotation instanceof ReducibleAnnotation)) continue;
            for (String rawKey : ((ReducibleAnnotation)((Object)annotation)).getRawKeyNames()) {
                if (this.infoFieldAnnotationKeyNamesToRemove.contains(rawKey) || !origMap.containsKey(rawKey)) continue;
                attrMap.put(rawKey, origMap.get(rawKey));
            }
        }
        Genotype genotype = result.getGenotype(0);
        VariantContextBuilder builder = new VariantContextBuilder(result);
        builder.attributes(attrMap);
        boolean allelesNeedSubsetting = result.getNAlleles() != originalVC.getNAlleles();
        ArrayList<Allele> allelesToDrop = new ArrayList<Allele>();
        if (this.dropLowQuals) {
            for (Allele currAlt : result.getAlternateAlleles()) {
                boolean foundMatch = false;
                for (Allele gtAllele : genotype.getAlleles()) {
                    if (gtAllele.equals(currAlt, false)) {
                        foundMatch = true;
                        break;
                    }
                    if (!gtAllele.equals((Object)Allele.NON_REF_ALLELE)) continue;
                    if (this.dropLowQuals) {
                        return null;
                    }
                    GenotypeBuilder gb = this.changeCallToGQ0HomRef(result, attrMap);
                    return builder.alleles(Arrays.asList(result.getReference(), Allele.NON_REF_ALLELE)).unfiltered().log10PError(1.0).attributes(attrMap).genotypes(new Genotype[]{gb.make()}).make();
                }
                if (foundMatch || currAlt.isSymbolic()) continue;
                allelesNeedSubsetting = true;
                allelesToDrop.add(currAlt);
            }
        }
        int nonRefInd = result.getAlleleIndex(Allele.NON_REF_ALLELE);
        boolean genotypesWereModified = false;
        ArrayList<Genotype> genotypesArray = new ArrayList<Genotype>();
        GenotypesContext newGenotypes = result.getGenotypes();
        Genotype g = genotype;
        if (g.hasAD()) {
            int[] ad = g.getAD();
            if (ad.length >= nonRefInd && ad[nonRefInd] > 0) {
                genotypesWereModified = true;
                GenotypeBuilder gb = new GenotypeBuilder(g);
                ad[nonRefInd] = 0;
                gb.AD(ad).DP((int)MathUtils.sum(ad));
                genotypesArray.add(gb.make());
                newGenotypes = GenotypesContext.create(genotypesArray);
            }
        } else {
            genotypesArray.add(g);
        }
        if (!originalVC.hasAttribute("RAW_MQandDP")) {
            Integer rawMqValue = originalVC.hasAttribute("RAW_MQ") ? (int)Math.round(originalVC.getAttributeAsDouble("RAW_MQ", 0.0)) : (int)Math.round(originalVC.getAttributeAsDouble("MQ", 60.0) * originalVC.getAttributeAsDouble("MQ", 60.0) * (double)originalVC.getAttributeAsInt("DP", 0));
            attrMap.put("RAW_MQandDP", String.format("%d,%d", rawMqValue, originalVC.getAttributeAsInt("DP", 0)));
            if (originalVC.hasAttribute("RAW_MQ")) {
                attrMap.put("RAW_MQ", originalVC.getAttributeAsDouble("RAW_MQ", 0.0));
                attrMap.put("MQ_DP", originalVC.getAttributeAsInt("DP", 0));
            }
        }
        int[] relevantIndices = new int[result.getNAlleles()];
        ArrayList<Allele> newAlleleSet = new ArrayList<Allele>();
        for (Allele a2 : result.getAlleles()) {
            newAlleleSet.add(a2);
        }
        if (allelesNeedSubsetting) {
            GenotypesContext gc;
            newAlleleSet.removeAll(allelesToDrop);
            builder.alleles(newAlleleSet);
            if (!genotypesWereModified) {
                gc = AlleleSubsettingUtils.subsetAlleles(result.getGenotypes(), 2, result.getAlleles(), newAlleleSet, null, GenotypeAssignmentMethod.USE_PLS_TO_ASSIGN, result.getAttributeAsInt("DP", 0));
                builder.genotypes(gc);
            } else {
                gc = AlleleSubsettingUtils.subsetAlleles(newGenotypes, 2, result.getAlleles(), newAlleleSet, null, GenotypeAssignmentMethod.USE_PLS_TO_ASSIGN, result.getAttributeAsInt("DP", 0));
                builder.genotypes(gc);
            }
            g = gc.get(0);
            relevantIndices = newAlleleSet.stream().mapToInt(a -> originalVC.getAlleles().indexOf(a)).toArray();
        }
        for (InfoFieldAnnotation annotation : this.annotationEngine.getInfoAnnotations()) {
            for (String key : annotation.getKeyNames()) {
                if (this.infoFieldAnnotationKeyNamesToRemove.contains(key) || !origMap.containsKey(key)) continue;
                attrMap.put(key, origMap.get(key));
            }
            if (!(annotation instanceof ReducibleAnnotation)) continue;
            for (String rawKey : ((ReducibleAnnotation)((Object)annotation)).getRawKeyNames()) {
                if (this.infoFieldAnnotationKeyNamesToRemove.contains(rawKey) || !origMap.containsKey(rawKey)) continue;
                if (allelesNeedSubsetting && AnnotationUtils.isAlleleSpecific(annotation)) {
                    List<String> alleleSpecificValues = AnnotationUtils.getAlleleLengthListOfString(originalVC.getAttributeAsString(rawKey, null));
                    List<String> subsetList = alleleSpecificValues.size() > 0 ? AlleleSubsettingUtils.remapRLengthList(alleleSpecificValues, relevantIndices, "") : Collections.nCopies(relevantIndices.length, "");
                    attrMap.put(rawKey, AnnotationUtils.encodeAnyASListWithRawDelim(subsetList));
                    continue;
                }
                attrMap.put(rawKey, origMap.get(rawKey));
            }
        }
        if (this.doQualApprox && g.hasPL()) {
            attrMap.put("QUALapprox", g.getPL()[0]);
            int varDP = QualByDepth.getDepth(result.getGenotypes(), null);
            if (varDP == 0) {
                varDP = originalVC.getAttributeAsInt("DP", 1);
            }
            attrMap.put("VarDP", varDP);
            if (this.annotationEngine.getInfoAnnotations().stream().anyMatch(infoFieldAnnotation -> infoFieldAnnotation.getClass().getSimpleName().equals("AS_QualByDepth"))) {
                ArrayList<String> quals = new ArrayList<String>();
                for (Allele alt : newAlleleSet) {
                    if (alt.isReference()) continue;
                    if (alt.equals((Object)Allele.NON_REF_ALLELE)) {
                        quals.add("0");
                        continue;
                    }
                    GenotypesContext gc = AlleleSubsettingUtils.subsetAlleles(result.getGenotypes(), 2, result.getAlleles(), Arrays.asList(result.getReference(), alt), null, GenotypeAssignmentMethod.USE_PLS_TO_ASSIGN, result.getAttributeAsInt("DP", 0));
                    if (gc.get(0).hasPL()) {
                        quals.add(Integer.toString(gc.get(0).getPL()[0]));
                        continue;
                    }
                    quals.add("0");
                }
                attrMap.put("AS_QUALapprox", "|" + String.join((CharSequence)"|", quals));
                List<Integer> as_varDP = AS_QualByDepth.getAlleleDepths(AlleleSubsettingUtils.subsetAlleles(result.getGenotypes(), 2, result.getAlleles(), newAlleleSet, null, GenotypeAssignmentMethod.USE_PLS_TO_ASSIGN, result.getAttributeAsInt("DP", 0)));
                if (as_varDP != null) {
                    attrMap.put("AS_VarDP", as_varDP.stream().map(n -> Integer.toString(n)).collect(Collectors.joining("|")));
                }
            }
        } else {
            if (result.hasAttribute("AS_VarDP")) {
                attrMap.put("AS_VarDP", result.getAttribute("AS_VarDP"));
            }
            if (result.hasAttribute("QUALapprox")) {
                attrMap.put("QUALapprox", result.getAttribute("QUALapprox"));
            }
        }
        attrMap.put("RAW_GT_COUNT", g.getAlleles().stream().anyMatch(Allele::isReference) ? Arrays.asList(0, 1, 0) : Arrays.asList(0, 0, 1));
        builder.attributes(attrMap);
        if (allelesNeedSubsetting) {
            return GATKVariantContextUtils.reverseTrimAlleles(builder.attributes(attrMap).unfiltered().make());
        }
        return builder.attributes(attrMap).genotypes(newGenotypes).unfiltered().make();
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }
}

