/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.variantutils;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.VariantContextUtils;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import htsjdk.variant.vcf.VCFUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.engine.filters.CountingVariantFilter;
import org.broadinstitute.hellbender.engine.filters.VariantFilterLibrary;
import org.broadinstitute.hellbender.engine.filters.VariantIDsVariantFilter;
import org.broadinstitute.hellbender.engine.filters.VariantTypesVariantFilter;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.genomicsdb.GenomicsDBArgumentCollection;
import org.broadinstitute.hellbender.tools.genomicsdb.GenomicsDBOptions;
import org.broadinstitute.hellbender.tools.walkers.annotator.ChromosomeCounts;
import org.broadinstitute.hellbender.tools.walkers.genotyper.AlleleSubsettingUtils;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeAssignmentMethod;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.samples.MendelianViolation;
import org.broadinstitute.hellbender.utils.samples.SampleDB;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.hellbender.utils.variant.VcfUtils;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(summary="This tool makes it possible to select a subset of variants based on various criteria in order to facilitate certain analyses. Examples include comparing and contrasting cases vs. controls, extracting variant or non-variant loci that meet certain requirements, or troubleshooting some unexpected results, to name a few.", oneLineSummary="Select a subset of variants from a VCF file", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public final class SelectVariants
extends VariantWalker {
    private static final int MAX_FILTERED_GENOTYPES_DEFAULT_VALUE = Integer.MAX_VALUE;
    private static final double MAX_FRACTION_FILTERED_GENOTYPES_DEFAULT_VALUE = 1.0;
    private static final int MIN_FILTERED_GENOTYPES_DEFAULT_VALUE = 0;
    private static final double MIN_FRACTION_FILTERED_GENOTYPES_DEFAULT_VALUE = 0.0;
    private static final int MAX_NOCALL_NUMBER_DEFAULT_VALUE = Integer.MAX_VALUE;
    private static final double MAX_NOCALL_FRACTION_DEFAULT_VALUE = 1.0;
    @Argument(fullName="discordance", shortName="disc", doc="Output variants not called in this comparison track", optional=true)
    private FeatureInput<VariantContext> discordanceTrack;
    @Argument(fullName="concordance", shortName="conc", doc="Output variants also called in this comparison track", optional=true)
    private FeatureInput<VariantContext> concordanceTrack;
    @Argument(fullName="output", shortName="O", doc="Path to which variants should be written")
    public GATKPath vcfOutput = null;
    @Argument(fullName="sample-name", shortName="sn", doc="Include genotypes from this sample", optional=true)
    private Set<String> sampleNames = new LinkedHashSet<String>(0);
    @Argument(fullName="sample-expressions", shortName="se", doc="Regular expression to select multiple samples", optional=true)
    private Set<String> sampleExpressions = new LinkedHashSet<String>(0);
    @Argument(fullName="exclude-sample-name", shortName="xl-sn", doc="Exclude genotypes from this sample", optional=true)
    private Set<String> XLsampleNames = new LinkedHashSet<String>(0);
    @Argument(fullName="exclude-sample-expressions", shortName="xl-se", doc="List of sample expressions to exclude", optional=true)
    private Set<String> XLsampleExpressions = new LinkedHashSet<String>(0);
    @Argument(shortName="select", doc="One or more criteria to use when selecting the data", optional=true)
    private ArrayList<String> selectExpressions = new ArrayList();
    @Argument(shortName="invert-select", doc="Invert the selection criteria for -select", optional=true)
    private boolean invertSelect = false;
    @Argument(fullName="exclude-non-variants", doc="Don't include non-variant sites", optional=true)
    private boolean XLnonVariants = false;
    @Argument(fullName="exclude-filtered", doc="Don't include filtered sites", optional=true)
    private boolean XLfiltered = false;
    @Argument(fullName="preserve-alleles", doc="Preserve original alleles, do not trim", optional=true)
    private boolean preserveAlleles = false;
    @Argument(fullName="remove-unused-alternates", doc="Remove alternate alleles not present in any genotypes", optional=true)
    private boolean removeUnusedAlternates = false;
    @Argument(fullName="restrict-alleles-to", doc="Select only variants of a particular allelicity", optional=true)
    private NumberAlleleRestriction alleleRestriction = NumberAlleleRestriction.ALL;
    @Argument(fullName="keep-original-ac", doc="Store the original AC, AF, and AN values after subsetting", optional=true)
    private boolean keepOriginalChrCounts = false;
    @Argument(fullName="keep-original-dp", doc="Store the original DP value after subsetting", optional=true)
    private boolean keepOriginalDepth = false;
    @Argument(fullName="mendelian-violation", doc="Output mendelian violation sites only", optional=true)
    private Boolean mendelianViolations = false;
    @Argument(fullName="invert-mendelian-violation", doc="Output non-mendelian violation sites only", optional=true)
    private Boolean invertMendelianViolations = false;
    @Argument(fullName="mendelian-violation-qual-threshold", doc="Minimum GQ score for each trio member to accept a site as a violation", optional=true)
    private double mendelianViolationQualThreshold = 0.0;
    @Argument(fullName="pedigree", shortName="ped", doc="Pedigree file", optional=true)
    private GATKPath pedigreeFile = null;
    @Argument(fullName="select-random-fraction", shortName="fraction", doc="Select a fraction of variants at random from the input", optional=true)
    private double fractionRandom = 0.0;
    @Argument(fullName="remove-fraction-genotypes", doc="Select a fraction of genotypes at random from the input and sets them to no-call", optional=true)
    private double fractionGenotypes = 0.0;
    @Argument(fullName="select-type-to-include", shortName="select-type", doc="Select only a certain type of variants from the input file", optional=true)
    private List<VariantContext.Type> typesToInclude = new ArrayList<VariantContext.Type>();
    @Argument(fullName="select-type-to-exclude", shortName="xl-select-type", doc="Do not select certain type of variants from the input file", optional=true)
    private List<VariantContext.Type> typesToExclude = new ArrayList<VariantContext.Type>();
    @Argument(fullName="keep-ids", shortName="ids", doc="List of variant rsIDs to select", optional=true)
    private Set<String> rsIDsToKeep = new HashSet<String>();
    @Argument(fullName="exclude-ids", shortName="xl-ids", doc="List of variant rsIDs to exclude", optional=true)
    private Set<String> rsIDsToRemove = new HashSet<String>();
    @Hidden
    @Argument(fullName="fully-decode", doc="If true, the incoming VariantContext will be fully decoded", optional=true)
    private boolean fullyDecode = false;
    @Argument(fullName="max-indel-size", optional=true, doc="Maximum size of indels to include")
    private int maxIndelSize = Integer.MAX_VALUE;
    @Argument(fullName="min-indel-size", optional=true, doc="Minimum size of indels to include")
    private int minIndelSize = 0;
    @Argument(fullName="max-filtered-genotypes", optional=true, doc="Maximum number of samples filtered at the genotype level")
    private int maxFilteredGenotypes = Integer.MAX_VALUE;
    @Argument(fullName="min-filtered-genotypes", optional=true, doc="Minimum number of samples filtered at the genotype level")
    private int minFilteredGenotypes = 0;
    @Argument(fullName="max-fraction-filtered-genotypes", optional=true, doc="Maximum fraction of samples filtered at the genotype level")
    private double maxFractionFilteredGenotypes = 1.0;
    @Argument(fullName="min-fraction-filtered-genotypes", optional=true, doc="Maximum fraction of samples filtered at the genotype level")
    private double minFractionFilteredGenotypes = 0.0;
    @Argument(fullName="max-nocall-number", optional=true, doc="Maximum number of samples with no-call genotypes")
    private int maxNOCALLnumber = Integer.MAX_VALUE;
    @Argument(fullName="max-nocall-fraction", optional=true, doc="Maximum fraction of samples with no-call genotypes")
    private double maxNOCALLfraction = 1.0;
    @Argument(fullName="set-filtered-gt-to-nocall", optional=true, doc="Set filtered genotypes to no-call")
    private boolean setFilteredGenotypesToNocall = false;
    @Argument(fullName="drop-info-annotation", shortName="DA", optional=true, doc="Info annotations to drop from output vcf.  Annotations to be dropped are specified by their key.")
    private List<String> infoAnnotationsToDrop = new ArrayList<String>();
    @Argument(fullName="drop-genotype-annotation", shortName="DGA", optional=true, doc="Genotype annotations to drop from output vcf.  Annotations to be dropped are specified by their key.")
    private List<String> genotypeAnnotationsToDrop = new ArrayList<String>();
    @Hidden
    @Argument(fullName="allow-nonoverlapping-command-line-samples", optional=true, doc="Allow samples other than those in the VCF to be specified on the command line. These samples will be ignored.")
    private boolean allowNonOverlappingCommandLineSamples = false;
    @Hidden
    @Argument(fullName="suppress-reference-path", optional=true, doc="Suppress reference path in output for test result differencing")
    private boolean suppressReferencePath = false;
    @ArgumentCollection
    private GenomicsDBArgumentCollection genomicsdbArgs = new GenomicsDBArgumentCollection();
    private VariantContextWriter vcfWriter = null;
    private SortedSet<String> samples = new TreeSet<String>();
    private boolean noSamplesSpecified = false;
    private Set<VariantContext.Type> selectedTypes = new LinkedHashSet<VariantContext.Type>();
    private final ArrayList<String> selectNames = new ArrayList();
    private List<VariantContextUtils.JexlVCMatchExp> jexls = null;
    private boolean discordanceOnly = false;
    private boolean concordanceOnly = false;
    private MendelianViolation mv = null;
    private SampleDB sampleDB = null;
    private boolean selectRandomFraction = false;
    private final Random randomGenotypes = new Random();
    private final List<Allele> diploidNoCallAlleles = GATKVariantContextUtils.noCallAlleles(2);
    private final Map<Integer, Integer> ploidyToNumberOfAlleles = new LinkedHashMap<Integer, Integer>();
    private final PriorityQueue<VariantContext> pendingVariants = new PriorityQueue<VariantContext>(Comparator.comparingInt(VariantContext::getStart));

    @Override
    protected GenomicsDBOptions getGenomicsDBOptions() {
        if (this.genomicsDBOptions == null) {
            this.genomicsDBOptions = new GenomicsDBOptions(this.referenceArguments.getReferencePath(), this.genomicsdbArgs);
        }
        return this.genomicsDBOptions;
    }

    @Override
    public void onTraversalStart() {
        Map<String, VCFHeader> vcfHeaders = Collections.singletonMap(this.getDrivingVariantsFeatureInput().getName(), this.getHeaderForVariants());
        Set<VCFHeaderLine> headerLines = this.createVCFHeaderLineList(vcfHeaders);
        for (int i = 0; i < this.selectExpressions.size(); ++i) {
            this.selectNames.add(String.format("select-%d", i));
        }
        this.jexls = VariantContextUtils.initializeMatchExps(this.selectNames, this.selectExpressions);
        this.samples = this.createSampleNameInclusionList(vcfHeaders);
        this.selectedTypes = this.createSampleTypeInclusionList();
        boolean bl = this.discordanceOnly = this.discordanceTrack != null;
        if (this.discordanceOnly) {
            this.logger.info("Selecting only variants discordant with the track: " + this.discordanceTrack.getName());
        }
        boolean bl2 = this.concordanceOnly = this.concordanceTrack != null;
        if (this.concordanceOnly) {
            this.logger.info("Selecting only variants concordant with the track: " + this.concordanceTrack.getName());
        }
        if (this.mendelianViolations.booleanValue()) {
            this.sampleDB = SampleDB.createSampleDBFromPedigree(this.pedigreeFile);
            this.mv = new MendelianViolation(this.mendelianViolationQualThreshold, false, true);
        }
        boolean bl3 = this.selectRandomFraction = this.fractionRandom > 0.0;
        if (this.selectRandomFraction) {
            this.logger.info("Selecting approximately " + 100.0 * this.fractionRandom + "% of the variants at random from the variant track");
        }
        Set<VCFHeaderLine> actualLines = null;
        SAMSequenceDictionary sequenceDictionary = null;
        if (this.hasReference()) {
            Iterator<String> refPath = this.referenceArguments.getReferencePath();
            sequenceDictionary = this.getReferenceDictionary();
            actualLines = VcfUtils.updateHeaderContigLines(headerLines, (Path)((Object)refPath), sequenceDictionary, this.suppressReferencePath);
        } else {
            sequenceDictionary = this.getHeaderForVariants().getSequenceDictionary();
            actualLines = null != sequenceDictionary ? VcfUtils.updateHeaderContigLines(headerLines, null, sequenceDictionary, this.suppressReferencePath) : headerLines;
        }
        if (!this.infoAnnotationsToDrop.isEmpty()) {
            for (String infoField : this.infoAnnotationsToDrop) {
                this.logger.info(String.format("Will drop info annotation: %s", infoField));
            }
        }
        if (!this.genotypeAnnotationsToDrop.isEmpty()) {
            for (String genotypeAnnotation : this.genotypeAnnotationsToDrop) {
                this.logger.info(String.format("Will drop genotype annotation: %s", genotypeAnnotation));
            }
        }
        Path outPath = this.vcfOutput.toPath();
        this.vcfWriter = this.createVCFWriter(outPath);
        this.vcfWriter.writeHeader(new VCFHeader(actualLines, this.samples));
    }

    @Override
    public void apply(VariantContext vc, ReadsContext readsContext, ReferenceContext ref, FeatureContext featureContext) {
        VariantContext filteredGenotypeToNocall;
        while (!(this.pendingVariants.isEmpty() || this.pendingVariants.peek().getStart() > vc.getStart() && this.pendingVariants.peek().getContig().equals(vc.getContig()))) {
            this.vcfWriter.add(this.pendingVariants.poll());
        }
        if (this.fullyDecode) {
            vc = vc.fullyDecode(this.getHeaderForVariants(), this.lenientVCFProcessing);
        }
        if (this.mendelianViolations.booleanValue() && SelectVariants.invertLogic(this.mv.countFamilyViolations(this.sampleDB, this.samples, vc) == 0, this.invertMendelianViolations)) {
            return;
        }
        if (this.discordanceOnly && !this.isDiscordant(vc, featureContext.getValues(this.discordanceTrack))) {
            return;
        }
        if (this.concordanceOnly && !this.isConcordant(vc, featureContext.getValues(this.concordanceTrack))) {
            return;
        }
        if (this.alleleRestriction.equals((Object)NumberAlleleRestriction.BIALLELIC) && !vc.isBiallelic()) {
            return;
        }
        if (this.alleleRestriction.equals((Object)NumberAlleleRestriction.MULTIALLELIC) && vc.isBiallelic()) {
            return;
        }
        if (SelectVariants.containsIndelLargerOrSmallerThan(vc, this.maxIndelSize, this.minIndelSize)) {
            return;
        }
        if (this.considerFilteredGenotypes()) {
            double fractionFilteredGenotypes;
            int numFilteredSamples = this.numFilteredGenotypes(vc);
            double d = fractionFilteredGenotypes = this.samples.isEmpty() ? 0.0 : (double)(numFilteredSamples / this.samples.size());
            if (numFilteredSamples > this.maxFilteredGenotypes || numFilteredSamples < this.minFilteredGenotypes || fractionFilteredGenotypes > this.maxFractionFilteredGenotypes || fractionFilteredGenotypes < this.minFractionFilteredGenotypes) {
                return;
            }
        }
        if (this.considerNoCallGenotypes()) {
            double fractionNoCallGenotypes;
            int numNoCallSamples = this.numNoCallGenotypes(vc);
            double d = fractionNoCallGenotypes = this.samples.isEmpty() ? 0.0 : (double)numNoCallSamples / (double)this.samples.size();
            if (numNoCallSamples > this.maxNOCALLnumber || fractionNoCallGenotypes > this.maxNOCALLfraction) {
                return;
            }
        }
        VariantContext sub = this.subsetRecord(vc, this.preserveAlleles, this.removeUnusedAlternates);
        if (this.setFilteredGenotypesToNocall) {
            VariantContextBuilder builder = new VariantContextBuilder(sub);
            GATKVariantContextUtils.setFilteredGenotypeToNocall(builder, sub, this.setFilteredGenotypesToNocall, this::getGenotypeFilters);
            filteredGenotypeToNocall = builder.make();
        } else {
            filteredGenotypeToNocall = sub;
        }
        if (!(this.XLnonVariants && (!filteredGenotypeToNocall.isPolymorphicInSamples() || GATKVariantContextUtils.isSpanningDeletionOnly(filteredGenotypeToNocall)) || this.XLfiltered && filteredGenotypeToNocall.isFiltered())) {
            boolean failedJexlMatch = false;
            try {
                for (VariantContextUtils.JexlVCMatchExp jexl : this.jexls) {
                    if (!SelectVariants.invertLogic(!VariantContextUtils.match((VariantContext)filteredGenotypeToNocall, (VariantContextUtils.JexlVCMatchExp)jexl), this.invertSelect)) continue;
                    failedJexlMatch = true;
                    break;
                }
            }
            catch (IllegalArgumentException e) {
                throw new UserException(e.getMessage() + "\nSee https://gatk.broadinstitute.org/hc/en-us/articles/360035891011-JEXL-filtering-expressions for documentation on using JEXL in GATK", e);
            }
            if (!(failedJexlMatch || this.selectRandomFraction && !(Utils.getRandomGenerator().nextDouble() < this.fractionRandom))) {
                VariantContext variantContextToWrite = this.buildVariantContextWithDroppedAnnotationsRemoved(filteredGenotypeToNocall);
                this.pendingVariants.add(variantContextToWrite);
            }
        }
    }

    @Override
    public Object onTraversalSuccess() {
        while (!this.pendingVariants.isEmpty()) {
            this.vcfWriter.add(this.pendingVariants.poll());
        }
        return null;
    }

    private VariantContext buildVariantContextWithDroppedAnnotationsRemoved(VariantContext vc) {
        if (this.infoAnnotationsToDrop.isEmpty() && this.genotypeAnnotationsToDrop.isEmpty()) {
            return vc;
        }
        VariantContextBuilder rmAnnotationsBuilder = new VariantContextBuilder(vc);
        for (String infoField : this.infoAnnotationsToDrop) {
            rmAnnotationsBuilder.rmAttribute(infoField);
        }
        if (!this.genotypeAnnotationsToDrop.isEmpty()) {
            ArrayList<Genotype> genotypesToWrite = new ArrayList<Genotype>();
            for (Genotype genotype : vc.getGenotypes()) {
                GenotypeBuilder genotypeBuilder = new GenotypeBuilder(genotype).noAttributes();
                HashMap attributes = new HashMap(genotype.getExtendedAttributes());
                for (String genotypeAnnotation : this.genotypeAnnotationsToDrop) {
                    attributes.remove(genotypeAnnotation);
                }
                genotypeBuilder.attributes(attributes);
                genotypesToWrite.add(genotypeBuilder.make());
            }
            rmAnnotationsBuilder.genotypes(GenotypesContext.create(genotypesToWrite));
        }
        return rmAnnotationsBuilder.make();
    }

    private List<String> getGenotypeFilters(VariantContext vc, Genotype g) {
        ArrayList<String> filters = new ArrayList<String>();
        if (g.isFiltered()) {
            filters.add(g.getFilters());
        }
        return filters;
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }

    @Override
    protected CountingVariantFilter makeVariantFilter() {
        CountingVariantFilter compositeFilter = new CountingVariantFilter(VariantFilterLibrary.ALLOW_ALL_VARIANTS);
        if (!this.selectedTypes.isEmpty()) {
            compositeFilter = compositeFilter.and(new CountingVariantFilter(new VariantTypesVariantFilter(this.selectedTypes)));
        }
        if (this.rsIDsToKeep != null && !this.rsIDsToKeep.isEmpty()) {
            compositeFilter = compositeFilter.and(new CountingVariantFilter(new VariantIDsVariantFilter(this.rsIDsToKeep)));
        }
        if (this.rsIDsToRemove != null && !this.rsIDsToRemove.isEmpty()) {
            compositeFilter = compositeFilter.and(new CountingVariantFilter(new VariantIDsVariantFilter(this.rsIDsToRemove).negate()));
        }
        return compositeFilter;
    }

    private SortedSet<String> createSampleNameInclusionList(Map<String, VCFHeader> vcfHeaders) {
        SortedSet<String> vcfSamples = VcfUtils.getSortedSampleSet(vcfHeaders, GATKVariantContextUtils.GenotypeMergeType.REQUIRE_UNIQUE);
        Set<String> samplesFromExpressions = Utils.filterCollectionByExpressions(vcfSamples, this.sampleExpressions, false);
        LinkedHashSet<String> samplesNotInHeader = new LinkedHashSet<String>(samplesFromExpressions.size() + this.sampleNames.size());
        samplesNotInHeader.addAll(samplesFromExpressions);
        samplesNotInHeader.addAll(this.sampleNames);
        samplesNotInHeader.removeAll(vcfSamples);
        this.samples.addAll(this.sampleNames);
        this.samples.addAll(samplesFromExpressions);
        this.logger.debug(Utils.join(",", samplesNotInHeader));
        if (!samplesNotInHeader.isEmpty()) {
            if (this.allowNonOverlappingCommandLineSamples) {
                this.logger.warn("Samples present on command line input that are not present in the VCF. These samples will be ignored.");
                this.samples.removeAll(samplesNotInHeader);
            } else {
                throw new UserException.BadInput(String.format("%s%n%n%s%n%n%s%n%n%s", "Samples entered on command line (through -sf or -sn) that are not present in the VCF.", "A list of these samples:", Utils.join(",", samplesNotInHeader), "To ignore these samples, run with --allow-nonoverlapping-command-line-samples"));
            }
        }
        if (this.samples.isEmpty()) {
            this.samples.addAll(vcfSamples);
            this.noSamplesSpecified = true;
        }
        Set<String> XLsamplesFromExpressions = Utils.filterCollectionByExpressions(vcfSamples, this.XLsampleExpressions, false);
        this.samples.removeAll(this.XLsampleNames);
        this.samples.removeAll(XLsamplesFromExpressions);
        boolean bl = this.noSamplesSpecified = this.noSamplesSpecified && this.XLsampleNames.isEmpty() && XLsamplesFromExpressions.isEmpty();
        if (this.samples.isEmpty() && !this.noSamplesSpecified) {
            throw new UserException("All samples requested to be included were also requested to be excluded.");
        }
        if (!this.noSamplesSpecified) {
            for (String sample : this.samples) {
                this.logger.info("Including sample '" + sample + "'");
            }
        }
        return this.samples;
    }

    private Set<VariantContext.Type> createSampleTypeInclusionList() {
        if (this.typesToInclude.isEmpty()) {
            this.selectedTypes.addAll(Arrays.asList(VariantContext.Type.values()));
        } else {
            this.selectedTypes.addAll(this.typesToInclude);
        }
        this.selectedTypes.removeAll(this.typesToExclude);
        return this.selectedTypes;
    }

    private Set<VCFHeaderLine> createVCFHeaderLineList(Map<String, VCFHeader> vcfHeaders) {
        Set headerLines = VCFUtils.smartMergeHeaders(vcfHeaders.values(), (boolean)true);
        headerLines.addAll(this.getDefaultToolVCFHeaderLines());
        if (this.keepOriginalChrCounts) {
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AC_Orig"));
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AF_Orig"));
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AN_Orig"));
        }
        if (this.keepOriginalDepth) {
            headerLines.add(GATKVCFHeaderLines.getInfoLine("DP_Orig"));
        }
        for (String key : ChromosomeCounts.keyNames) {
            headerLines.removeIf(line -> line instanceof VCFInfoHeaderLine && ((VCFInfoHeaderLine)line).getID().equals(key));
            headerLines.add(VCFStandardHeaderLines.getInfoLine((String)key));
        }
        headerLines.removeIf(line -> line instanceof VCFInfoHeaderLine && ((VCFInfoHeaderLine)line).getID().equals("DP"));
        headerLines.add(VCFStandardHeaderLines.getInfoLine((String)"DP"));
        headerLines.removeIf(l -> l instanceof VCFInfoHeaderLine && this.infoAnnotationsToDrop.contains(((VCFInfoHeaderLine)l).getID()));
        headerLines.removeIf(l -> l instanceof VCFFormatHeaderLine && this.genotypeAnnotationsToDrop.contains(((VCFFormatHeaderLine)l).getID()));
        return headerLines;
    }

    private static boolean invertLogic(boolean logic, boolean invert) {
        return invert ? !logic : logic;
    }

    protected static boolean containsIndelLargerOrSmallerThan(VariantContext vc, int maxIndelSize, int minIndelSize) {
        List lengths = vc.getIndelLengths();
        if (lengths == null) {
            return false;
        }
        for (Integer indelLength : lengths) {
            if (Math.abs(indelLength) <= maxIndelSize && Math.abs(indelLength) >= minIndelSize) continue;
            return true;
        }
        return false;
    }

    private int numNoCallGenotypes(VariantContext vc) {
        return this.numGenotypes(vc, Genotype::isNoCall);
    }

    private int numFilteredGenotypes(VariantContext vc) {
        return this.numGenotypes(vc, g -> g.isFiltered() && !g.getFilters().isEmpty());
    }

    private int numGenotypes(VariantContext vc, Predicate<Genotype> f) {
        return vc == null ? 0 : (int)vc.getGenotypes(this.samples).stream().filter(f).count();
    }

    private boolean isDiscordant(VariantContext vc, Collection<VariantContext> compVCs) {
        if (vc == null) {
            return false;
        }
        if (this.noSamplesSpecified) {
            return compVCs == null || compVCs.isEmpty();
        }
        GenotypesContext genotypes = vc.getGenotypes(this.samples);
        for (Genotype g : genotypes) {
            if (!this.sampleHasVariant(g)) continue;
            if (compVCs == null) {
                return true;
            }
            boolean foundVariant = false;
            for (VariantContext compVC : compVCs) {
                if (!this.haveSameGenotypes(g, compVC.getGenotype(g.getSampleName()))) continue;
                foundVariant = true;
                break;
            }
            if (foundVariant) continue;
            return true;
        }
        return false;
    }

    private boolean isConcordant(VariantContext vc, Collection<VariantContext> compVCs) {
        if (vc == null || compVCs == null || compVCs.isEmpty()) {
            return false;
        }
        if (this.noSamplesSpecified) {
            return true;
        }
        Set variantSamples = vc.getSampleNames();
        variantSamples.retainAll(this.samples);
        for (String sample : variantSamples) {
            boolean foundSample = false;
            for (VariantContext compVC : compVCs) {
                Genotype compG;
                Genotype varG = vc.getGenotype(sample);
                if (!this.haveSameGenotypes(varG, compG = compVC.getGenotype(sample))) continue;
                foundSample = true;
                break;
            }
            if (foundSample) continue;
            return false;
        }
        return true;
    }

    private boolean sampleHasVariant(Genotype g) {
        return g != null && !g.isHomRef() && (g.isCalled() || g.isFiltered() && !this.XLfiltered);
    }

    private boolean haveSameGenotypes(Genotype g1, Genotype g2) {
        List a2s;
        if (g1 == null || g2 == null) {
            return false;
        }
        if (g1.isCalled() && g2.isFiltered() || g2.isCalled() && g1.isFiltered() || g1.isFiltered() && g2.isFiltered() && this.XLfiltered) {
            return false;
        }
        List a1s = g1.getAlleles();
        return a1s.containsAll(a2s = g2.getAlleles()) && a2s.containsAll(a1s);
    }

    private VariantContext subsetRecord(VariantContext vc, boolean preserveAlleles, boolean removeUnusedAlternates) {
        GenotypesContext newGC;
        if (this.noSamplesSpecified && !removeUnusedAlternates) {
            return vc;
        }
        VariantContext sub = vc.subContextFromSamples(this.samples, removeUnusedAlternates);
        if (sub.getNSamples() == vc.getNSamples() && sub.getNAlleles() == vc.getNAlleles()) {
            return vc;
        }
        GenotypesContext oldGs = sub.getGenotypes();
        GenotypesContext genotypesContext = newGC = sub.getNAlleles() == vc.getNAlleles() ? oldGs : AlleleSubsettingUtils.subsetAlleles(oldGs, 0, vc.getAlleles(), sub.getAlleles(), null, GenotypeAssignmentMethod.DO_NOT_ASSIGN_GENOTYPES, vc.getAttributeAsInt("DP", 0));
        if (this.fractionGenotypes > 0.0) {
            List genotypes = newGC.stream().map(genotype -> this.randomGenotypes.nextDouble() > this.fractionGenotypes ? genotype : new GenotypeBuilder(genotype).alleles(this.getNoCallAlleles(genotype.getPloidy())).noGQ().make()).collect(Collectors.toList());
            newGC = GenotypesContext.create(new ArrayList(genotypes));
        }
        VariantContextBuilder builder = new VariantContextBuilder(sub);
        builder.rmAttributes(Arrays.asList("MLEAC", "MLEAF"));
        builder.genotypes(newGC);
        this.addAnnotations(builder, vc, sub.getSampleNames());
        VariantContext subset = builder.make();
        return preserveAlleles ? subset : GATKVariantContextUtils.trimAlleles(subset, true, true);
    }

    private List<Allele> getNoCallAlleles(int ploidy) {
        return ploidy == 2 ? this.diploidNoCallAlleles : GATKVariantContextUtils.noCallAlleles(ploidy);
    }

    private void addAnnotations(VariantContextBuilder builder, VariantContext originalVC, Set<String> selectedSampleNames) {
        if (this.fullyDecode) {
            return;
        }
        if (this.keepOriginalChrCounts) {
            int[] indexOfOriginalAlleleForNewAllele;
            List newAlleles = builder.getAlleles();
            int numOriginalAlleles = originalVC.getNAlleles();
            if (numOriginalAlleles == newAlleles.size()) {
                indexOfOriginalAlleleForNewAllele = null;
            } else {
                indexOfOriginalAlleleForNewAllele = new int[newAlleles.size() - 1];
                Arrays.fill(indexOfOriginalAlleleForNewAllele, -1);
                block0: for (int newI = 1; newI < newAlleles.size(); ++newI) {
                    Allele newAlt = (Allele)newAlleles.get(newI);
                    for (int oldI = 0; oldI < numOriginalAlleles - 1; ++oldI) {
                        if (!newAlt.equals(originalVC.getAlternateAllele(oldI), false)) continue;
                        indexOfOriginalAlleleForNewAllele[newI - 1] = oldI;
                        continue block0;
                    }
                }
            }
            if (originalVC.hasAttribute("AC")) {
                builder.attribute("AC_Orig", this.getReorderedAttributes(originalVC.getAttribute("AC"), indexOfOriginalAlleleForNewAllele));
            }
            if (originalVC.hasAttribute("AF")) {
                builder.attribute("AF_Orig", this.getReorderedAttributes(originalVC.getAttribute("AF"), indexOfOriginalAlleleForNewAllele));
            }
            if (originalVC.hasAttribute("AN")) {
                builder.attribute("AN_Orig", originalVC.getAttribute("AN"));
            }
        }
        VariantContextUtils.calculateChromosomeCounts((VariantContextBuilder)builder, (boolean)false);
        if (this.keepOriginalDepth && originalVC.hasAttribute("DP")) {
            builder.attribute("DP_Orig", originalVC.getAttribute("DP"));
        }
        boolean sawDP = false;
        int depth = 0;
        for (String sample : selectedSampleNames) {
            Genotype g = originalVC.getGenotype(sample);
            if (g.isFiltered() || !g.hasDP()) continue;
            depth += g.getDP();
            sawDP = true;
        }
        if (sawDP) {
            builder.attribute("DP", (Object)depth);
        }
    }

    private Object getReorderedAttributes(Object attribute, int[] oldToNewIndexOrdering) {
        if (oldToNewIndexOrdering == null) {
            return attribute;
        }
        Object[] tokens = attribute.getClass().isArray() ? (Object[])attribute : (List.class.isAssignableFrom(attribute.getClass()) ? ((List)attribute).toArray() : attribute.toString().split(","));
        Utils.validateArg(Arrays.stream(oldToNewIndexOrdering).allMatch(index -> index < tokens.length), () -> "the old attribute has an incorrect number of elements: " + attribute);
        return Arrays.stream(oldToNewIndexOrdering).mapToObj(index -> tokens[index]).collect(Collectors.toList());
    }

    private boolean considerFilteredGenotypes() {
        return this.maxFilteredGenotypes != Integer.MAX_VALUE || this.minFilteredGenotypes != 0 || this.maxFractionFilteredGenotypes != 1.0 || this.minFractionFilteredGenotypes != 0.0;
    }

    private boolean considerNoCallGenotypes() {
        return this.maxNOCALLnumber != Integer.MAX_VALUE || this.maxNOCALLfraction != 1.0;
    }

    private static enum NumberAlleleRestriction {
        ALL,
        BIALLELIC,
        MULTIALLELIC;

    }
}

