/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.variantutils;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.variant.utils.SAMSequenceDictionaryExtractor;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.exceptions.UserException;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(summary="Updates the sequence dictionary in a variant file using the dictionary from another variant, alignment, dictionary, or reference file. The dictionary must be valid for all variants in the target file.", oneLineSummary="Updates the sequence dictionary in a variant file.", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public final class UpdateVCFSequenceDictionary
extends VariantWalker {
    private static final Logger logger = LogManager.getLogger(UpdateVCFSequenceDictionary.class);
    @Argument(fullName="output", shortName="O", doc="File to which updated variants should be written")
    public GATKPath outFile = null;
    public static final String DICTIONARY_ARGUMENT_NAME = "source-dictionary";
    @Argument(fullName="source-dictionary", doc="A variant, alignment, dictionary, or reference file to use as a dictionary source (optional if the sequence dictionary source is specified as a reference argument). The dictionary presented must be valid (contain a sequence record) for each sequence that is referenced by any variant in the input file.", optional=true)
    GATKPath dictionarySource;
    public static final String REPLACE_ARGUMENT_NAME = "replace";
    @Argument(fullName="replace", doc="Force replacement of the dictionary if the input file already has a dictionary", optional=true)
    boolean replace = false;
    private VariantContextWriter vcfWriter;
    private SAMSequenceDictionary sourceDictionary;

    @Override
    public void onTraversalStart() {
        VCFHeader inputHeader = this.getHeaderForVariants();
        VCFHeader outputHeader = inputHeader == null ? new VCFHeader() : new VCFHeader(inputHeader.getMetaDataInInputOrder(), inputHeader.getGenotypeSamples());
        this.getDefaultToolVCFHeaderLines().forEach(line -> outputHeader.addMetaDataLine(line));
        this.sourceDictionary = this.getBestAvailableSequenceDictionary();
        if (!this.replace) {
            SAMSequenceDictionary oldDictionary;
            SAMSequenceDictionary sAMSequenceDictionary = oldDictionary = inputHeader == null ? null : inputHeader.getSequenceDictionary();
            if (oldDictionary != null && !oldDictionary.getSequences().isEmpty()) {
                throw new CommandLineException.BadArgumentValue(String.format("The input variant file %s already contains a sequence dictionary. Use %s to force the dictionary to be replaced.", this.getDrivingVariantsFeatureInput().getName(), REPLACE_ARGUMENT_NAME));
            }
        }
        outputHeader.setSequenceDictionary(this.sourceDictionary);
        this.vcfWriter = this.createVCFWriter(this.outFile);
        this.vcfWriter.writeHeader(outputHeader);
    }

    @Override
    public void apply(VariantContext vc, ReadsContext readsContext, ReferenceContext ref, FeatureContext featureContext) {
        SAMSequenceRecord samSeqRec = this.sourceDictionary.getSequence(vc.getContig());
        if (samSeqRec == null) {
            throw new CommandLineException.BadArgumentValue(String.format("The input variant file contains a variant (ID: \"%s\") with a reference to a sequence (\"%s\") that is not present in the provided dictionary", vc.getID(), vc.getContig()));
        }
        if (vc.getEnd() > samSeqRec.getSequenceLength()) {
            throw new CommandLineException.BadArgumentValue(String.format("The input variant file contains a variant (ID: \"%s\") with a reference to a sequence (\"%s\") that ends at a position (%d) that exceeds the length of that sequence (%d) in the provided dictionary", vc.getID(), vc.getContig(), vc.getEnd(), samSeqRec.getSequenceLength()));
        }
        this.vcfWriter.add(vc);
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SAMSequenceDictionary getBestAvailableSequenceDictionary() {
        SAMSequenceDictionary resultDictionary;
        SAMSequenceDictionary masterDictionary = this.getMasterSequenceDictionary();
        if (this.dictionarySource == null) {
            if (masterDictionary != null) {
                logger.warn("Using the dictionary supplied via the {} argument", new Object[]{"sequence-dictionary"});
                resultDictionary = masterDictionary;
            } else {
                if (!this.hasReference()) throw new CommandLineException.MissingArgument(DICTIONARY_ARGUMENT_NAME, "A dictionary source file or reference file must be provided");
                resultDictionary = this.getReferenceDictionary();
            }
        } else {
            if (masterDictionary != null) {
                throw new CommandLineException(String.format("Only one of %s or %s may be specified on the command line", "sequence-dictionary", DICTIONARY_ARGUMENT_NAME));
            }
            resultDictionary = SAMSequenceDictionaryExtractor.extractDictionary((Path)this.dictionarySource.toPath());
            if (resultDictionary == null || resultDictionary.getSequences().isEmpty()) {
                throw new CommandLineException.BadArgumentValue(String.format("The specified dictionary source has an empty or invalid sequence dictionary: %s", this.dictionarySource));
            }
        }
        if (!this.seqValidationArguments.performSequenceDictionaryValidation() || resultDictionary == null || !this.dictionaryHasMissingLengths(resultDictionary)) return resultDictionary;
        throw new UserException.SequenceDictionaryIsMissingContigLengths(this.dictionarySource.getRawInputString(), resultDictionary);
    }

    private boolean dictionaryHasMissingLengths(SAMSequenceDictionary resultDictionary) {
        return resultDictionary.getSequences().stream().anyMatch(s -> s.getSequenceLength() == 0);
    }
}

